/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;

public class SMIMEEnvelopedParser
extends CMSEnvelopedDataParser {
    private final MimePart message;

    private static InputStream getInputStream(Part part, int n2) throws MessagingException {
        try {
            InputStream inputStream = part.getInputStream();
            if (n2 == 0) {
                return new BufferedInputStream(inputStream);
            }
            return new BufferedInputStream(inputStream, n2);
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    public SMIMEEnvelopedParser(MimeBodyPart mimeBodyPart) throws IOException, MessagingException, CMSException {
        this(mimeBodyPart, 0);
    }

    public SMIMEEnvelopedParser(MimeMessage mimeMessage) throws IOException, MessagingException, CMSException {
        this(mimeMessage, 0);
    }

    public SMIMEEnvelopedParser(MimeBodyPart mimeBodyPart, int n2) throws IOException, MessagingException, CMSException {
        super(SMIMEEnvelopedParser.getInputStream(mimeBodyPart, n2));
        this.message = mimeBodyPart;
    }

    public SMIMEEnvelopedParser(MimeMessage mimeMessage, int n2) throws IOException, MessagingException, CMSException {
        super(SMIMEEnvelopedParser.getInputStream(mimeMessage, n2));
        this.message = mimeMessage;
    }

    public MimePart getEncryptedContent() {
        return this.message;
    }
}

