/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class ReadLargeSignedMail {
    private static void verify(SMIMESignedParser sMIMESignedParser) throws Exception {
        CertStore certStore = sMIMESignedParser.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signerInformationStore = sMIMESignedParser.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection<? extends Certificate> collection2;
            Iterator<? extends Certificate> iterator2;
            X509Certificate x509Certificate;
            SignerInformation signerInformation = (SignerInformation)iterator.next();
            if (signerInformation.verify(x509Certificate = (X509Certificate)(iterator2 = (collection2 = certStore.getCertificates(signerInformation.getSID())).iterator()).next(), "BC")) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance(properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, new SharedFileInputStream("signed.message"));
        if (mimeMessage.isMimeType("multipart/signed")) {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser((MimeMultipart)mimeMessage.getContent());
            System.out.println("Status:");
            ReadLargeSignedMail.verify(sMIMESignedParser);
        } else if (mimeMessage.isMimeType("application/pkcs7-mime")) {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser(mimeMessage);
            System.out.println("Status:");
            ReadLargeSignedMail.verify(sMIMESignedParser);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

