/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.Accuracy;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPUtil;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampToken;

public class TimeStampTokenGenerator {
    int accuracySeconds = -1;
    int accuracyMillis = -1;
    int accuracyMicros = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private String tsaPolicyOID;
    PrivateKey key;
    X509Certificate cert;
    String digestOID;
    AttributeTable signedAttr;
    AttributeTable unsignedAttr;
    CertStore certsAndCrls;

    public TimeStampTokenGenerator(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws IllegalArgumentException, TSPException {
        this(privateKey, x509Certificate, string, string2, null, null);
    }

    public TimeStampTokenGenerator(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException, TSPException {
        this.key = privateKey;
        this.cert = x509Certificate;
        this.digestOID = string;
        this.tsaPolicyOID = string2;
        this.unsignedAttr = attributeTable2;
        TSPUtil.validateCertificate(x509Certificate);
        Hashtable<DERObjectIdentifier, Attribute> hashtable = null;
        hashtable = attributeTable != null ? attributeTable.toHashtable() : new Hashtable<DERObjectIdentifier, Attribute>();
        try {
            ESSCertID eSSCertID = new ESSCertID(MessageDigest.getInstance("SHA-1").digest(x509Certificate.getEncoded()));
            hashtable.put(PKCSObjectIdentifiers.id_aa_signingCertificate, new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, new DERSet(new SigningCertificate(eSSCertID))));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TSPException("Can't find a SHA-1 implementation.", noSuchAlgorithmException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new TSPException("Exception processing certificate.", certificateEncodingException);
        }
        this.signedAttr = new AttributeTable(hashtable);
    }

    public void setCertificatesAndCRLs(CertStore certStore) throws CertStoreException, TSPException {
        this.certsAndCrls = certStore;
    }

    public void setAccuracySeconds(int n2) {
        this.accuracySeconds = n2;
    }

    public void setAccuracyMillis(int n2) {
        this.accuracyMillis = n2;
    }

    public void setAccuracyMicros(int n2) {
        this.accuracyMicros = n2;
    }

    public void setOrdering(boolean bl) {
        this.ordering = bl;
    }

    public void setTSA(GeneralName generalName) {
        this.tsa = generalName;
    }

    public TimeStampToken generate(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date, String string) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        ASN1Object aSN1Object;
        DERInteger dERInteger;
        ASN1Object aSN1Object2;
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(timeStampRequest.getMessageImprintAlgOID());
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(dERObjectIdentifier, new DERNull());
        MessageImprint messageImprint = new MessageImprint(algorithmIdentifier, timeStampRequest.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.accuracySeconds > 0 || this.accuracyMillis > 0 || this.accuracyMicros > 0) {
            aSN1Object2 = null;
            if (this.accuracySeconds > 0) {
                aSN1Object2 = new DERInteger(this.accuracySeconds);
            }
            dERInteger = null;
            if (this.accuracyMillis > 0) {
                dERInteger = new DERInteger(this.accuracyMillis);
            }
            aSN1Object = null;
            if (this.accuracyMicros > 0) {
                aSN1Object = new DERInteger(this.accuracyMicros);
            }
            accuracy = new Accuracy((DERInteger)aSN1Object2, dERInteger, (DERInteger)aSN1Object);
        }
        aSN1Object2 = null;
        if (this.ordering) {
            aSN1Object2 = new DERBoolean(this.ordering);
        }
        dERInteger = null;
        if (timeStampRequest.getNonce() != null) {
            dERInteger = new DERInteger(timeStampRequest.getNonce());
        }
        aSN1Object = new DERObjectIdentifier(this.tsaPolicyOID);
        if (timeStampRequest.getReqPolicy() != null) {
            aSN1Object = new DERObjectIdentifier(timeStampRequest.getReqPolicy());
        }
        TSTInfo tSTInfo = new TSTInfo((DERObjectIdentifier)aSN1Object, messageImprint, new DERInteger(bigInteger), new DERGeneralizedTime(date), accuracy, (DERBoolean)aSN1Object2, dERInteger, this.tsa, timeStampRequest.getExtensions());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            dEROutputStream.writeObject(tSTInfo);
            CertStore certStore = timeStampRequest.getCertReq() ? this.certsAndCrls : CertStore.getInstance("Collection", new CollectionCertStoreParameters(this.certsAndCrls.getCRLs(null)));
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            cMSSignedDataGenerator.addSigner(this.key, this.cert, this.digestOID, this.signedAttr, this.unsignedAttr);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(PKCSObjectIdentifiers.id_ct_TSTInfo.getId(), new CMSProcessableByteArray(byteArrayOutputStream.toByteArray()), true, string);
            return new TimeStampToken(cMSSignedData);
        }
        catch (CMSException cMSException) {
            throw new TSPException("Error generating time-stamp token", cMSException);
        }
        catch (IOException iOException) {
            throw new TSPException("Exception encoding info", iOException);
        }
        catch (CertStoreException certStoreException) {
            throw new TSPException("Exception handling CertStore", certStoreException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new TSPException("Exception handling CertStore CRLs", invalidAlgorithmParameterException);
        }
    }
}

