/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11KeyGenerator
extends KeyGeneratorSpi {
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private int keySize;
    private int significantKeySize;
    private long keyType;
    private boolean supportBothKeySizes;

    static int checkKeySize(long l2, int n2, Token token) throws InvalidAlgorithmParameterException, ProviderException {
        int n3;
        switch ((int)l2) {
            case 288: {
                if (n2 != 64 && n2 != 56) {
                    throw new InvalidAlgorithmParameterException("DES key length must be 56 bits");
                }
                n3 = 56;
                break;
            }
            case 304: 
            case 305: {
                if (n2 == 112 || n2 == 128) {
                    n3 = 112;
                    break;
                }
                if (n2 == 168 || n2 == 192) {
                    n3 = 168;
                    break;
                }
                throw new InvalidAlgorithmParameterException("DESede key length must be 112, or 168 bits");
            }
            default: {
                CK_MECHANISM_INFO cK_MECHANISM_INFO = null;
                try {
                    cK_MECHANISM_INFO = token.getMechanismInfo(l2);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    throw new ProviderException("Cannot retrieve mechanism info", pKCS11Exception);
                }
                if (cK_MECHANISM_INFO == null) {
                    return n2;
                }
                int n4 = (int)cK_MECHANISM_INFO.ulMinKeySize;
                int n5 = (int)cK_MECHANISM_INFO.ulMaxKeySize;
                if (l2 != 272L || n4 < 8) {
                    n4 = (int)cK_MECHANISM_INFO.ulMinKeySize << 3;
                    n5 = (int)cK_MECHANISM_INFO.ulMaxKeySize << 3;
                }
                if (n4 < 40) {
                    n4 = 40;
                }
                if (n2 < n4 || n2 > n5) {
                    throw new InvalidAlgorithmParameterException("Key length must be between " + n4 + " and " + n5 + " bits");
                }
                if (l2 == 4224L && n2 != 128 && n2 != 192 && n2 != 256) {
                    throw new InvalidAlgorithmParameterException("AES key length must be " + n4 + (n5 >= 192 ? ", 192" : "") + (n5 >= 256 ? ", or 256" : "") + " bits");
                }
                n3 = n2;
            }
        }
        return n3;
    }

    P11KeyGenerator(Token token, String string, long l2) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l2;
        if (this.mechanism == 305L) {
            this.supportBothKeySizes = token.provider.config.isEnabled(304L) && token.getMechanismInfo(304L) != null;
        }
        this.setDefaultKeySize();
    }

    private void setDefaultKeySize() {
        switch ((int)this.mechanism) {
            case 288: {
                this.keySize = 64;
                this.keyType = 19L;
                break;
            }
            case 304: {
                this.keySize = 128;
                this.keyType = 20L;
                break;
            }
            case 305: {
                this.keySize = 192;
                this.keyType = 21L;
                break;
            }
            case 4224: {
                this.keySize = 128;
                this.keyType = 31L;
                break;
            }
            case 272: {
                this.keySize = 128;
                this.keyType = 18L;
                break;
            }
            case 4240: {
                this.keySize = 128;
                this.keyType = 32L;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism " + this.mechanism);
            }
        }
        try {
            this.significantKeySize = P11KeyGenerator.checkKeySize(this.mechanism, this.keySize, this.token);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException("Unsupported default key size", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.token.ensureValid();
        this.setDefaultKeySize();
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported");
    }

    @Override
    protected void engineInit(int n2, SecureRandom secureRandom) {
        int n3;
        this.token.ensureValid();
        try {
            n3 = P11KeyGenerator.checkKeySize(this.mechanism, n2, this.token);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw (InvalidParameterException)new InvalidParameterException().initCause(invalidAlgorithmParameterException);
        }
        if (this.mechanism == 304L || this.mechanism == 305L) {
            long l2;
            long l3 = l2 = n3 == 112 ? 304L : 305L;
            if (this.mechanism != l2) {
                if (this.supportBothKeySizes) {
                    this.mechanism = l2;
                    this.keyType = this.mechanism == 304L ? 20L : 21L;
                } else {
                    throw new InvalidParameterException("Only " + this.significantKeySize + "-bit DESede is supported");
                }
            }
        }
        this.keySize = n2;
        this.significantKeySize = n3;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        Session session = null;
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
            session = this.token.getObjSession();
            switch ((int)this.keyType) {
                case 19: 
                case 20: 
                case 21: {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L)};
                    break;
                }
                default: {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, this.keySize >> 3)};
                }
            }
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, this.keyType, cK_ATTRIBUTEArray);
            long l2 = this.token.p11.C_GenerateKey(session.id(), new CK_MECHANISM(this.mechanism), cK_ATTRIBUTEArray);
            SecretKey secretKey = P11Key.secretKey(session, l2, this.algorithm, this.significantKeySize, cK_ATTRIBUTEArray);
            return secretKey;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not generate key", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

