/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;

final class SessionManager {
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private static final Debug debug = Debug.getInstance("pkcs11");
    private final Token token;
    private final int maxSessions;
    private int activeSessions;
    private final Pool objSessions;
    private final Pool opSessions;
    private int maxActiveSessions;
    private final long openSessionFlags;

    SessionManager(Token token) {
        long l2;
        if (token.isWriteProtected()) {
            this.openSessionFlags = 4L;
            l2 = token.tokenInfo.ulMaxSessionCount;
        } else {
            this.openSessionFlags = 6L;
            l2 = token.tokenInfo.ulMaxRwSessionCount;
        }
        if (l2 == 0L) {
            l2 = Integer.MAX_VALUE;
        } else if (l2 == -1L || l2 < 0L) {
            l2 = 32L;
        }
        this.maxSessions = (int)Math.min(l2, Integer.MAX_VALUE);
        this.token = token;
        this.objSessions = new Pool(this);
        this.opSessions = new Pool(this);
    }

    boolean lowMaxSessions() {
        return this.maxSessions <= 32;
    }

    synchronized Session getObjSession() throws PKCS11Exception {
        Session session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.openSession();
        return this.ensureValid(session);
    }

    synchronized Session getOpSession() throws PKCS11Exception {
        Session session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        if (this.maxSessions == Integer.MAX_VALUE || this.activeSessions < this.maxSessions) {
            session = this.openSession();
            return this.ensureValid(session);
        }
        session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        throw new ProviderException("Could not obtain session");
    }

    private Session ensureValid(Session session) {
        session.id();
        return session;
    }

    synchronized Session killSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (debug != null) {
            String string = new Exception().getStackTrace()[2].toString();
            System.out.println("Killing session (" + string + ") active: " + this.activeSessions);
        }
        this.closeSession(session);
        return null;
    }

    synchronized Session releaseSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (session.hasObjects()) {
            this.objSessions.release(session);
        } else {
            this.opSessions.release(session);
        }
        return null;
    }

    synchronized void demoteObjSession(Session session) {
        boolean bl;
        if (!this.token.isValid()) {
            return;
        }
        if (debug != null) {
            System.out.println("Demoting session, active: " + this.activeSessions);
        }
        if (!(bl = this.objSessions.remove(session))) {
            return;
        }
        this.opSessions.release(session);
    }

    private Session openSession() throws PKCS11Exception {
        if (this.maxSessions != Integer.MAX_VALUE && this.activeSessions >= this.maxSessions) {
            throw new ProviderException("No more sessions available");
        }
        long l2 = this.token.p11.C_OpenSession(this.token.provider.slotID, this.openSessionFlags, null, null);
        Session session = new Session(this.token, l2);
        ++this.activeSessions;
        if (debug != null && this.activeSessions > this.maxActiveSessions) {
            this.maxActiveSessions = this.activeSessions;
            if (this.maxActiveSessions % 10 == 0) {
                System.out.println("Open sessions: " + this.maxActiveSessions);
            }
        }
        return session;
    }

    private void closeSession(Session session) {
        session.close();
        --this.activeSessions;
    }

    private static final class Pool {
        private final SessionManager mgr;
        private final List<Session> pool;

        Pool(SessionManager sessionManager) {
            this.mgr = sessionManager;
            this.pool = new ArrayList<Session>();
        }

        boolean remove(Session session) {
            return this.pool.remove(session);
        }

        Session poll() {
            int n2 = this.pool.size();
            if (n2 == 0) {
                return null;
            }
            Session session = this.pool.remove(n2 - 1);
            return session;
        }

        void release(Session session) {
            int n2;
            this.pool.add(session);
            if (session.hasObjects()) {
                return;
            }
            int n3 = this.pool.size();
            if (n3 < 5) {
                return;
            }
            Session session2 = this.pool.get(0);
            long l2 = System.currentTimeMillis();
            if (session.isLive(l2) && session2.isLive(l2)) {
                return;
            }
            Collections.sort(this.pool);
            for (n2 = 0; n2 < n3 - 1 && !(session2 = this.pool.get(n2)).isLive(l2); ++n2) {
                this.mgr.closeSession(session2);
            }
            if (debug != null) {
                System.out.println("Closing " + n2 + " idle sessions, active: " + this.mgr.activeSessions);
            }
            List<Session> list = this.pool.subList(0, n2);
            list.clear();
        }
    }
}

