/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.InterpreterError;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import bsh.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class ExternalNameSpace
extends NameSpace {
    private Map externalMap;

    public ExternalNameSpace() {
        this(null, "External Map Namespace", null);
    }

    public ExternalNameSpace(NameSpace nameSpace, String string, Map hashMap) {
        super(nameSpace, string);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.externalMap = hashMap;
    }

    public Map getMap() {
        return this.externalMap;
    }

    public void setMap(Map map) {
        this.externalMap = null;
        this.clear();
        this.externalMap = map;
    }

    void setVariable(String string, Object object, boolean bl, boolean bl2) throws UtilEvalError {
        super.setVariable(string, object, bl, bl2);
        this.putExternalMap(string, object);
    }

    public void unsetVariable(String string) {
        super.unsetVariable(string);
        this.externalMap.remove(string);
    }

    public String[] getVariableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = super.getVariableNames();
        hashSet.addAll(Arrays.asList(stringArray));
        hashSet.addAll(this.externalMap.keySet());
        return hashSet.toArray(new String[0]);
    }

    protected Variable getVariableImpl(String string, boolean bl) throws UtilEvalError {
        Variable variable;
        Object v2 = this.externalMap.get(string);
        if (v2 == null) {
            super.unsetVariable(string);
            variable = super.getVariableImpl(string, bl);
        } else {
            Variable variable2 = super.getVariableImpl(string, false);
            variable = variable2 == null ? new Variable(string, (Class)null, v2, (Modifiers)null) : variable2;
        }
        return variable;
    }

    public Variable[] getDeclaredVariables() {
        return super.getDeclaredVariables();
    }

    public void setTypedVariable(String string, Class clazz, Object object, Modifiers modifiers) throws UtilEvalError {
        super.setTypedVariable(string, clazz, object, modifiers);
        this.putExternalMap(string, object);
    }

    public void setMethod(String string, BshMethod bshMethod) throws UtilEvalError {
        super.setMethod(string, bshMethod);
    }

    public BshMethod getMethod(String string, Class[] classArray, boolean bl) throws UtilEvalError {
        return super.getMethod(string, classArray, bl);
    }

    protected void getAllNamesAux(Vector vector) {
        super.getAllNamesAux(vector);
    }

    public void clear() {
        super.clear();
        this.externalMap.clear();
    }

    protected void putExternalMap(String string, Object object) {
        if (object instanceof Variable) {
            try {
                object = this.unwrapVariable((Variable)object);
            }
            catch (UtilEvalError utilEvalError) {
                throw new InterpreterError("unexpected UtilEvalError");
            }
        }
        if (object instanceof Primitive) {
            object = Primitive.unwrap((Primitive)object);
        }
        this.externalMap.put(string, object);
    }
}

