/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPCellEvent;
import com.itextpdf.text.pdf.PdfPTable;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    public static final float RIGHT_LIMIT = 20000.0f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float[] extraHeights;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] cells) {
        this.cells = cells;
        this.widths = new float[cells.length];
        this.initExtraHeights();
    }

    public PdfPRow(PdfPRow row) {
        this.maxHeight = row.maxHeight;
        this.calculated = row.calculated;
        this.cells = new PdfPCell[row.cells.length];
        int k2 = 0;
        while (k2 < this.cells.length) {
            if (row.cells[k2] != null) {
                this.cells[k2] = new PdfPCell(row.cells[k2]);
            }
            ++k2;
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(row.widths, 0, this.widths, 0, this.cells.length);
        this.initExtraHeights();
    }

    public boolean setWidths(float[] widths) {
        if (widths.length != this.cells.length) {
            return false;
        }
        System.arraycopy(widths, 0, this.widths, 0, this.cells.length);
        float total = 0.0f;
        this.calculated = false;
        int k2 = 0;
        while (k2 < widths.length) {
            PdfPCell cell = this.cells[k2];
            if (cell == null) {
                total += widths[k2];
            } else {
                cell.setLeft(total);
                int last = k2 + cell.getColspan();
                while (k2 < last) {
                    total += widths[k2];
                    ++k2;
                }
                --k2;
                cell.setRight(total);
                cell.setTop(0.0f);
            }
            ++k2;
        }
        return true;
    }

    public void initExtraHeights() {
        this.extraHeights = new float[this.cells.length];
        int i2 = 0;
        while (i2 < this.extraHeights.length) {
            this.extraHeights[i2] = 0.0f;
            ++i2;
        }
    }

    public void setExtraHeight(int cell, float height) {
        if (cell < 0 || cell >= this.cells.length) {
            return;
        }
        this.extraHeights[cell] = height;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        int k2 = 0;
        while (k2 < this.cells.length) {
            PdfPCell cell = this.cells[k2];
            float height = 0.0f;
            if (cell != null && (height = cell.getMaxHeight()) > this.maxHeight && cell.getRowspan() == 1) {
                this.maxHeight = height;
            }
            ++k2;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float xPos, float yPos, float currentMaxHeight, PdfPCell cell, PdfContentByte[] canvases) {
        BaseColor background = cell.getBackgroundColor();
        if (background != null || cell.hasBorders()) {
            float right = cell.getRight() + xPos;
            float top = cell.getTop() + yPos;
            float left = cell.getLeft() + xPos;
            float bottom = top - currentMaxHeight;
            if (background != null) {
                PdfContentByte backgr = canvases[1];
                backgr.setColorFill(background);
                backgr.rectangle(left, bottom, right - left, top - bottom);
                backgr.fill();
            }
            if (cell.hasBorders()) {
                Rectangle newRect = new Rectangle(left, bottom, right, top);
                newRect.cloneNonPositionParameters(cell);
                newRect.setBackgroundColor(null);
                PdfContentByte lineCanvas = canvases[2];
                lineCanvas.rectangle(newRect);
            }
        }
    }

    protected void saveAndRotateCanvases(PdfContentByte[] canvases, float a2, float b2, float c2, float d2, float e2, float f2) {
        int last = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[last * 2];
        }
        int k2 = 0;
        while (k2 < last) {
            ByteBuffer bb = canvases[k2].getInternalBuffer();
            this.canvasesPos[k2 * 2] = bb.size();
            canvases[k2].saveState();
            canvases[k2].concatCTM(a2, b2, c2, d2, e2, f2);
            this.canvasesPos[k2 * 2 + 1] = bb.size();
            ++k2;
        }
    }

    protected void restoreCanvases(PdfContentByte[] canvases) {
        int last = 4;
        int k2 = 0;
        while (k2 < last) {
            ByteBuffer bb = canvases[k2].getInternalBuffer();
            int p1 = bb.size();
            canvases[k2].restoreState();
            if (p1 == this.canvasesPos[k2 * 2 + 1]) {
                bb.setSize(this.canvasesPos[k2 * 2]);
            }
            ++k2;
        }
    }

    public static float setColumn(ColumnText ct, float left, float bottom, float right, float top) {
        if (left > right) {
            right = left;
        }
        if (bottom > top) {
            top = bottom;
        }
        ct.setSimpleColumn(left, bottom, right, top);
        return top;
    }

    public void writeCells(int colStart, int colEnd, float xPos, float yPos, PdfContentByte[] canvases) {
        if (!this.calculated) {
            this.calculateHeights();
        }
        colEnd = colEnd < 0 ? this.cells.length : Math.min(colEnd, this.cells.length);
        if (colStart < 0) {
            colStart = 0;
        }
        if (colStart >= colEnd) {
            return;
        }
        int newStart = colStart;
        while (newStart >= 0) {
            if (this.cells[newStart] != null) break;
            if (newStart > 0) {
                xPos -= this.widths[newStart - 1];
            }
            --newStart;
        }
        if (newStart < 0) {
            newStart = 0;
        }
        if (this.cells[newStart] != null) {
            xPos -= this.cells[newStart].getLeft();
        }
        int k2 = newStart;
        while (k2 < colEnd) {
            PdfPCell cell = this.cells[k2];
            if (cell != null) {
                float currentMaxHeight = this.maxHeight + this.extraHeights[k2];
                this.writeBorderAndBackground(xPos, yPos, currentMaxHeight, cell, canvases);
                Image img = cell.getImage();
                float tly = cell.getTop() + yPos - cell.getEffectivePaddingTop();
                if (cell.getHeight() <= currentMaxHeight) {
                    switch (cell.getVerticalAlignment()) {
                        case 6: {
                            tly = cell.getTop() + yPos - currentMaxHeight + cell.getHeight() - cell.getEffectivePaddingTop();
                            break;
                        }
                        case 5: {
                            tly = cell.getTop() + yPos + (cell.getHeight() - currentMaxHeight) / 2.0f - cell.getEffectivePaddingTop();
                            break;
                        }
                    }
                }
                if (img != null) {
                    if (cell.getRotation() != 0) {
                        img = Image.getInstance(img);
                        img.setRotation(img.getImageRotation() + (float)((double)cell.getRotation() * Math.PI / 180.0));
                    }
                    boolean vf = false;
                    if (cell.getHeight() > currentMaxHeight) {
                        img.scalePercent(100.0f);
                        float scale = (currentMaxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom()) / img.getScaledHeight();
                        img.scalePercent(scale * 100.0f);
                        vf = true;
                    }
                    float left = cell.getLeft() + xPos + cell.getEffectivePaddingLeft();
                    if (vf) {
                        switch (cell.getHorizontalAlignment()) {
                            case 1: {
                                left = xPos + (cell.getLeft() + cell.getEffectivePaddingLeft() + cell.getRight() - cell.getEffectivePaddingRight() - img.getScaledWidth()) / 2.0f;
                                break;
                            }
                            case 2: {
                                left = xPos + cell.getRight() - cell.getEffectivePaddingRight() - img.getScaledWidth();
                                break;
                            }
                        }
                        tly = cell.getTop() + yPos - cell.getEffectivePaddingTop();
                    }
                    img.setAbsolutePosition(left, tly - img.getScaledHeight());
                    try {
                        canvases[3].addImage(img);
                    }
                    catch (DocumentException e2) {
                        throw new ExceptionConverter(e2);
                    }
                }
                if (cell.getRotation() == 90 || cell.getRotation() == 270) {
                    float netWidth = currentMaxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom();
                    float netHeight = cell.getWidth() - cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight();
                    ColumnText ct = ColumnText.duplicate(cell.getColumn());
                    ct.setCanvases(canvases);
                    ct.setSimpleColumn(0.0f, 0.0f, netWidth + 0.001f, -netHeight);
                    try {
                        ct.go(true);
                    }
                    catch (DocumentException e3) {
                        throw new ExceptionConverter(e3);
                    }
                    float calcHeight = -ct.getYLine();
                    if (netWidth <= 0.0f || netHeight <= 0.0f) {
                        calcHeight = 0.0f;
                    }
                    if (calcHeight > 0.0f) {
                        float pivotX;
                        float pivotY;
                        if (cell.isUseDescender()) {
                            calcHeight -= ct.getDescender();
                        }
                        ct = ColumnText.duplicate(cell.getColumn());
                        ct.setCanvases(canvases);
                        ct.setSimpleColumn(-0.003f, -0.001f, netWidth + 0.003f, calcHeight);
                        if (cell.getRotation() == 90) {
                            pivotY = cell.getTop() + yPos - currentMaxHeight + cell.getEffectivePaddingBottom();
                            switch (cell.getVerticalAlignment()) {
                                case 6: {
                                    pivotX = cell.getLeft() + xPos + cell.getWidth() - cell.getEffectivePaddingRight();
                                    break;
                                }
                                case 5: {
                                    pivotX = cell.getLeft() + xPos + (cell.getWidth() + cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight() + calcHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    pivotX = cell.getLeft() + xPos + cell.getEffectivePaddingLeft() + calcHeight;
                                }
                            }
                            this.saveAndRotateCanvases(canvases, 0.0f, 1.0f, -1.0f, 0.0f, pivotX, pivotY);
                        } else {
                            pivotY = cell.getTop() + yPos - cell.getEffectivePaddingTop();
                            switch (cell.getVerticalAlignment()) {
                                case 6: {
                                    pivotX = cell.getLeft() + xPos + cell.getEffectivePaddingLeft();
                                    break;
                                }
                                case 5: {
                                    pivotX = cell.getLeft() + xPos + (cell.getWidth() + cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight() - calcHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    pivotX = cell.getLeft() + xPos + cell.getWidth() - cell.getEffectivePaddingRight() - calcHeight;
                                }
                            }
                            this.saveAndRotateCanvases(canvases, 0.0f, -1.0f, 1.0f, 0.0f, pivotX, pivotY);
                        }
                        try {
                            try {
                                ct.go();
                            }
                            catch (DocumentException e4) {
                                throw new ExceptionConverter(e4);
                            }
                        }
                        finally {
                            this.restoreCanvases(canvases);
                        }
                    }
                } else {
                    float fixedHeight = cell.getFixedHeight();
                    float rightLimit = cell.getRight() + xPos - cell.getEffectivePaddingRight();
                    float leftLimit = cell.getLeft() + xPos + cell.getEffectivePaddingLeft();
                    if (cell.isNoWrap()) {
                        switch (cell.getHorizontalAlignment()) {
                            case 1: {
                                rightLimit += 10000.0f;
                                leftLimit -= 10000.0f;
                                break;
                            }
                            case 2: {
                                if (cell.getRotation() == 180) {
                                    rightLimit += 20000.0f;
                                    break;
                                }
                                leftLimit -= 20000.0f;
                                break;
                            }
                            default: {
                                if (cell.getRotation() == 180) {
                                    leftLimit -= 20000.0f;
                                    break;
                                }
                                rightLimit += 20000.0f;
                            }
                        }
                    }
                    ColumnText ct = ColumnText.duplicate(cell.getColumn());
                    ct.setCanvases(canvases);
                    float bry = tly - (currentMaxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom());
                    if (fixedHeight > 0.0f && cell.getHeight() > currentMaxHeight) {
                        tly = cell.getTop() + yPos - cell.getEffectivePaddingTop();
                        bry = cell.getTop() + yPos - currentMaxHeight + cell.getEffectivePaddingBottom();
                    }
                    if ((tly > bry || ct.zeroHeightElement()) && leftLimit < rightLimit) {
                        ct.setSimpleColumn(leftLimit, bry - 0.001f, rightLimit, tly);
                        if (cell.getRotation() == 180) {
                            float shx = leftLimit + rightLimit;
                            float shy = yPos + yPos - currentMaxHeight + cell.getEffectivePaddingBottom() - cell.getEffectivePaddingTop();
                            this.saveAndRotateCanvases(canvases, -1.0f, 0.0f, 0.0f, -1.0f, shx, shy);
                        }
                        try {
                            try {
                                ct.go();
                            }
                            catch (DocumentException e5) {
                                throw new ExceptionConverter(e5);
                            }
                        }
                        finally {
                            if (cell.getRotation() == 180) {
                                this.restoreCanvases(canvases);
                            }
                        }
                    }
                }
                PdfPCellEvent evt = cell.getCellEvent();
                if (evt != null) {
                    Rectangle rect = new Rectangle(cell.getLeft() + xPos, cell.getTop() + yPos - currentMaxHeight, cell.getRight() + xPos, cell.getTop() + yPos);
                    evt.cellLayout(cell, rect, canvases);
                }
            }
            ++k2;
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float maxHeight) {
        this.maxHeight = maxHeight;
    }

    float[] getEventWidth(float xPos) {
        int n2 = 0;
        int k2 = 0;
        while (k2 < this.cells.length) {
            if (this.cells[k2] != null) {
                ++n2;
            }
            ++k2;
        }
        float[] width = new float[n2 + 1];
        n2 = 0;
        width[n2++] = xPos;
        int k3 = 0;
        while (k3 < this.cells.length) {
            if (this.cells[k3] != null) {
                width[n2] = width[n2 - 1] + this.cells[k3].getWidth();
                ++n2;
            }
            ++k3;
        }
        return width;
    }

    public PdfPRow splitRow(PdfPTable table, int rowIndex, float new_height) {
        PdfPCell[] newCells = new PdfPCell[this.cells.length];
        float[] fixHs = new float[this.cells.length];
        float[] minHs = new float[this.cells.length];
        boolean allEmpty = true;
        int k2 = 0;
        while (k2 < this.cells.length) {
            float newHeight = new_height;
            PdfPCell cell = this.cells[k2];
            if (cell == null) {
                int index = rowIndex;
                if (table.rowSpanAbove(index, k2)) {
                    newHeight += table.getRowHeight(index);
                    while (table.rowSpanAbove(--index, k2)) {
                        newHeight += table.getRowHeight(index);
                    }
                    PdfPRow row = table.getRow(index);
                    if (row != null && row.getCells()[k2] != null) {
                        newCells[k2] = new PdfPCell(row.getCells()[k2]);
                        newCells[k2].consumeHeight(newHeight);
                        newCells[k2].setRowspan(row.getCells()[k2].getRowspan() - rowIndex + index);
                        allEmpty = false;
                    }
                }
            } else {
                fixHs[k2] = cell.getFixedHeight();
                minHs[k2] = cell.getMinimumHeight();
                Image img = cell.getImage();
                PdfPCell newCell = new PdfPCell(cell);
                if (img != null) {
                    if (newHeight > cell.getEffectivePaddingBottom() + cell.getEffectivePaddingTop() + 2.0f) {
                        newCell.setPhrase(null);
                        allEmpty = false;
                    }
                } else {
                    boolean thisEmpty;
                    int status;
                    float y;
                    ColumnText ct = ColumnText.duplicate(cell.getColumn());
                    float left = cell.getLeft() + cell.getEffectivePaddingLeft();
                    float bottom = cell.getTop() + cell.getEffectivePaddingBottom() - newHeight;
                    float right = cell.getRight() - cell.getEffectivePaddingRight();
                    float top = cell.getTop() - cell.getEffectivePaddingTop();
                    switch (cell.getRotation()) {
                        case 90: 
                        case 270: {
                            y = PdfPRow.setColumn(ct, bottom, left, top, right);
                            break;
                        }
                        default: {
                            y = PdfPRow.setColumn(ct, left, bottom, cell.isNoWrap() ? 20000.0f : right, top);
                        }
                    }
                    try {
                        status = ct.go(true);
                    }
                    catch (DocumentException e2) {
                        throw new ExceptionConverter(e2);
                    }
                    boolean bl = thisEmpty = ct.getYLine() == y;
                    if (thisEmpty) {
                        newCell.setColumn(ColumnText.duplicate(cell.getColumn()));
                        ct.setFilledWidth(0.0f);
                    } else if ((status & 1) == 0) {
                        newCell.setColumn(ct);
                        ct.setFilledWidth(0.0f);
                    } else {
                        newCell.setPhrase(null);
                    }
                    allEmpty = allEmpty && thisEmpty;
                }
                newCells[k2] = newCell;
                cell.setFixedHeight(newHeight - cell.getEffectivePaddingBottom());
            }
            ++k2;
        }
        if (allEmpty) {
            k2 = 0;
            while (k2 < this.cells.length) {
                PdfPCell cell = this.cells[k2];
                if (cell != null) {
                    if (fixHs[k2] > 0.0f) {
                        cell.setFixedHeight(fixHs[k2]);
                    } else {
                        cell.setMinimumHeight(minHs[k2]);
                    }
                }
                ++k2;
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow split = new PdfPRow(newCells);
        split.widths = (float[])this.widths.clone();
        split.calculateHeights();
        return split;
    }

    public PdfPCell[] getCells() {
        return this.cells;
    }
}

