/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRMultiClassCompiler;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRLoader;

public abstract class JRAbstractClassCompiler
extends JRAbstractJavaCompiler
implements JRMultiClassCompiler {
    protected JRAbstractClassCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, true);
    }

    protected JRAbstractClassCompiler() {
        this(DefaultJasperReportsContext.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        File[] sources = new File[units.length];
        for (int i2 = 0; i2 < sources.length; ++i2) {
            sources[i2] = units[i2].getSourceFile();
        }
        File[] classFiles = new File[units.length];
        for (int i3 = 0; i3 < classFiles.length; ++i3) {
            classFiles[i3] = new File(tempDirFile, units[i3].getName() + ".class");
        }
        try {
            String errors = this.compileClasses(sources, classpath);
            if (errors == null) {
                for (int i4 = 0; i4 < units.length; ++i4) {
                    byte[] classBytes = JRLoader.loadBytes(classFiles[i4]);
                    units[i4].setCompileData((Serializable)classBytes);
                }
            }
            String string = errors;
            return string;
        }
        finally {
            for (int i5 = 0; i5 < classFiles.length; ++i5) {
                if (!classFiles[i5].exists()) continue;
                classFiles[i5].delete();
            }
        }
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
        if (!"java".equals(language)) {
            throw new JRException("Language \"" + language + "\" not supported by this report compiler.\n" + "Expecting \"java\" instead.");
        }
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return JRClassGenerator.generateClass(sourceTask);
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".java";
    }
}

