/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.List;
import net.sf.jasperreports.engine.ElementsVisitor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRDelegationVisitor;

public class JRElementsVisitor
extends JRDelegationVisitor
implements ElementsVisitor {
    public static void visitReport(JRReport report, JRVisitor visitor) {
        JRElementsVisitor reportVisitor = new JRElementsVisitor(visitor);
        reportVisitor.visitReport(report);
    }

    public JRElementsVisitor(JRVisitor visitor) {
        super(visitor);
    }

    @Override
    public boolean visitDeepElements() {
        return true;
    }

    public void visitReport(JRReport report) {
        this.visitBand(report.getBackground());
        this.visitBand(report.getTitle());
        this.visitBand(report.getPageHeader());
        this.visitBand(report.getColumnHeader());
        this.visitSection(report.getDetailSection());
        this.visitBand(report.getColumnFooter());
        this.visitBand(report.getPageFooter());
        this.visitBand(report.getLastPageFooter());
        this.visitBand(report.getSummary());
        this.visitBand(report.getNoData());
        JRGroup[] groups = report.getGroups();
        if (groups != null) {
            for (int i2 = 0; i2 < groups.length; ++i2) {
                JRGroup group = groups[i2];
                this.visitSection(group.getGroupHeaderSection());
                this.visitSection(group.getGroupFooterSection());
            }
        }
    }

    protected void visitSection(JRSection section) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null) {
            for (int i2 = 0; i2 < bands.length; ++i2) {
                this.visitBand(bands[i2]);
            }
        }
    }

    protected void visitBand(JRBand band) {
        if (band != null) {
            band.visit(this);
        }
    }

    protected void visitElements(List<JRChild> elements) {
        ElementsVisitorUtils.visitElements(this, elements);
    }
}

