/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.DefaultHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilterFactory;
import net.sf.jasperreports.engine.export.ExporterFilterFactoryUtil;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRAbstractExporter
implements JRExporter {
    public static final String PROPERTY_DEFAULT_FILTER_FACTORY = "net.sf.jasperreports.export.default.filter.factory";
    public static final String PROPERTY_SUFFIX_DEFAULT_FILTER_FACTORY = "default.filter.factory";
    private ParameterResolver parameterResolver;
    protected Map<JRExporterParameter, Object> parameters = new HashMap<JRExporterParameter, Object>();
    protected List<JasperPrint> jasperPrintList;
    protected JasperPrint jasperPrint;
    protected boolean isModeBatch = true;
    protected int startPageIndex;
    protected int endPageIndex;
    protected int globalOffsetX;
    protected int globalOffsetY;
    protected ExporterFilter filter;
    private LinkedList<int[]> elementOffsetStack = new LinkedList();
    private int elementOffsetX = this.globalOffsetX;
    private int elementOffsetY = this.globalOffsetY;
    protected Map<String, DateFormat> dateFormatCache = new HashMap<String, DateFormat>();
    protected Map<String, NumberFormat> numberFormatCache = new HashMap<String, NumberFormat>();
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;
    private ReportContext reportContext;

    protected JRAbstractExporter() {
    }

    public void reset() {
        this.parameters = new HashMap<JRExporterParameter, Object>();
        this.elementOffsetStack = new LinkedList();
    }

    @Override
    public void setParameter(JRExporterParameter parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    @Override
    public Object getParameter(JRExporterParameter parameter) {
        return this.parameters.get(parameter);
    }

    @Override
    public void setParameters(Map<JRExporterParameter, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<JRExporterParameter, Object> getParameters() {
        return this.parameters;
    }

    protected ParameterResolver getParameterResolver() {
        if (this.parameterResolver == null) {
            Boolean param = (Boolean)this.parameters.get(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS);
            boolean parametersOverrideHints = param == null ? JRProperties.getBooleanProperty("net.sf.jasperreports.export.parameters.override.report.hints") : param;
            this.parameterResolver = parametersOverrideHints ? new ParameterOverrideResolver() : new ParameterOverriddenResolver();
        }
        return this.parameterResolver;
    }

    public String getStringParameter(JRExporterParameter parameter, String property) {
        return this.getParameterResolver().getStringParameter(parameter, property);
    }

    public String[] getStringArrayParameter(JRExporterParameter parameter, String property) {
        return this.getParameterResolver().getStringArrayParameter(parameter, property);
    }

    public String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
        return this.getParameterResolver().getStringParameterOrDefault(parameter, property);
    }

    public boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
        return this.getParameterResolver().getBooleanParameter(parameter, property, defaultValue);
    }

    public int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
        return this.getParameterResolver().getIntegerParameter(parameter, property, defaultValue);
    }

    public float getFloatParameter(JRExporterParameter parameter, String property, float defaultValue) {
        return this.getParameterResolver().getFloatParameter(parameter, property, defaultValue);
    }

    public Character getCharacterParameter(JRExporterParameter parameter, String property) {
        return this.getParameterResolver().getCharacterParameter(parameter, property);
    }

    @Override
    public void setReportContext(ReportContext reportContext) {
        this.reportContext = reportContext;
    }

    @Override
    public ReportContext getReportContext() {
        return this.reportContext;
    }

    @Override
    public abstract void exportReport() throws JRException;

    protected void setOffset() {
        this.setOffset(true);
    }

    protected void setOffset(boolean setElementOffsets) {
        Integer offsetX = (Integer)this.parameters.get(JRExporterParameter.OFFSET_X);
        this.globalOffsetX = offsetX != null ? offsetX : 0;
        Integer offsetY = (Integer)this.parameters.get(JRExporterParameter.OFFSET_Y);
        this.globalOffsetY = offsetY != null ? offsetY : 0;
        if (setElementOffsets) {
            this.elementOffsetX = this.globalOffsetX;
            this.elementOffsetY = this.globalOffsetY;
        }
    }

    protected void setExportContext() {
        HashMap<String, Object> contextParamValues = new HashMap<String, Object>(3);
        contextParamValues.put("REPORT_CLASS_LOADER", this.parameters.get(JRExporterParameter.CLASS_LOADER));
        contextParamValues.put("REPORT_URL_HANDLER_FACTORY", this.parameters.get(JRExporterParameter.URL_HANDLER_FACTORY));
        contextParamValues.put("REPORT_FILE_RESOLVER", this.parameters.get(JRExporterParameter.FILE_RESOLVER));
        RepositoryUtil.setRepositoryContext(new SimpleRepositoryContext(contextParamValues));
        JRFontUtil.resetThreadMissingFontsCache();
    }

    protected void resetExportContext() {
        RepositoryUtil.revertRepositoryContext();
    }

    protected void setClassLoader() {
        this.setExportContext();
    }

    protected void resetClassLoader() {
        this.resetExportContext();
    }

    protected void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
        String localeCode = jasperPrint.getLocaleCode();
        JRStyledTextParser.setLocale(localeCode == null ? null : JRDataUtils.getLocale(localeCode));
    }

    protected void setInput() throws JRException {
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (is != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
                } else {
                    URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (url != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                        } else {
                            String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (fileName != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(fileName);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList<JasperPrint>();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            this.jasperPrint = this.jasperPrintList.get(0);
        }
        this.setJasperPrint(this.jasperPrint);
        this.filter = (ExporterFilter)this.parameters.get(JRExporterParameter.FILTER);
    }

    protected void setPageRange() throws JRException {
        Integer start;
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < this.startPageIndex || this.endPageIndex > lastPageIndex) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " (" + this.startPageIndex + " : " + lastPageIndex + ")");
            }
        }
        Integer index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        return textElement.getStyledText(setBackcolor ? JRStyledTextAttributeSelector.ALL : JRStyledTextAttributeSelector.NO_BACKCOLOR);
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.getStyledText(textElement, true);
    }

    protected void setOutput() {
    }

    protected int getOffsetX() {
        return this.elementOffsetX;
    }

    protected int getOffsetY() {
        return this.elementOffsetY;
    }

    protected void setFrameElementsOffset(JRPrintFrame frame, boolean relative) {
        if (relative) {
            this.setElementOffsets(0, 0);
        } else {
            int topPadding = frame.getLineBox().getTopPadding();
            int leftPadding = frame.getLineBox().getLeftPadding();
            this.setElementOffsets(this.getOffsetX() + frame.getX() + leftPadding, this.getOffsetY() + frame.getY() + topPadding);
        }
    }

    private void setElementOffsets(int offsetX, int offsetY) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = offsetX;
        this.elementOffsetY = offsetY;
    }

    protected void restoreElementOffsets() {
        int[] offsets = this.elementOffsetStack.removeLast();
        this.elementOffsetX = offsets[0];
        this.elementOffsetY = offsets[1];
    }

    protected String getTextFormatFactoryClass(JRPrintText text) {
        String formatFactoryClass = text.getFormatFactoryClass();
        if (formatFactoryClass == null) {
            formatFactoryClass = this.jasperPrint.getFormatFactoryClass();
        }
        return formatFactoryClass;
    }

    protected Locale getLocale() {
        String localeCode = this.jasperPrint.getLocaleCode();
        return localeCode == null ? null : JRDataUtils.getLocale(localeCode);
    }

    protected Locale getTextLocale(JRPrintText text) {
        String localeCode = text.getLocaleCode();
        if (localeCode == null) {
            localeCode = this.jasperPrint.getLocaleCode();
        }
        return localeCode == null ? null : JRDataUtils.getLocale(localeCode);
    }

    protected TimeZone getTextTimeZone(JRPrintText text) {
        String tzId = text.getTimeZoneId();
        if (tzId == null) {
            tzId = this.jasperPrint.getTimeZoneId();
        }
        return tzId == null ? null : JRDataUtils.getTimeZone(tzId);
    }

    protected TextValue getTextValue(JRPrintText text, String textStr) {
        TextValue textValue;
        if (text.getValueClassName() == null) {
            textValue = this.getTextValueString(text, textStr);
        } else {
            try {
                Class<?> valueClass = JRClassLoader.loadClassForRealName(text.getValueClassName());
                textValue = Number.class.isAssignableFrom(valueClass) ? this.getNumberCellValue(text, textStr) : (Date.class.isAssignableFrom(valueClass) ? this.getDateCellValue(text, textStr) : (Boolean.class.equals(valueClass) ? this.getBooleanCellValue(text, textStr) : this.getTextValueString(text, textStr)));
            }
            catch (ParseException e2) {
                textValue = this.getTextValueString(text, textStr);
            }
            catch (ClassNotFoundException e3) {
                textValue = this.getTextValueString(text, textStr);
            }
        }
        return textValue;
    }

    protected TextValue getTextValueString(JRPrintText text, String textStr) {
        return new StringTextValue(textStr);
    }

    protected TextValue getDateCellValue(JRPrintText text, String textStr) throws ParseException {
        return new DateTextValue(textStr, (Date)text.getValue(), text.getPattern());
    }

    protected TextValue getNumberCellValue(JRPrintText text, String textStr) throws ParseException, ClassNotFoundException {
        return new NumberTextValue(textStr, (Number)text.getValue(), text.getPattern());
    }

    protected Number defaultParseNumber(String textStr, Class<?> valueClass) {
        Number value = null;
        try {
            if (valueClass.equals(Byte.class)) {
                value = Byte.valueOf(textStr);
            } else if (valueClass.equals(Short.class)) {
                value = Short.valueOf(textStr);
            } else if (valueClass.equals(Integer.class)) {
                value = Integer.valueOf(textStr);
            } else if (valueClass.equals(Long.class)) {
                value = Long.valueOf(textStr);
            } else if (valueClass.equals(Float.class)) {
                value = Float.valueOf(textStr);
            } else if (valueClass.equals(Double.class)) {
                value = Double.valueOf(textStr);
            } else if (valueClass.equals(BigInteger.class)) {
                value = new BigInteger(textStr);
            } else if (valueClass.equals(BigDecimal.class)) {
                value = new BigDecimal(textStr);
            }
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return value;
    }

    protected TextValue getBooleanCellValue(JRPrintText text, String textStr) {
        Boolean value = null;
        if (textStr != null && textStr.length() > 0) {
            value = Boolean.valueOf(textStr);
        }
        return new BooleanTextValue(textStr, value);
    }

    protected DateFormat getDateFormat(String formatFactoryClass, String pattern, Locale lc, TimeZone tz) {
        String key = formatFactoryClass + "|" + pattern + "|" + (lc == null ? "" : JRDataUtils.getLocaleCode(lc)) + "|" + (tz == null ? "" : JRDataUtils.getTimeZoneId(tz));
        DateFormat dateFormat = this.dateFormatCache.get(key);
        if (dateFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(formatFactoryClass);
            dateFormat = formatFactory.createDateFormat(pattern, lc, tz);
            this.dateFormatCache.put(key, dateFormat);
        }
        return dateFormat;
    }

    protected NumberFormat getNumberFormat(String formatFactoryClass, String pattern, Locale lc) {
        String key = formatFactoryClass + "|" + pattern + "|" + (lc == null ? "" : JRDataUtils.getLocaleCode(lc));
        NumberFormat numberFormat = this.numberFormatCache.get(key);
        if (numberFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(formatFactoryClass);
            numberFormat = formatFactory.createNumberFormat(pattern, lc);
            this.numberFormatCache.put(key, numberFormat);
        }
        return numberFormat;
    }

    protected ExporterFilter createFilter(final String exportPropertyPrefix) throws JRException {
        String exportDefaultFactoryProperty = exportPropertyPrefix + PROPERTY_SUFFIX_DEFAULT_FILTER_FACTORY;
        String defaultFilterClassName = null;
        if (this.jasperPrint.hasProperties() && (defaultFilterClassName = this.jasperPrint.getPropertiesMap().getProperty(exportDefaultFactoryProperty)) == null) {
            defaultFilterClassName = this.jasperPrint.getPropertiesMap().getProperty(PROPERTY_DEFAULT_FILTER_FACTORY);
        }
        if (defaultFilterClassName == null) {
            defaultFilterClassName = JRProperties.getProperty(exportDefaultFactoryProperty);
        }
        if (defaultFilterClassName == null) {
            defaultFilterClassName = JRProperties.getProperty(PROPERTY_DEFAULT_FILTER_FACTORY);
        }
        ExporterFilterFactory defaultFactory = ExporterFilterFactoryUtil.getFilterFactory(defaultFilterClassName);
        BaseExporterContext context = new BaseExporterContext(){

            public String getExportPropertiesPrefix() {
                return exportPropertyPrefix;
            }
        };
        return defaultFactory.getFilter(context);
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
        if (this.hyperlinkProducerFactory == null) {
            this.hyperlinkProducerFactory = new DefaultHyperlinkProducerFactory();
        }
    }

    protected JRHyperlinkProducer getHyperlinkProducer(JRPrintHyperlink link) {
        return this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(link.getLinkType());
    }

    protected JRHyperlinkProducer getCustomHandler(JRPrintHyperlink link) {
        return this.getHyperlinkProducer(link);
    }

    protected abstract String getExporterKey() throws JRException;

    protected class ParameterOverriddenResolver
    implements ParameterResolver {
        protected ParameterOverriddenResolver() {
        }

        public String getStringParameter(JRExporterParameter parameter, String property) {
            String value;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            if (hintsMap != null && hintsMap.containsProperty(property)) {
                value = hintsMap.getProperty(property);
            } else {
                value = (String)JRAbstractExporter.this.parameters.get(parameter);
                if (value == null) {
                    value = JRProperties.getProperty(property);
                }
            }
            return value;
        }

        public String[] getStringArrayParameter(JRExporterParameter parameter, String propertyPrefix) {
            String[] values = null;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            if (hintsMap != null) {
                List<JRProperties.PropertySuffix> properties = JRProperties.getProperties(hintsMap, propertyPrefix);
                if (properties != null) {
                    values = new String[properties.size()];
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        values[i2] = properties.get(i2).getValue();
                    }
                }
            } else {
                values = (String[])JRAbstractExporter.this.parameters.get(parameter);
            }
            return values;
        }

        public String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            String value = hintsMap != null && hintsMap.containsProperty(property) ? hintsMap.getProperty(property) : (String)JRAbstractExporter.this.parameters.get(parameter);
            if (value == null) {
                value = JRProperties.getProperty(property);
            }
            return value;
        }

        public boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
            Boolean param;
            String prop;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            boolean value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? JRProperties.getBooleanProperty(property) : JRProperties.asBoolean(prop)) : ((param = (Boolean)JRAbstractExporter.this.parameters.get(parameter)) == null ? JRProperties.getBooleanProperty(property) : param);
            return value;
        }

        public int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
            Integer param;
            String prop;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            int value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? JRProperties.getIntegerProperty(property) : JRProperties.asInteger(prop)) : ((param = (Integer)JRAbstractExporter.this.parameters.get(parameter)) == null ? JRProperties.getIntegerProperty(property) : param);
            return value;
        }

        public float getFloatParameter(JRExporterParameter parameter, String property, float defaultValue) {
            Float param;
            String prop;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            float value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? JRProperties.getFloatProperty(property) : JRProperties.asFloat(prop)) : ((param = (Float)JRAbstractExporter.this.parameters.get(parameter)) == null ? JRProperties.getFloatProperty(property) : param.floatValue());
            return value;
        }

        public Character getCharacterParameter(JRExporterParameter parameter, String property) {
            Character value;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            if (hintsMap != null && hintsMap.containsProperty(property)) {
                String prop = hintsMap.getProperty(property);
                value = JRProperties.asCharacter(prop);
            } else {
                value = (Character)JRAbstractExporter.this.parameters.get(parameter);
                if (value == null) {
                    value = JRProperties.getCharacterProperty(property);
                }
            }
            return value;
        }
    }

    protected class ParameterOverrideResolver
    implements ParameterResolver {
        protected ParameterOverrideResolver() {
        }

        public String getStringParameter(JRExporterParameter parameter, String property) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                return (String)JRAbstractExporter.this.parameters.get(parameter);
            }
            return JRProperties.getProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property);
        }

        public String[] getStringArrayParameter(JRExporterParameter parameter, String propertyPrefix) {
            String[] values = null;
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                values = (String[])JRAbstractExporter.this.parameters.get(parameter);
            } else {
                List<JRProperties.PropertySuffix> properties = JRProperties.getProperties(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), propertyPrefix);
                if (properties != null) {
                    values = new String[properties.size()];
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        values[i2] = properties.get(i2).getValue();
                    }
                }
            }
            return values;
        }

        public String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                String value = (String)JRAbstractExporter.this.parameters.get(parameter);
                if (value == null) {
                    return JRProperties.getProperty(property);
                }
                return value;
            }
            return JRProperties.getProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property);
        }

        public boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                Boolean booleanValue = (Boolean)JRAbstractExporter.this.parameters.get(parameter);
                if (booleanValue == null) {
                    return JRProperties.getBooleanProperty(property);
                }
                return booleanValue;
            }
            return JRProperties.getBooleanProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property, defaultValue);
        }

        public int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                Integer integerValue = (Integer)JRAbstractExporter.this.parameters.get(parameter);
                if (integerValue == null) {
                    return JRProperties.getIntegerProperty(property);
                }
                return integerValue;
            }
            return JRProperties.getIntegerProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property, defaultValue);
        }

        public float getFloatParameter(JRExporterParameter parameter, String property, float defaultValue) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                Float floatValue = (Float)JRAbstractExporter.this.parameters.get(parameter);
                if (floatValue == null) {
                    return JRProperties.getFloatProperty(property);
                }
                return floatValue.floatValue();
            }
            return JRProperties.getFloatProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property, defaultValue);
        }

        public Character getCharacterParameter(JRExporterParameter parameter, String property) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                return (Character)JRAbstractExporter.this.parameters.get(parameter);
            }
            return JRProperties.getCharacterProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property);
        }
    }

    protected static interface ParameterResolver {
        public String getStringParameter(JRExporterParameter var1, String var2);

        public String[] getStringArrayParameter(JRExporterParameter var1, String var2);

        public String getStringParameterOrDefault(JRExporterParameter var1, String var2);

        public boolean getBooleanParameter(JRExporterParameter var1, String var2, boolean var3);

        public int getIntegerParameter(JRExporterParameter var1, String var2, int var3);

        public float getFloatParameter(JRExporterParameter var1, String var2, float var3);

        public Character getCharacterParameter(JRExporterParameter var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class BaseExporterContext
    implements JRExporterContext {
        @Override
        public JRExporter getExporter() {
            return JRAbstractExporter.this;
        }

        @Override
        public JasperPrint getExportedReport() {
            return JRAbstractExporter.this.jasperPrint;
        }

        @Override
        public Map<JRExporterParameter, Object> getExportParameters() {
            return JRAbstractExporter.this.parameters;
        }

        @Override
        public int getOffsetX() {
            return JRAbstractExporter.this.getOffsetX();
        }

        @Override
        public int getOffsetY() {
            return JRAbstractExporter.this.getOffsetY();
        }
    }
}

