/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.FrameConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.RunDirectionEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CrosstabConverter
extends FrameConverter {
    private static final CrosstabConverter INSTANCE = new CrosstabConverter();

    private CrosstabConverter() {
    }

    public static ElementConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
        JRCrosstab crosstab = (JRCrosstab)element;
        printFrame.copyBox(crosstab.getLineBox());
        this.copyElement(reportConverter, crosstab, printFrame);
        List<JRPrintElement> children = this.getCrosstabChildren(reportConverter, crosstab);
        if (children != null && children.size() > 0) {
            for (int i2 = 0; i2 < children.size(); ++i2) {
                printFrame.addElement(children.get(i2));
            }
        }
        return printFrame;
    }

    private List<JRPrintElement> getCrosstabChildren(ReportConverter reportConverter, JRCrosstab crosstab) {
        ArrayList<JRPrintElement> crosstabElements = new ArrayList<JRPrintElement>();
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        int rowHeadersXOffset = 0;
        for (int i2 = 0; i2 < rowGroups.length; ++i2) {
            rowHeadersXOffset += rowGroups[i2].getWidth();
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        int colHeadersYOffset = 0;
        for (int i3 = 0; i3 < columnGroups.length; ++i3) {
            colHeadersYOffset += columnGroups[i3].getHeight();
        }
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null && headerCell.getWidth() != 0 && headerCell.getHeight() != 0) {
            crosstabElements.add(this.getCrosstabCellFrame(reportConverter, headerCell, 0, 0, false, false, false));
        }
        this.addCrosstabColumnHeaders(reportConverter, crosstab, rowHeadersXOffset, crosstabElements);
        this.addCrosstabRows(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset, crosstabElements);
        if (crosstab.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.mirrorElements(crosstabElements, crosstab.getX(), crosstab.getWidth());
        }
        return crosstabElements;
    }

    private void mirrorElements(List<JRPrintElement> elements, int x, int width) {
        for (JRPrintElement element : elements) {
            int mirrorX = width - element.getX() - element.getWidth();
            element.setX(mirrorX);
        }
    }

    private JRPrintFrame getCrosstabCellFrame(ReportConverter reportConverter, JRCellContents cell, int x, int y, boolean left, boolean right, boolean top) {
        List<JRChild> children;
        JRBasePrintFrame frame = new JRBasePrintFrame(cell.getDefaultStyleProvider());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(cell.getWidth());
        frame.setHeight(cell.getHeight());
        frame.setMode(cell.getModeValue());
        frame.setBackcolor(cell.getBackcolor());
        frame.setStyle(reportConverter.resolveStyle(cell));
        JRLineBox box = cell.getLineBox();
        if (box != null) {
            boolean copyTop;
            frame.copyBox(box);
            boolean copyLeft = left && box.getLeftPen().getLineWidth().floatValue() <= 0.0f && box.getRightPen().getLineWidth().floatValue() > 0.0f;
            boolean copyRight = right && box.getRightPen().getLineWidth().floatValue() <= 0.0f && box.getLeftPen().getLineWidth().floatValue() > 0.0f;
            boolean bl = copyTop = top && box.getTopPen().getLineWidth().floatValue() <= 0.0f && box.getBottomPen().getLineWidth().floatValue() > 0.0f;
            if (copyLeft) {
                ((JRBaseLineBox)frame.getLineBox()).copyLeftPen(box.getRightPen());
            }
            if (copyRight) {
                ((JRBaseLineBox)frame.getLineBox()).copyRightPen(box.getLeftPen());
            }
            if (copyTop) {
                ((JRBaseLineBox)frame.getLineBox()).copyTopPen(box.getBottomPen());
            }
        }
        if ((children = cell.getChildren()) != null && children.size() > 0) {
            ConvertVisitor convertVisitor = new ConvertVisitor(reportConverter, frame);
            for (int i2 = 0; i2 < children.size(); ++i2) {
                children.get(i2).visit(convertVisitor);
            }
        }
        return frame;
    }

    private void addCrosstabColumnHeaders(ReportConverter reportConverter, JRCrosstab crosstab, int rowHeadersXOffset, List<JRPrintElement> crosstabElements) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        int x = 0;
        int y = 0;
        for (int i2 = 0; i2 < groups.length; ++i2) {
            JRCellContents totalHeader;
            JRCellContents header;
            boolean firstOnRow;
            JRCellContents totalHeader2;
            JRCrosstabColumnGroup group = groups[i2];
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.START && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader2, rowHeadersXOffset + x, y, firstOnRow && crosstab.getRunDirectionValue() != RunDirectionEnum.RTL, firstOnRow && crosstab.getRunDirectionValue() == RunDirectionEnum.RTL, false));
                x += totalHeader2.getWidth();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, header, rowHeadersXOffset + x, y, firstOnRow && crosstab.getRunDirectionValue() != RunDirectionEnum.RTL, firstOnRow && crosstab.getRunDirectionValue() == RunDirectionEnum.RTL, false));
            }
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.END && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader, rowHeadersXOffset + x + header.getWidth(), y, false, false, false));
            }
            y += group.getHeight();
        }
    }

    private void addCrosstabRows(ReportConverter reportConverter, JRCrosstab crosstab, int rowHeadersXOffset, int colHeadersYOffset, List<JRPrintElement> crosstabElements) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        int x = 0;
        int y = 0;
        for (int i2 = 0; i2 < groups.length; ++i2) {
            JRCellContents totalHeader;
            JRCellContents header;
            JRCellContents totalHeader2;
            JRCrosstabRowGroup group = groups[i2];
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.START && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader2, x, colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y, i2, crosstabElements);
                y += totalHeader2.getHeight();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, header, x, colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
            }
            if (i2 == groups.length - 1) {
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y, groups.length, crosstabElements);
            }
            if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.END && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, totalHeader, x, colHeadersYOffset + y + header.getHeight(), false, false, false));
                this.addCrosstabDataCellsRow(reportConverter, crosstab, rowHeadersXOffset, colHeadersYOffset + y + header.getHeight(), i2, crosstabElements);
            }
            x += group.getWidth();
        }
    }

    private void addCrosstabDataCellsRow(ReportConverter reportConverter, JRCrosstab crosstab, int rowOffsetX, int rowOffsetY, int rowIndex, List<JRPrintElement> crosstabElements) {
        JRCrosstabCell[][] cells = crosstab.getCells();
        if (cells != null) {
            JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
            int crosstabX = rowOffsetX;
            int crosstabY = rowOffsetY;
            int x = 0;
            for (int i2 = 0; i2 < colGroups.length; ++i2) {
                JRCellContents contents;
                JRCrosstabCell cell;
                JRCrosstabColumnGroup group = colGroups[i2];
                if (group.getTotalPositionValue() == CrosstabTotalPositionEnum.START && (cell = cells[rowIndex][i2]) != null && (contents = cell.getContents()).getWidth() != 0 && contents.getHeight() != 0) {
                    crosstabElements.add(this.getCrosstabCellFrame(reportConverter, contents, crosstabX + x, crosstabY, false, false, false));
                    x += cells[rowIndex][i2].getContents().getWidth();
                }
                if (i2 == colGroups.length - 1 && (cell = cells[rowIndex][colGroups.length]) != null && (contents = cell.getContents()).getWidth() != 0 && contents.getHeight() != 0) {
                    crosstabElements.add(this.getCrosstabCellFrame(reportConverter, contents, crosstabX + x, crosstabY, false, false, false));
                }
                if (group.getTotalPositionValue() != CrosstabTotalPositionEnum.END || (cell = cells[rowIndex][i2]) == null || (contents = cell.getContents()).getWidth() == 0 || contents.getHeight() == 0) continue;
                crosstabElements.add(this.getCrosstabCellFrame(reportConverter, contents, crosstabX + x + group.getHeader().getWidth(), crosstabY, false, false, false));
            }
        }
    }
}

