/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;

final class JRDoubleVarianceIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRDoubleVarianceIncrementer mainInstance = new JRDoubleVarianceIncrementer();

    private JRDoubleVarianceIncrementer() {
    }

    public static JRDoubleVarianceIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRDoubleIncrementerFactory.ZERO;
        }
        Number countValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)0));
        Number sumValue = (Number)valueProvider.getValue(variable.getHelperVariable((byte)1));
        return new Double((countValue.doubleValue() - 1.0) * value.doubleValue() / countValue.doubleValue() + (sumValue.doubleValue() / countValue.doubleValue() - newValue.doubleValue()) * (sumValue.doubleValue() / countValue.doubleValue() - newValue.doubleValue()) / (countValue.doubleValue() - 1.0));
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        if (calculableValue.getValue() == null) {
            if (calculable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            return new Double(((Number)calculableValue.getIncrementedValue()).doubleValue());
        }
        double v1 = value.doubleValue();
        double c1 = ((Number)valueProvider.getValue(calculable.getHelperVariable((byte)0))).doubleValue();
        double s1 = ((Number)valueProvider.getValue(calculable.getHelperVariable((byte)1))).doubleValue();
        double v2 = ((Number)calculableValue.getIncrementedValue()).doubleValue();
        double c2 = ((Number)valueProvider.getValue(calculableValue.getHelperVariable((byte)0))).doubleValue();
        double s2 = ((Number)valueProvider.getValue(calculableValue.getHelperVariable((byte)1))).doubleValue();
        double c3 = (c1 -= c2) + c2;
        return new Double(c1 / c3 * v1 + c2 / c3 * v2 + c2 / c1 * (s1 -= s2) / c3 * s1 / c3 + c1 / c2 * s2 / c3 * s2 / c3 - 2.0 * s1 / c3 * s2 / c3);
    }

    public Object initialValue() {
        return JRDoubleIncrementerFactory.ZERO;
    }
}

