/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.harmony.security.Util;
import org.apache.harmony.security.internal.nls.Messages;

public class PolicyUtils {
    public static final String POLICY_ALLOW_DYNAMIC = "policy.allowSystemProperty";
    public static final String POLICY_EXPAND = "policy.expandProperties";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final Class[] NO_ARGS = new Class[0];
    private static final Class[] ONE_ARGS = new Class[]{String.class};
    private static final Class[] TWO_ARGS = new Class[]{String.class, String.class};

    private PolicyUtils() {
    }

    public static String expand(String string, Properties properties) throws ExpansionFailedException {
        int n2 = "${".length();
        int n3 = "}".length();
        StringBuilder stringBuilder = new StringBuilder(string);
        int n4 = stringBuilder.indexOf("${");
        while (n4 >= 0) {
            int n5 = stringBuilder.indexOf("}", n4);
            if (n5 >= 0) {
                String string2 = stringBuilder.substring(n4 + n2, n5);
                String string3 = properties.getProperty(string2);
                if (string3 != null) {
                    stringBuilder.replace(n4, n5 + n3, string3);
                    n4 += string3.length();
                } else {
                    throw new ExpansionFailedException(Messages.getString("security.14F", string2));
                }
            }
            n4 = stringBuilder.indexOf("${", n4);
        }
        return stringBuilder.toString();
    }

    public static String expandURL(String string, Properties properties) throws ExpansionFailedException {
        return PolicyUtils.expand(string, properties).replace(File.separatorChar, '/');
    }

    public static String expandGeneral(String string, GeneralExpansionHandler generalExpansionHandler) throws ExpansionFailedException {
        int n2 = "${{".length();
        int n3 = "}}".length();
        StringBuilder stringBuilder = new StringBuilder(string);
        int n4 = stringBuilder.indexOf("${{");
        while (n4 >= 0) {
            int n5 = stringBuilder.indexOf("}}", n4);
            if (n5 >= 0) {
                String string2 = stringBuilder.substring(n4 + n2, n5);
                int n6 = string2.indexOf(58);
                String string3 = n6 >= 0 ? string2.substring(0, n6) : string2;
                String string4 = n6 >= 0 ? string2.substring(n6 + 1) : null;
                String string5 = generalExpansionHandler.resolve(string3, string4);
                stringBuilder.replace(n4, n5 + n3, string5);
                n4 += string5.length();
            }
            n4 = stringBuilder.indexOf("${{", n4);
        }
        return stringBuilder.toString();
    }

    public static boolean canExpandProperties() {
        return !Util.equalsIgnoreCase(FALSE, AccessController.doPrivileged(new SecurityPropertyAccessor(POLICY_EXPAND)));
    }

    public static URL[] getPolicyURLs(Properties properties, String string, String string2) {
        Object object;
        SecurityPropertyAccessor securityPropertyAccessor = new SecurityPropertyAccessor(null);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        boolean bl = false;
        URL uRL = null;
        URL uRL2 = null;
        if (!Util.equalsIgnoreCase(FALSE, AccessController.doPrivileged(securityPropertyAccessor.key(POLICY_ALLOW_DYNAMIC)))) {
            String string3 = properties.getProperty("java.security.auth.policy");
            if (string3 != null) {
                if (string3.startsWith("=")) {
                    string3 = string3.substring(1);
                }
                try {
                    string3 = PolicyUtils.expandURL(string3, properties);
                    object = new File(string3);
                    uRL2 = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>((File)object){
                        final /* synthetic */ File val$f;
                        {
                            this.val$f = file;
                        }

                        @Override
                        public URL run() throws Exception {
                            if (this.val$f.exists()) {
                                return this.val$f.toURI().toURL();
                            }
                            return null;
                        }
                    });
                    if (uRL2 == null) {
                        uRL2 = new URL(string3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string3 = properties.getProperty(string)) != null) {
                if (string3.startsWith("=")) {
                    bl = true;
                    string3 = string3.substring(1);
                }
                try {
                    string3 = PolicyUtils.expandURL(string3, properties);
                    object = new File(string3);
                    uRL = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>((File)object){
                        final /* synthetic */ File val$f;
                        {
                            this.val$f = file;
                        }

                        @Override
                        public URL run() throws Exception {
                            if (this.val$f.exists()) {
                                return this.val$f.toURI().toURL();
                            }
                            return null;
                        }
                    });
                    if (uRL == null) {
                        uRL = new URL(string3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!bl) {
            int n2 = 1;
            while ((object = AccessController.doPrivileged(securityPropertyAccessor.key(string2 + n2++))) != null) {
                try {
                    object = PolicyUtils.expandURL((String)object, properties);
                    URL uRL3 = new URL((String)(object = PolicyUtils.getFileURL((String)object)));
                    if (uRL3 == null) continue;
                    arrayList.add(uRL3);
                }
                catch (Exception exception) {}
            }
        }
        if (uRL2 != null) {
            arrayList.add(uRL2);
        }
        if (uRL != null) {
            arrayList.add(uRL);
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static PermissionCollection toPermissionCollection(Collection<Permission> collection) {
        Permissions permissions = new Permissions();
        if (collection != null) {
            for (Permission permission : collection) {
                permissions.add(permission);
            }
        }
        return permissions;
    }

    public static Permission instantiatePermission(Class<?> clazz, String string, String string2) throws Exception {
        Class[][] classArray = null;
        Object[][] objectArray = null;
        if (string2 != null) {
            classArray = new Class[][]{TWO_ARGS, ONE_ARGS, NO_ARGS};
            objectArray = new Object[][]{{string, string2}, {string}, new Object[0]};
        } else if (string != null) {
            classArray = new Class[][]{ONE_ARGS, TWO_ARGS, NO_ARGS};
            objectArray = new Object[][]{{string}, {string, string2}, new Object[0]};
        } else {
            classArray = new Class[][]{NO_ARGS, ONE_ARGS, TWO_ARGS};
            objectArray = new Object[][]{new Object[0], {string}, {string, string2}};
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            try {
                Constructor<?> constructor = clazz.getConstructor(classArray[i2]);
                return (Permission)constructor.newInstance(objectArray[i2]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new IllegalArgumentException(Messages.getString("security.150", clazz));
    }

    public static boolean matchSubset(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            if (objectArray2 == null) {
                return false;
            }
            boolean bl = false;
            for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                if (!objectArray[i2].equals(objectArray2[i3])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static String getFileURL(String string) {
        int n2 = "file://".length();
        if (string.startsWith("file://") && string.length() > n2 && string.charAt(n2) != '/') {
            string = "file:/" + string.substring(n2, string.length());
        }
        return string;
    }

    public static interface GeneralExpansionHandler {
        public String resolve(String var1, String var2) throws ExpansionFailedException;
    }

    public static class ExpansionFailedException
    extends Exception {
        private static final long serialVersionUID = 2869748055182612000L;

        public ExpansionFailedException(String string) {
            super(string);
        }

        public ExpansionFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class ProviderLoader<T>
    implements PrivilegedAction<T> {
        private String key;
        private Class<T> expectedType;

        public ProviderLoader(String string, Class<T> clazz) {
            this.key = string;
            this.expectedType = clazz;
        }

        @Override
        public T run() {
            String string = Security.getProperty(this.key);
            if (string == null || string.length() == 0) {
                throw new SecurityException(Messages.getString("security.14C", this.key));
            }
            try {
                Class<T> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                if (this.expectedType != null && clazz.isAssignableFrom(this.expectedType)) {
                    throw new SecurityException(Messages.getString("security.14D", string, this.expectedType.getName()));
                }
                return (T)clazz.newInstance();
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                SecurityException securityException = new SecurityException(Messages.getString("security.14E", string));
                securityException.initCause(exception);
                throw securityException;
            }
        }
    }

    public static class SecurityPropertyAccessor
    implements PrivilegedAction<String> {
        private String key;

        public SecurityPropertyAccessor(String string) {
            this.key = string;
        }

        public PrivilegedAction<String> key(String string) {
            this.key = string;
            return this;
        }

        @Override
        public String run() {
            return Security.getProperty(this.key);
        }
    }

    public static class SystemPropertyAccessor
    implements PrivilegedAction<String> {
        public String key;

        public SystemPropertyAccessor(String string) {
            this.key = string;
        }

        public PrivilegedAction<String> key(String string) {
            this.key = string;
            return this;
        }

        @Override
        public String run() {
            return System.getProperty(this.key);
        }
    }

    public static class SystemKit
    implements PrivilegedAction<Properties> {
        @Override
        public Properties run() {
            return System.getProperties();
        }
    }

    public static class URLLoader
    implements PrivilegedExceptionAction<InputStream> {
        public URL location;

        public URLLoader(URL uRL) {
            this.location = uRL;
        }

        @Override
        public InputStream run() throws Exception {
            return this.location.openStream();
        }
    }
}

