/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.misc.CharacterEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexDumpEncoder
extends CharacterEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];

    static void hexDigit(OutputStream o2, byte x) {
        int workarea = 0;
        try {
            workarea = x >> 4;
            o2.write(HexDumpEncoder.trimIt(Integer.toHexString(workarea)).getBytes("8859_1"));
            workarea = x & 0xF;
            o2.write(HexDumpEncoder.trimIt(Integer.toHexString(workarea)).getBytes("8859_1"));
        }
        catch (Exception e2) {
            System.out.println("Unable to write to output stream: " + e2);
        }
    }

    private static String trimIt(String origResult) {
        if (origResult == null) {
            return new String("00");
        }
        int currLength = origResult.length();
        if (currLength == 0) {
            return new String("00");
        }
        if (currLength <= 2) {
            return origResult;
        }
        return origResult.substring(currLength - 1);
    }

    @Override
    protected int bytesPerAtom() {
        return 1;
    }

    @Override
    protected int bytesPerLine() {
        return 16;
    }

    @Override
    protected void encodeBufferPrefix(OutputStream o2) throws IOException {
        this.offset = 0;
        super.encodeBufferPrefix(o2);
    }

    @Override
    protected void encodeLinePrefix(OutputStream o2, int len) throws IOException {
        HexDumpEncoder.hexDigit(o2, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(o2, (byte)(this.offset & 0xFF));
        o2.write(58);
        o2.write(32);
        this.currentByte = 0;
        this.thisLineLength = len;
    }

    @Override
    protected void encodeAtom(OutputStream o2, byte[] buf, int off, int len) throws IOException {
        this.thisLine[this.currentByte] = buf[off];
        HexDumpEncoder.hexDigit(o2, buf[off]);
        o2.write(32);
        ++this.currentByte;
        if (this.currentByte == 8) {
            o2.write(32);
        }
    }

    @Override
    protected void encodeLineSuffix(OutputStream o2) throws IOException {
        int i2;
        if (this.thisLineLength < 16) {
            for (i2 = this.thisLineLength; i2 < 16; ++i2) {
                o2.write(32);
                o2.write(32);
                o2.write(32);
                if (i2 != 7) continue;
                o2.write(32);
                o2.write(32);
            }
        }
        o2.write(32);
        for (i2 = 0; i2 < this.thisLineLength; ++i2) {
            if (this.thisLine[i2] < 48 || this.thisLine[i2] > 122 || this.thisLine[i2] > 57 && this.thisLine[i2] < 65 || this.thisLine[i2] > 90 && this.thisLine[i2] < 97) {
                o2.write(46);
                continue;
            }
            o2.write(this.thisLine[i2]);
        }
        o2.write(10);
        this.offset += this.thisLineLength;
    }
}

