/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PKCSDerObject
implements Cloneable {
    protected String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PKCSDerObject";

    public PKCSDerObject() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCSDerObject");
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(String provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSDerObject", provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSDerObject", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(byte[] der, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PKCSDerObject", der, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(String filename, boolean base64) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "PKCSDerObject", parms);
        }
        if (base64) {
            this.readBASE64(filename);
        } else {
            this.read(filename);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(String filename, boolean base64, String provider) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PKCSDerObject", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (base64) {
            this.readBASE64(filename);
        } else {
            this.read(filename);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public byte[] encode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        this.encode(out);
        byte[] retval = out.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", retval);
        }
        return retval;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", this.toString().hashCode());
        }
        return this.toString().hashCode();
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", null);
        }
        return null;
    }

    public void write(String filename, boolean isBase64) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "write", filename, new Boolean(isBase64));
        }
        if (isBase64) {
            this.writeBASE64(filename);
        } else {
            this.write(filename);
        }
        if (debug != null) {
            debug.exit(16384L, className, "write");
        }
    }

    protected void decode(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", (Object)der);
        }
        try {
            DerInputStream derin = new DerInputStream(der);
            DerValue encoding = derin.getDerValue();
            this.decode(encoding);
        }
        catch (IOException ex) {
            if (debug != null) {
                System.out.println("The exception shown within the trace data below was thrown \nby PKCSDerObject.decode(byte[] der) while trying to decode \nan object that it assumed was in raw der encoded form. Either, \nthere is an error within that raw der encoded data which \nled to this exception, or the data itself was actually base64 \nencoded. PKCSDerObject.decode(byte[] der) will now re-attempt \nthe decoding operation. This time, however, it will assume \nthat the data is also base64 encoded, and will attempt to \nremove the base64 encoding before trying to decode the der \nencoded object. If a second exception is thrown, then there \nis likely either a der encoding problem with the object being \ndecoded (most likely) or there is a problem with the base64 \nencoding (less likely).");
                ex.printStackTrace();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(der);
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] encodingData = decoder.decodeBuffer(bis);
            DerInputStream derin = new DerInputStream(encodingData);
            DerValue encoding = derin.getDerValue();
            this.decode(encoding);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    protected void read(String filename) throws IOException {
        FileInputStream fis;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "read", filename);
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "read", e2);
            }
            throw new IOException("File " + filename + " not found.");
        }
        int numBytes = fis.available();
        byte[] encoding = new byte[numBytes];
        fis.read(encoding);
        fis.close();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "read");
        }
    }

    protected void readBASE64(String filename) throws IOException {
        FileInputStream fis;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", filename);
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", e2);
            }
            throw new IOException("File " + filename + " not found.");
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] encoding = decoder.decodeBuffer(fis);
        fis.close();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
    }

    protected void write(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "write", filename);
        }
        FileOutputStream fos = new FileOutputStream(filename);
        this.encode(fos);
        fos.close();
        if (debug != null) {
            debug.exit(16384L, className, "write");
        }
    }

    protected void writeBASE64(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeBASE64", filename);
        }
        FileOutputStream fos = new FileOutputStream(filename);
        DerOutputStream derout = new DerOutputStream();
        this.encode(derout);
        byte[] encoding = derout.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        encoder.encode(encoding, (OutputStream)fos);
        fos.close();
        if (debug != null) {
            debug.exit(16384L, className, "writeBASE64");
        }
    }

    protected abstract void decode(DerValue var1) throws IOException;

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract String toString();

    public abstract boolean equals(Object var1);
}

