/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.smime.SMIMEMessage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class SMIMEReceiver
implements Cloneable {
    private SMIMEMessage smimemsg;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.SMIMEReceiver";

    public SMIMEReceiver(byte[] message) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", (Object)message);
        }
        this.setSMIMEMessage(message);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(byte[] message, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", message, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.setSMIMEMessage(message);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", in);
        }
        byte[] bytes = new byte[in.available()];
        in.read(bytes);
        in.close();
        this.setSMIMEMessage(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(InputStream in, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", in, provider);
        }
        byte[] bytes = new byte[in.available()];
        if (provider != null) {
            this.provider = new String(provider);
        }
        in.read(bytes);
        in.close();
        this.setSMIMEMessage(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(String filename) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", filename);
        }
        FileInputStream fis = new FileInputStream(filename);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        this.setSMIMEMessage(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(String filename, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", filename, provider);
        }
        FileInputStream fis = new FileInputStream(filename);
        byte[] bytes = new byte[fis.available()];
        if (provider != null) {
            this.provider = new String(provider);
        }
        fis.read(bytes);
        fis.close();
        this.setSMIMEMessage(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(SMIMEMessage message) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", message);
        }
        this.setSMIMEMessage(message);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(SMIMEMessage message, String provider) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", message, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.setSMIMEMessage(message);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            SMIMEMessage message = (SMIMEMessage)this.getSMIMEMessage().clone();
            SMIMEReceiver smime = null;
            if (message != null) {
                smime = new SMIMEReceiver(message, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", smime);
            }
            return smime;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void setSMIMEMessage(byte[] message) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSMIMEMessage", (Object)message);
        }
        SMIMEMessage smimemessage = new SMIMEMessage(message, this.provider);
        this.setSMIMEMessage(smimemessage);
        if (debug != null) {
            debug.exit(8192L, className, "setSMIMEMessage");
        }
    }

    private void setSMIMEMessage(SMIMEMessage message) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSMIMEMessage", message);
        }
        this.smimemsg = message;
        if (debug != null) {
            debug.exit(8192L, className, "setSMIMEMessage");
        }
    }

    public SMIMEMessage getSMIMEMessage() {
        if (debug != null) {
            debug.entry(16384L, className, "getSMIMEMessage");
            debug.exit(16384L, (Object)className, "getSMIMEMessage", this.smimemsg);
        }
        return this.smimemsg;
    }

    public byte[] getContentInfoBytes() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfoBytes");
        }
        if (this.smimemsg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfoBytes_1", null);
            }
            return null;
        }
        byte[] bytes = this.smimemsg.getContentInfoBytes();
        if (bytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfoBytes_2", null);
            }
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] encoding = null;
        try {
            encoding = decoder.decodeBuffer(new String(bytes, "8859_1"));
        }
        catch (UnsupportedEncodingException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getContentInfoBytes", e2);
            }
            encoding = decoder.decodeBuffer(new String(bytes));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfoBytes_3", encoding);
        }
        return encoding;
    }

    public ContentInfo getContentInfo() throws IOException {
        byte[] bytes;
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if ((bytes = this.getContentInfoBytes()) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", new ContentInfo(bytes, this.provider));
        }
        return new ContentInfo(bytes, this.provider);
    }

    public byte[] getCertificationRequestBytes() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequestBytes");
        }
        if (this.smimemsg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes_1", null);
            }
            return null;
        }
        byte[] bytes = this.smimemsg.getCertificationRequestBytes();
        if (bytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes_2", null);
            }
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] encoding = null;
        try {
            encoding = decoder.decodeBuffer(new String(bytes, "8859_1"));
        }
        catch (UnsupportedEncodingException e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes", e2);
            }
            encoding = decoder.decodeBuffer(new String(bytes));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequestBytes_3", encoding);
        }
        return encoding;
    }

    public CertificationRequest getCertificationRequest() throws IOException {
        byte[] bytes;
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
        }
        if ((bytes = this.getCertificationRequestBytes()) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequest_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequest_2", new CertificationRequest(bytes, this.provider));
        }
        return new CertificationRequest(bytes, this.provider);
    }

    public byte[] getHeader() {
        if (debug != null) {
            debug.entry(16384L, className, "getHeader");
        }
        if (this.smimemsg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getHeader_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getHeader_2", this.smimemsg.getHeader());
        }
        return this.smimemsg.getHeader();
    }

    public String toString() {
        String out = "SMIMEReceiver:\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = out + this.smimemsg.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

