/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.DerInputBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class DerIndefLenConverter {
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private static final int SKIP_EOC_BYTES = 2;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private ArrayList ndefsList = new ArrayList();
    private int numOfTotalLenBytes = 0;

    private boolean isEOC(int tag) {
        return (tag & 0x1F) == 0 && (tag & 0x20) == 0 && (tag & 0xC0) == 0;
    }

    static boolean isLongForm(int lengthByte) {
        return (lengthByte & 0x80) == 128;
    }

    DerIndefLenConverter() {
    }

    static boolean isIndefinite(int lengthByte) {
        return DerIndefLenConverter.isLongForm(lengthByte) && (lengthByte & 0x7F) == 0;
    }

    private void parseTag() throws IOException {
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(this.data[this.dataPos]) && this.data[this.dataPos + 1] == 0) {
            int index;
            int numOfEncapsulatedLenBytes = 0;
            Object elem = null;
            for (index = this.ndefsList.size() - 1; index >= 0 && !((elem = this.ndefsList.get(index)) instanceof Integer); --index) {
                numOfEncapsulatedLenBytes += ((byte[])elem).length - 3;
            }
            if (index < 0) {
                throw new IOException("EOC does not have matching indefinite-length tag");
            }
            int sectionLen = this.dataPos - (Integer)elem + numOfEncapsulatedLenBytes;
            byte[] sectionLenBytes = this.getLengthBytes(sectionLen);
            this.ndefsList.set(index, sectionLenBytes);
            this.numOfTotalLenBytes += sectionLenBytes.length - 3;
        }
        ++this.dataPos;
    }

    private void writeTag() {
        byte tag;
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(tag = this.data[this.dataPos++]) && this.data[this.dataPos] == 0) {
            ++this.dataPos;
            this.writeTag();
        } else {
            this.newData[this.newDataPos++] = tag;
        }
    }

    private int parseLength() throws IOException {
        int lenByte;
        int curLen = 0;
        if (this.dataPos == this.dataSize) {
            return curLen;
        }
        if (DerIndefLenConverter.isIndefinite(lenByte = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(new Integer(this.dataPos));
            return curLen;
        }
        if (DerIndefLenConverter.isLongForm(lenByte)) {
            if ((lenByte &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < lenByte + 1) {
                throw new IOException("Too little data");
            }
            for (int i2 = 0; i2 < lenByte; ++i2) {
                curLen = (curLen << 8) + (this.data[this.dataPos++] & 0xFF);
            }
        } else {
            curLen = lenByte & 0x7F;
        }
        return curLen;
    }

    private void writeLengthAndValue() throws IOException {
        int lenByte;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int curLen = 0;
        if (DerIndefLenConverter.isIndefinite(lenByte = this.data[this.dataPos++] & 0xFF)) {
            byte[] lenBytes = (byte[])this.ndefsList.get(this.index++);
            System.arraycopy(lenBytes, 0, this.newData, this.newDataPos, lenBytes.length);
            this.newDataPos += lenBytes.length;
            return;
        }
        if (DerIndefLenConverter.isLongForm(lenByte)) {
            lenByte &= 0x7F;
            for (int i2 = 0; i2 < lenByte; ++i2) {
                curLen = (curLen << 8) + (this.data[this.dataPos++] & 0xFF);
            }
        } else {
            curLen = lenByte & 0x7F;
        }
        this.writeLength(curLen);
        this.writeValue(curLen);
    }

    private void writeLength(int curLen) {
        if (curLen < 128) {
            this.newData[this.newDataPos++] = (byte)curLen;
        } else if (curLen < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)curLen;
        } else if (curLen < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(curLen >> 8);
            this.newData[this.newDataPos++] = (byte)curLen;
        } else if (curLen < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(curLen >> 16);
            this.newData[this.newDataPos++] = (byte)(curLen >> 8);
            this.newData[this.newDataPos++] = (byte)curLen;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(curLen >> 24);
            this.newData[this.newDataPos++] = (byte)(curLen >> 16);
            this.newData[this.newDataPos++] = (byte)(curLen >> 8);
            this.newData[this.newDataPos++] = (byte)curLen;
        }
    }

    private byte[] getLengthBytes(int curLen) {
        byte[] lenBytes;
        int index = 0;
        if (curLen < 128) {
            lenBytes = new byte[1];
            lenBytes[index++] = (byte)curLen;
        } else if (curLen < 256) {
            lenBytes = new byte[2];
            lenBytes[index++] = -127;
            lenBytes[index++] = (byte)curLen;
        } else if (curLen < 65536) {
            lenBytes = new byte[3];
            lenBytes[index++] = -126;
            lenBytes[index++] = (byte)(curLen >> 8);
            lenBytes[index++] = (byte)curLen;
        } else if (curLen < 0x1000000) {
            lenBytes = new byte[4];
            lenBytes[index++] = -125;
            lenBytes[index++] = (byte)(curLen >> 16);
            lenBytes[index++] = (byte)(curLen >> 8);
            lenBytes[index++] = (byte)curLen;
        } else {
            lenBytes = new byte[5];
            lenBytes[index++] = -124;
            lenBytes[index++] = (byte)(curLen >> 24);
            lenBytes[index++] = (byte)(curLen >> 16);
            lenBytes[index++] = (byte)(curLen >> 8);
            lenBytes[index++] = (byte)curLen;
        }
        return lenBytes;
    }

    private int getNumOfLenBytes(int len) {
        int numOfLenBytes = 0;
        numOfLenBytes = len < 128 ? 1 : (len < 256 ? 2 : (len < 65536 ? 3 : (len < 0x1000000 ? 4 : 5)));
        return numOfLenBytes;
    }

    private void parseValue(int curLen) {
        this.dataPos += curLen;
    }

    private void writeValue(int curLen) {
        for (int i2 = 0; i2 < curLen; ++i2) {
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
        }
    }

    private static int getLength(byte[] in) throws IOException {
        int value;
        int lenByte = in[1];
        int counter = 2;
        int tmp = lenByte;
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + tmp + ", " + (tmp < 0 ? "incorrect DER encoding." : "too big."));
            }
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in[counter++];
                --tmp;
            }
        }
        return value;
    }

    static byte[] convertIndefToDef(byte[] data) throws IOException {
        byte[] result = DerIndefLenConverter.convertIndefToDef(new DerInputBuffer(data));
        return result;
    }

    static byte[] convertIndefToDef(InputStream data) throws IOException {
        data.mark(4);
        int tag = data.read();
        int length = DerIndefLenConverter.getLength(data);
        if (length == -1) {
            if ((tag & 0x3F) == 48 || (tag & 0x3F) == 49) {
                return DerIndefLenConverter.getIndefSeqSet(data, tag &= 0x3F);
            }
            if ((tag & 0xE0) == 160) {
                return DerIndefLenConverter.getIndefSeqSet(data, tag);
            }
            if ((tag & 0x3F) == 35) {
                return DerIndefLenConverter.getIndefBitString(data);
            }
            if ((tag & 0x3F) == 36) {
                return DerIndefLenConverter.getIndefOctetString(data);
            }
            if ((tag & 0x3F) == 45) {
                return DerIndefLenConverter.getIndefSimpleString(data, tag);
            }
        }
        byte[] returnbytes = new byte[data.available()];
        data.read(returnbytes);
        return returnbytes;
    }

    static byte[] putLength(int len) throws IOException {
        byte[] result = null;
        result = len < 128 ? new byte[]{(byte)len} : (len < 256 ? new byte[]{-127, (byte)len} : (len < 65536 ? new byte[]{-126, (byte)(len >> 8), (byte)len} : (len < 0x1000000 ? new byte[]{-125, (byte)(len >> 16), (byte)(len >> 8), (byte)len} : new byte[]{-124, (byte)(len >> 24), (byte)(len >> 16), (byte)(len >> 8), (byte)len})));
        return result;
    }

    private static byte[] getIndefSeqSet(InputStream buffer, int type) throws IOException {
        byte[] resultBytes;
        ArrayList<Byte> result = new ArrayList<Byte>();
        byte[] tmp = null;
        byte tag = 0;
        int length = 0;
        while (buffer.available() > 0) {
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = buffer.read();
            if (tag == 0 && (length & 0xFF) == 0) break;
            if ((length & 0xFF) == 128) {
                buffer.reset();
                tmp = DerIndefLenConverter.convertIndefToDef(buffer);
            } else if ((length & 0xFF) != 128) {
                buffer.reset();
                tag = (byte)buffer.read();
                length = DerIndefLenConverter.getLength(buffer);
                byte[] tlen = DerIndefLenConverter.putLength(length);
                tmp = new byte[1 + length + tlen.length];
                tmp[0] = tag;
                System.arraycopy(tlen, 0, tmp, 1, tlen.length);
                if (buffer.read(tmp, 1 + tlen.length, length) != length) {
                    throw new IOException("short read of DER OctetString");
                }
            } else {
                throw new IOException("DER input not a BMP string; invalid length");
            }
            for (int i2 = 0; i2 < tmp.length; ++i2) {
                result.add(new Byte(tmp[i2]));
            }
            tmp = null;
        }
        if (result.size() > 0) {
            byte[] tlen = DerIndefLenConverter.putLength(result.size());
            resultBytes = new byte[tlen.length + 1 + result.size()];
            resultBytes[0] = (byte)type;
            System.arraycopy(tlen, 0, resultBytes, 1, tlen.length);
            int i3 = tlen.length + 1;
            for (int j2 = 0; j2 < result.size(); ++j2) {
                resultBytes[i3] = (Byte)result.get(j2);
                ++i3;
            }
        } else {
            resultBytes = new byte[]{(byte)type, 0};
        }
        result = null;
        return resultBytes;
    }

    private static byte[] getIndefOctetString(InputStream buffer) throws IOException {
        byte[] result = null;
        byte[] tmp = null;
        byte tag = 0;
        byte length = 0;
        while (true) {
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = (byte)buffer.read();
            if (tag == 0 && length == 0) {
                if (result != null) {
                    byte[] tlen = DerIndefLenConverter.putLength(result.length);
                    tmp = new byte[tlen.length + 1 + result.length];
                    tmp[0] = 4;
                    System.arraycopy(tlen, 0, tmp, 1, tlen.length);
                    System.arraycopy(result, 0, tmp, tlen.length + 1, result.length);
                } else {
                    tmp = new byte[]{4, 0};
                }
                result = null;
                return tmp;
            }
            if (tag == 36 && (length & 0xFF) == 128) {
                tmp = DerIndefLenConverter.getIndefOctetString(buffer);
                int newlen = DerIndefLenConverter.getLength(tmp);
                byte[] t1 = new byte[newlen];
                System.arraycopy(tmp, tmp.length - newlen, t1, 0, t1.length);
                tmp = t1;
            } else if (tag == 4 && (length & 0xFF) != 128) {
                buffer.reset();
                buffer.read();
                length = (byte)DerIndefLenConverter.getLength(buffer);
                tmp = new byte[length];
                if (buffer.read(tmp) != length) {
                    throw new IOException("short read of DER OctetString");
                }
            } else {
                throw new IOException("DER input not an Octet string; invalid length");
            }
            byte[] t1 = new byte[(result == null ? 0 : result.length) + (tmp == null ? 0 : tmp.length)];
            int index = 0;
            if (result != null) {
                System.arraycopy(result, 0, t1, 0, result.length);
                index += result.length;
            }
            if (tmp != null) {
                System.arraycopy(tmp, 0, t1, index, tmp.length);
            }
            result = t1;
            t1 = null;
            tmp = null;
        }
    }

    private static byte[] getIndefBitString(InputStream buffer) throws IOException {
        Object result = null;
        byte[] tmp = null;
        byte tag = 0;
        byte length = 0;
        while (true) {
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = (byte)buffer.read();
            if (tag == 36 && length == 128) {
                tmp = DerIndefLenConverter.getIndefBitString(buffer);
            } else if (tag == 4 && length >= 0) {
                buffer.reset();
                buffer.read();
                length = (byte)DerIndefLenConverter.getLength(buffer);
                tmp = new byte[length];
                if (buffer.read(tmp) != length) {
                    throw new IOException("short read of DER OctetString");
                }
            } else {
                throw new IOException("DER input not a BMP string; invalid length");
            }
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = (byte)buffer.read();
            byte[] t1 = new byte[(result).length + tmp.length];
            if (tag == 0 && length == 0) {
                t1[0] = tmp[0];
                System.arraycopy(result, 0, t1, 1, (result).length);
                System.arraycopy(tmp, 1, t1, (result).length + 1, tmp.length - 1);
                return t1;
            }
            buffer.reset();
            System.arraycopy(result, 0, t1, 0, (result).length);
            System.arraycopy(tmp, 0, t1, (result).length, tmp.length);
            t1 = null;
            tmp = null;
        }
    }

    private static byte[] getIndefBMPString(InputStream buffer) throws IOException {
        byte[] result = null;
        byte[] tmp = null;
        byte tag = 0;
        int length = 0;
        while (true) {
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = buffer.read();
            if (tag == 0 && length == 0) {
                return result;
            }
            if (tag == 62 && length == 128) {
                tmp = DerIndefLenConverter.getIndefBMPString(buffer);
            } else if (tag == 30 && length >= 0) {
                buffer.reset();
                buffer.read();
                length = DerIndefLenConverter.getLength(buffer);
                if (length % 2 != 0) {
                    throw new IOException("DER input not a BMP string; invalid length");
                }
                tmp = new byte[length];
                if (buffer.read(tmp) != length) {
                    throw new IOException("short read of DER BMPString");
                }
            } else {
                throw new IOException("DER input not a BMP string or invalid length");
            }
            byte[] t1 = new byte[result.length + tmp.length];
            System.arraycopy(result, 0, t1, 0, result.length);
            System.arraycopy(tmp, 0, t1, result.length, tmp.length);
            t1 = null;
            tmp = null;
        }
    }

    private static byte[] getIndefSimpleString(InputStream buffer, int type) throws IOException {
        byte[] result = null;
        byte[] tmp = null;
        byte tag = 0;
        int length = 0;
        while (true) {
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = buffer.read();
            if (tag == 0 && length == 0) {
                return result;
            }
            if (tag == type && length == 128) {
                tmp = DerIndefLenConverter.getIndefSimpleString(buffer, type);
            } else if (tag == (type & 0xDF) && length >= 0) {
                buffer.reset();
                buffer.read();
                length = DerIndefLenConverter.getLength(buffer);
                tmp = new byte[length];
                if (buffer.read(tmp) != length) {
                    throw new IOException("short read of DER String");
                }
            } else {
                throw new IOException("DER input not a string or invalid length");
            }
            byte[] t1 = new byte[result.length + tmp.length];
            System.arraycopy(result, 0, t1, 0, result.length);
            System.arraycopy(tmp, 0, t1, result.length, tmp.length);
            t1 = null;
            tmp = null;
        }
    }

    private static byte[] getIndefUTF8String(InputStream buffer) throws IOException {
        byte[] result = null;
        byte[] tmp = null;
        byte tag = 0;
        int length = 0;
        while (true) {
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = buffer.read();
            if (tag == 0 && length == 0) {
                return result;
            }
            if (tag == 44 && length == 128) {
                tmp = DerIndefLenConverter.getIndefUTF8String(buffer);
            } else if (tag == 12 && length >= 0) {
                buffer.reset();
                buffer.read();
                length = DerIndefLenConverter.getLength(buffer);
                tmp = new byte[length];
                if (buffer.read(tmp) != length) {
                    throw new IOException("short read of DER UTF8String");
                }
            } else {
                throw new IOException("DER input not a UTF8String or invalid length");
            }
            byte[] t1 = new byte[result.length + tmp.length];
            System.arraycopy(result, 0, t1, 0, result.length);
            System.arraycopy(tmp, 0, t1, result.length, tmp.length);
            t1 = null;
            tmp = null;
        }
    }

    private static byte[] getIndefUniversalString(InputStream buffer) throws IOException {
        byte[] result = null;
        byte[] tmp = null;
        byte tag = 0;
        int length = 0;
        while (true) {
            buffer.mark(4);
            tag = (byte)buffer.read();
            length = buffer.read();
            if (tag == 0 && length == 0) {
                return result;
            }
            if (tag == 60 && length == 128) {
                tmp = DerIndefLenConverter.getIndefUniversalString(buffer);
            } else if (tag == 28 && length >= 0) {
                buffer.reset();
                buffer.read();
                length = DerIndefLenConverter.getLength(buffer);
                tmp = new byte[length];
                if (buffer.read(tmp) != length) {
                    throw new IOException("short read of DER UniversalString");
                }
            } else {
                throw new IOException("DER input not a UniversalString or invalid length");
            }
            byte[] t1 = new byte[result.length + tmp.length];
            System.arraycopy(result, 0, t1, 0, result.length);
            System.arraycopy(tmp, 0, t1, result.length, tmp.length);
            t1 = null;
            tmp = null;
        }
    }

    static int getLength(InputStream in) throws IOException {
        return DerIndefLenConverter.getLength(in.read(), in);
    }

    static int getLength(int lenByte, InputStream in) throws IOException {
        int value;
        int tmp = lenByte;
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + tmp + ", " + (tmp < 0 ? "incorrect DER encoding." : "too big."));
            }
            in.mark(4);
            in.reset();
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
        }
        return value;
    }
}

