/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util.calendar;

public class CalendarUtils {
    public static final boolean isGregorianLeapYear(int gregorianYear) {
        return gregorianYear % 4 == 0 && (gregorianYear % 100 != 0 || gregorianYear % 400 == 0);
    }

    public static final boolean isJulianLeapYear(int normalizedJulianYear) {
        return normalizedJulianYear % 4 == 0;
    }

    public static final long floorDivide(long n2, long d2) {
        return n2 >= 0L ? n2 / d2 : (n2 + 1L) / d2 - 1L;
    }

    public static final int floorDivide(int n2, int d2) {
        return n2 >= 0 ? n2 / d2 : (n2 + 1) / d2 - 1;
    }

    public static final int floorDivide(int n2, int d2, int[] r2) {
        if (n2 >= 0) {
            r2[0] = n2 % d2;
            return n2 / d2;
        }
        int q2 = (n2 + 1) / d2 - 1;
        r2[0] = n2 - q2 * d2;
        return q2;
    }

    public static final int floorDivide(long n2, int d2, int[] r2) {
        if (n2 >= 0L) {
            r2[0] = (int)(n2 % (long)d2);
            return (int)(n2 / (long)d2);
        }
        int q2 = (int)((n2 + 1L) / (long)d2 - 1L);
        r2[0] = (int)(n2 - (long)(q2 * d2));
        return q2;
    }

    public static final long mod(long x, long y) {
        return x - y * CalendarUtils.floorDivide(x, y);
    }

    public static final int mod(int x, int y) {
        return x - y * CalendarUtils.floorDivide(x, y);
    }

    public static final int amod(int x, int y) {
        int z = CalendarUtils.mod(x, y);
        return z == 0 ? y : z;
    }

    public static final long amod(long x, long y) {
        long z = CalendarUtils.mod(x, y);
        return z == 0L ? y : z;
    }

    public static final StringBuilder sprintf0d(StringBuilder sb, int value, int width) {
        int i2;
        long d2 = value;
        if (d2 < 0L) {
            sb.append('-');
            d2 = -d2;
            --width;
        }
        int n2 = 10;
        for (i2 = 2; i2 < width; ++i2) {
            n2 *= 10;
        }
        for (i2 = 1; i2 < width && d2 < (long)n2; ++i2) {
            sb.append('0');
            n2 /= 10;
        }
        sb.append(d2);
        return sb;
    }

    public static final StringBuffer sprintf0d(StringBuffer sb, int value, int width) {
        int i2;
        long d2 = value;
        if (d2 < 0L) {
            sb.append('-');
            d2 = -d2;
            --width;
        }
        int n2 = 10;
        for (i2 = 2; i2 < width; ++i2) {
            n2 *= 10;
        }
        for (i2 = 1; i2 < width && d2 < (long)n2; ++i2) {
            sb.append('0');
            n2 /= 10;
        }
        sb.append(d2);
        return sb;
    }
}

