/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public final class SerialNumber {
    private BigInteger serialNum;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.SerialNumber";

    private void construct(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "construct", derVal);
        }
        this.serialNum = derVal.getInteger();
        if (derVal.getData().available() != 0) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Excess SerialNumber data");
            }
            throw new IOException("Excess SerialNumber data");
        }
        if (debug != null) {
            debug.exit(8192L, className, "construct");
        }
    }

    public SerialNumber(BigInteger num) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", num);
            debug.exit(16384L, className, "SerialNumber");
        }
        this.serialNum = num;
    }

    public SerialNumber(int num) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", new Integer(num));
        }
        this.serialNum = BigInteger.valueOf(num);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public SerialNumber(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", in);
        }
        DerValue derVal = in.getDerValue();
        this.construct(derVal);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public SerialNumber(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", val);
        }
        this.construct(val);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public SerialNumber(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", in);
        }
        DerValue derVal = new DerValue(in);
        this.construct(derVal);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "SerialNumber: [" + this.serialNum.toString() + "]");
        }
        return "SerialNumber: [" + this.serialNum.toString() + "]";
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putInteger(this.serialNum);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public BigInteger getNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getNumber");
            debug.exit(16384L, (Object)className, "getNumber", this.serialNum);
        }
        return this.serialNum;
    }
}

