/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public final class X509CRLEntryImpl
extends X509CRLEntry {
    private SerialNumber serialNumber = null;
    private Date revocationDate = null;
    private CRLExtensions extensions = null;
    private byte[] revokedCert = null;
    private static final boolean isExplicit = false;
    private static final long YR_2050 = 2524636800000L;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509CRLEntryImpl";

    private X509CRLEntryImpl() {
        if (debug != null) {
            debug.entry(16384L, className, "X509CRLEntryImpl");
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(BigInteger num, Date date) {
        if (debug != null) {
            debug.entry(16384L, className, "X509CRLEntryImpl", num, date);
        }
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date != null ? new Date(date.getTime()) : date;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(BigInteger num, Date date, CRLExtensions crlEntryExts) {
        if (debug != null) {
            Object[] parms = new Object[]{num, date, crlEntryExts};
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", parms);
        }
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date != null ? new Date(date.getTime()) : date;
        this.extensions = crlEntryExts;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(byte[] revokedCert) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", (Object)revokedCert);
        }
        try {
            this.parse(new DerValue(revokedCert));
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLEntryImpl", e2);
            }
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", derValue);
        }
        try {
            this.parse(derValue);
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLEntryImpl", e2);
            }
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    @Override
    public boolean hasExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "hasExtensions");
        }
        boolean result = false;
        if (this.extensions != null) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasExtensions", new Boolean(result));
        }
        return result;
    }

    public void encode(DerOutputStream outStrm) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outStrm);
        }
        try {
            if (this.revokedCert == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.serialNumber.encode(tmp);
                if (this.revocationDate.getTime() < 2524636800000L) {
                    tmp.putUTCTime(this.revocationDate);
                } else {
                    tmp.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(tmp, false);
                }
                DerOutputStream seq = new DerOutputStream();
                seq.write((byte)48, tmp);
                this.revokedCert = seq.toByteArray();
            }
            outStrm.write(this.revokedCert);
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e2);
            }
            throw new CRLException("Encoding error: " + e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        byte[] result = (byte[])this.revokedCert.clone();
        if (debug != null) {
            debug.exit(16384L, className, "getEncoded");
        }
        return result;
    }

    @Override
    public BigInteger getSerialNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getSerialNumber");
            debug.exit(16384L, (Object)className, "getSerialNumber", this.serialNumber.getNumber());
        }
        return this.serialNumber.getNumber();
    }

    @Override
    public Date getRevocationDate() {
        if (debug != null) {
            debug.entry(16384L, className, "getRevocationDate");
            debug.exit(16384L, (Object)className, "getRevocationDate", new Date(this.revocationDate.getTime()));
        }
        return new Date(this.revocationDate.getTime());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serialNumber.toString());
        sb.append("  On: " + this.revocationDate.toString());
        if (this.extensions != null) {
            Collection<Extension> allEntryExts = this.extensions.getAllExtensions();
            Object[] objs = allEntryExts.toArray();
            sb.append("\n    CRL Entry Extensions: " + objs.length);
            for (int i2 = 0; i2 < objs.length; ++i2) {
                sb.append("\n    [" + (i2 + 1) + "]: ");
                Extension ext = (Extension)objs[i2];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext.toString());
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: DER encoded OCTET string =\n" + enc.encodeBuffer(extValue) + "\n");
                        continue;
                    }
                    sb.append(ext.toString());
                    continue;
                }
                catch (Exception e2) {
                    sb.append(", Error parsing this extension");
                }
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
        }
        boolean result = false;
        if (this.extensions != null) {
            result = this.extensions.hasUnsupportedCriticalExtension();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(result));
        }
        return result;
    }

    public Set getCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        HashSet<String> extSet = new HashSet<String>(11);
        Enumeration<Extension> e2 = this.extensions.getElements();
        while (e2.hasMoreElements()) {
            Extension ex = e2.nextElement();
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", extSet);
        }
        return extSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getNonCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        HashSet<String> extSet = new HashSet<String>(11);
        Enumeration<Extension> e2 = this.extensions.getElements();
        while (e2.hasMoreElements()) {
            Extension ex = e2.nextElement();
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", extSet);
        }
        return extSet;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getExtensionValue", oid);
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
            }
            return null;
        }
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                ObjectIdentifier findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e2 = this.extensions.getElements();
                while (e2.hasMoreElements()) {
                    ex = e2.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_3", null);
                }
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            byte[] result = out.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue", result);
            }
            return result;
        }
        catch (Exception e3) {
            if (debug != null) {
                debug.exception(16384L, className, "getExtensionValue", e3);
                debug.exit(16384L, (Object)className, "getExtensionValue_4", null);
            }
            return null;
        }
    }

    private void parse(DerValue derVal) throws CRLException, IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", derVal);
        }
        if (derVal.getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Invalid encoded RevokedCertificate, starting sequence tag missing.");
            }
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derVal.getData().available() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "No data encoded for RevokedCertificates");
            }
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derVal.toByteArray();
        DerInputStream in = derVal.toDerInputStream();
        DerValue val = in.getDerValue();
        this.serialNumber = new SerialNumber(val);
        int nextByte = derVal.getData().peekByte();
        if ((byte)nextByte == 23) {
            this.revocationDate = derVal.getData().getUTCTime();
        } else if ((byte)nextByte == 24) {
            this.revocationDate = derVal.getData().getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Invalid encoding for revocation date");
            }
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derVal.getData().available() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "parse_1");
            }
            return;
        }
        this.extensions = new CRLExtensions(derVal.toDerInputStream());
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }
}

