/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class ICC_Profile {
    protected byte[] data;
    protected int numComponents;
    private static HashMap<String, Integer> cstags = new HashMap();

    static {
        cstags.put("XYZ ", new Integer(3));
        cstags.put("Lab ", new Integer(3));
        cstags.put("Luv ", new Integer(3));
        cstags.put("YCbr", new Integer(3));
        cstags.put("Yxy ", new Integer(3));
        cstags.put("RGB ", new Integer(3));
        cstags.put("GRAY", new Integer(1));
        cstags.put("HSV ", new Integer(3));
        cstags.put("HLS ", new Integer(3));
        cstags.put("CMYK", new Integer(4));
        cstags.put("CMY ", new Integer(3));
        cstags.put("2CLR", new Integer(2));
        cstags.put("3CLR", new Integer(3));
        cstags.put("4CLR", new Integer(4));
        cstags.put("5CLR", new Integer(5));
        cstags.put("6CLR", new Integer(6));
        cstags.put("7CLR", new Integer(7));
        cstags.put("8CLR", new Integer(8));
        cstags.put("9CLR", new Integer(9));
        cstags.put("ACLR", new Integer(10));
        cstags.put("BCLR", new Integer(11));
        cstags.put("CCLR", new Integer(12));
        cstags.put("DCLR", new Integer(13));
        cstags.put("ECLR", new Integer(14));
        cstags.put("FCLR", new Integer(15));
    }

    protected ICC_Profile() {
    }

    public static ICC_Profile getInstance(byte[] data) {
        try {
            if (data.length < 128 || data[36] != 97 || data[37] != 99 || data[38] != 115 || data[39] != 112) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
            }
            ICC_Profile icc = new ICC_Profile();
            icc.data = data;
            Integer cs = cstags.get(new String(data, 16, 4, "US-ASCII"));
            icc.numComponents = cs == null ? 0 : cs;
            return icc;
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
    }

    public static ICC_Profile getInstance(InputStream file) {
        try {
            byte[] head = new byte[128];
            int remain = head.length;
            int ptr = 0;
            while (remain > 0) {
                int n2 = file.read(head, ptr, remain);
                if (n2 < 0) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
                }
                remain -= n2;
                ptr += n2;
            }
            if (head[36] != 97 || head[37] != 99 || head[38] != 115 || head[39] != 112) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
            }
            remain = (head[0] & 0xFF) << 24 | (head[1] & 0xFF) << 16 | (head[2] & 0xFF) << 8 | head[3] & 0xFF;
            byte[] icc = new byte[remain];
            System.arraycopy(head, 0, icc, 0, head.length);
            remain -= head.length;
            ptr = head.length;
            while (remain > 0) {
                int n3 = file.read(icc, ptr, remain);
                if (n3 < 0) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.icc.profile"));
                }
                remain -= n3;
                ptr += n3;
            }
            return ICC_Profile.getInstance(icc);
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
    }

    public static ICC_Profile GetInstance(String fname) {
        FileInputStream fs = null;
        try {
            ICC_Profile icc;
            fs = new FileInputStream(fname);
            ICC_Profile iCC_Profile = icc = ICC_Profile.getInstance(fs);
            return iCC_Profile;
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception exception) {}
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getNumComponents() {
        return this.numComponents;
    }
}

