/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNumberTree {
    private static final int leafSize = 64;

    public static <O extends PdfObject> PdfDictionary writeTree(HashMap<Integer, O> items, PdfWriter writer) throws IOException {
        if (items.isEmpty()) {
            return null;
        }
        Object[] numbers = new Integer[items.size()];
        numbers = items.keySet().toArray(numbers);
        Arrays.sort(numbers);
        if (numbers.length <= 64) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            int k2 = 0;
            while (k2 < numbers.length) {
                ar.add(new PdfNumber((Integer)numbers[k2]));
                ar.add((PdfObject)items.get(numbers[k2]));
                ++k2;
            }
            dic.put(PdfName.NUMS, ar);
            return dic;
        }
        int skip = 64;
        PdfIndirectReference[] kids = new PdfIndirectReference[(numbers.length + 64 - 1) / 64];
        int k3 = 0;
        while (k3 < kids.length) {
            int offset = k3 * 64;
            int end = Math.min(offset + 64, numbers.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfNumber((Integer)numbers[offset]));
            arr.add(new PdfNumber((Integer)numbers[end - 1]));
            dic.put(PdfName.LIMITS, arr);
            arr = new PdfArray();
            while (offset < end) {
                arr.add(new PdfNumber((Integer)numbers[offset]));
                arr.add((PdfObject)items.get(numbers[offset]));
                ++offset;
            }
            dic.put(PdfName.NUMS, arr);
            kids[k3] = writer.addToBody(dic).getIndirectReference();
            ++k3;
        }
        int top = kids.length;
        while (true) {
            int k4;
            if (top <= 64) {
                PdfArray arr = new PdfArray();
                k4 = 0;
                while (k4 < top) {
                    arr.add(kids[k4]);
                    ++k4;
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.KIDS, arr);
                return dic;
            }
            int tt = (numbers.length + (skip *= 64) - 1) / skip;
            k4 = 0;
            while (k4 < tt) {
                int offset = k4 * 64;
                int end = Math.min(offset + 64, top);
                PdfDictionary dic = new PdfDictionary();
                PdfArray arr = new PdfArray();
                arr.add(new PdfNumber((Integer)numbers[k4 * skip]));
                arr.add(new PdfNumber((Integer)numbers[Math.min((k4 + 1) * skip, numbers.length) - 1]));
                dic.put(PdfName.LIMITS, arr);
                arr = new PdfArray();
                while (offset < end) {
                    arr.add(kids[offset]);
                    ++offset;
                }
                dic.put(PdfName.KIDS, arr);
                kids[k4] = writer.addToBody(dic).getIndirectReference();
                ++k4;
            }
            top = tt;
        }
    }

    private static void iterateItems(PdfDictionary dic, HashMap<Integer, PdfObject> items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.NUMS));
                if (nn == null) break block2;
                int k2 = 0;
                while (k2 < nn.size()) {
                    PdfNumber s2 = (PdfNumber)PdfReader.getPdfObjectRelease(nn.getPdfObject(k2++));
                    items.put(new Integer(s2.intValue()), nn.getPdfObject(k2));
                    ++k2;
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            int k3 = 0;
            while (k3 < nn.size()) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease(nn.getPdfObject(k3));
                PdfNumberTree.iterateItems(kid, items);
                ++k3;
            }
        }
    }

    public static HashMap<Integer, PdfObject> readTree(PdfDictionary dic) {
        HashMap<Integer, PdfObject> items = new HashMap<Integer, PdfObject>();
        if (dic != null) {
            PdfNumberTree.iterateItems(dic, items);
        }
        return items;
    }
}

