/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.TSAClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.tsp.TimeStampToken;

public class PdfPKCS7 {
    private byte[] sigAttr;
    private byte[] digestAttr;
    private int version;
    private int signerversion;
    private Set<String> digestalgos;
    private Collection<Certificate> certs;
    private Collection<CRL> crls;
    private Collection<Certificate> signCerts;
    private X509Certificate signCert;
    private byte[] digest;
    private MessageDigest messageDigest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private transient PrivateKey privKey;
    private byte[] RSAdata;
    private boolean verified;
    private boolean verifyResult;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private String provider;
    private static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private static final String ID_RSA = "1.2.840.113549.1.1.1";
    private static final String ID_DSA = "1.2.840.10040.4.1";
    private static final String ID_CONTENT_TYPE = "1.2.840.113549.1.9.3";
    private static final String ID_MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
    private static final String ID_SIGNING_TIME = "1.2.840.113549.1.9.5";
    private static final String ID_ADBE_REVOCATION = "1.2.840.113583.1.1.8";
    private String reason;
    private String location;
    private Calendar signDate;
    private String signName;
    private TimeStampToken timeStampToken;
    private static final HashMap<String, String> digestNames = new HashMap();
    private static final HashMap<String, String> algorithmNames = new HashMap();
    private static final HashMap<String, String> allowedDigests = new HashMap();
    private BasicOCSPResp basicResp;

    static {
        digestNames.put("1.2.840.113549.2.5", "MD5");
        digestNames.put("1.2.840.113549.2.2", "MD2");
        digestNames.put("1.3.14.3.2.26", "SHA1");
        digestNames.put("2.16.840.1.101.3.4.2.4", "SHA224");
        digestNames.put("2.16.840.1.101.3.4.2.1", "SHA256");
        digestNames.put("2.16.840.1.101.3.4.2.2", "SHA384");
        digestNames.put("2.16.840.1.101.3.4.2.3", "SHA512");
        digestNames.put("1.3.36.3.2.2", "RIPEMD128");
        digestNames.put("1.3.36.3.2.1", "RIPEMD160");
        digestNames.put("1.3.36.3.2.3", "RIPEMD256");
        digestNames.put("1.2.840.113549.1.1.4", "MD5");
        digestNames.put("1.2.840.113549.1.1.2", "MD2");
        digestNames.put("1.2.840.113549.1.1.5", "SHA1");
        digestNames.put("1.2.840.113549.1.1.14", "SHA224");
        digestNames.put("1.2.840.113549.1.1.11", "SHA256");
        digestNames.put("1.2.840.113549.1.1.12", "SHA384");
        digestNames.put("1.2.840.113549.1.1.13", "SHA512");
        digestNames.put("1.2.840.113549.2.5", "MD5");
        digestNames.put("1.2.840.113549.2.2", "MD2");
        digestNames.put("1.2.840.10040.4.3", "SHA1");
        digestNames.put("2.16.840.1.101.3.4.3.1", "SHA224");
        digestNames.put("2.16.840.1.101.3.4.3.2", "SHA256");
        digestNames.put("2.16.840.1.101.3.4.3.3", "SHA384");
        digestNames.put("2.16.840.1.101.3.4.3.4", "SHA512");
        digestNames.put("1.3.36.3.3.1.3", "RIPEMD128");
        digestNames.put("1.3.36.3.3.1.2", "RIPEMD160");
        digestNames.put("1.3.36.3.3.1.4", "RIPEMD256");
        algorithmNames.put(ID_RSA, "RSA");
        algorithmNames.put(ID_DSA, "DSA");
        algorithmNames.put("1.2.840.113549.1.1.2", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.4", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.5", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.14", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.11", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.12", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.13", "RSA");
        algorithmNames.put("1.2.840.10040.4.3", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.1", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.2", "DSA");
        algorithmNames.put("1.3.36.3.3.1.3", "RSA");
        algorithmNames.put("1.3.36.3.3.1.2", "RSA");
        algorithmNames.put("1.3.36.3.3.1.4", "RSA");
        allowedDigests.put("MD5", "1.2.840.113549.2.5");
        allowedDigests.put("MD2", "1.2.840.113549.2.2");
        allowedDigests.put("SHA1", "1.3.14.3.2.26");
        allowedDigests.put("SHA224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA256", "2.16.840.1.101.3.4.2.1");
        allowedDigests.put("SHA384", "2.16.840.1.101.3.4.2.2");
        allowedDigests.put("SHA512", "2.16.840.1.101.3.4.2.3");
        allowedDigests.put("MD-5", "1.2.840.113549.2.5");
        allowedDigests.put("MD-2", "1.2.840.113549.2.2");
        allowedDigests.put("SHA-1", "1.3.14.3.2.26");
        allowedDigests.put("SHA-224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA-256", "2.16.840.1.101.3.4.2.1");
        allowedDigests.put("SHA-384", "2.16.840.1.101.3.4.2.2");
        allowedDigests.put("SHA-512", "2.16.840.1.101.3.4.2.3");
        allowedDigests.put("RIPEMD128", "1.3.36.3.2.2");
        allowedDigests.put("RIPEMD-128", "1.3.36.3.2.2");
        allowedDigests.put("RIPEMD160", "1.3.36.3.2.1");
        allowedDigests.put("RIPEMD-160", "1.3.36.3.2.1");
        allowedDigests.put("RIPEMD256", "1.3.36.3.2.3");
        allowedDigests.put("RIPEMD-256", "1.3.36.3.2.3");
    }

    public static String getDigest(String oid) {
        String ret = digestNames.get(oid);
        if (ret == null) {
            return oid;
        }
        return ret;
    }

    public static String getAlgorithm(String oid) {
        String ret = algorithmNames.get(oid);
        if (ret == null) {
            return oid;
        }
        return ret;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public Calendar getTimeStampDate() {
        if (this.timeStampToken == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date date = this.timeStampToken.getTimeStampInfo().getGenTime();
        cal.setTime(date);
        return cal;
    }

    public PdfPKCS7(byte[] contentsKey, byte[] certsKey, String provider) {
        try {
            this.provider = provider;
            X509CertParser cr = new X509CertParser();
            cr.engineInit(new ByteArrayInputStream(certsKey));
            this.certs = cr.engineReadAll();
            this.signCerts = this.certs;
            this.signCert = (X509Certificate)this.certs.iterator().next();
            this.crls = new ArrayList<CRL>();
            ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(contentsKey));
            this.digest = ((DEROctetString)in.readObject()).getOctets();
            this.sig = provider == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", provider);
            this.sig.initVerify(this.signCert.getPublicKey());
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public BasicOCSPResp getOcsp() {
        return this.basicResp;
    }

    private void findCRL(ASN1Sequence seq) throws IOException, CertificateException, CRLException {
        try {
            this.crls = new ArrayList<CRL>();
            int k2 = 0;
            while (k2 < seq.size()) {
                ByteArrayInputStream ar = new ByteArrayInputStream(seq.getObjectAt(k2).getDERObject().getDEREncoded());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509CRL crl = (X509CRL)cf.generateCRL(ar);
                this.crls.add(crl);
                ++k2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void findOcsp(ASN1Sequence seq) throws IOException {
        this.basicResp = null;
        boolean ret = false;
        while (!(seq.getObjectAt(0) instanceof DERObjectIdentifier) || !((DERObjectIdentifier)seq.getObjectAt(0)).getId().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic.getId())) {
            ret = true;
            int k2 = 0;
            while (k2 < seq.size()) {
                if (seq.getObjectAt(k2) instanceof ASN1Sequence) {
                    seq = (ASN1Sequence)seq.getObjectAt(0);
                    ret = false;
                    break;
                }
                if (seq.getObjectAt(k2) instanceof ASN1TaggedObject) {
                    ASN1TaggedObject tag = (ASN1TaggedObject)seq.getObjectAt(k2);
                    if (tag.getObject() instanceof ASN1Sequence) {
                        seq = (ASN1Sequence)tag.getObject();
                        ret = false;
                        break;
                    }
                    return;
                }
                ++k2;
            }
            if (!ret) continue;
            return;
        }
        DEROctetString os = (DEROctetString)seq.getObjectAt(1);
        ASN1InputStream inp = new ASN1InputStream(os.getOctets());
        BasicOCSPResponse resp = BasicOCSPResponse.getInstance(inp.readObject());
        this.basicResp = new BasicOCSPResp(resp);
    }

    public PdfPKCS7(byte[] contentsKey, String provider) {
        try {
            DERTaggedObject taggedObject;
            ASN1Set unat;
            AttributeTable attble;
            Attribute ts;
            DERObject pkcs;
            this.provider = provider;
            ASN1InputStream din = new ASN1InputStream(new ByteArrayInputStream(contentsKey));
            try {
                pkcs = din.readObject();
            }
            catch (IOException e2) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("can.t.decode.pkcs7signeddata.object"));
            }
            if (!(pkcs instanceof ASN1Sequence)) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("not.a.valid.pkcs.7.object.not.a.sequence"));
            }
            ASN1Sequence signedData = (ASN1Sequence)pkcs;
            DERObjectIdentifier objId = (DERObjectIdentifier)signedData.getObjectAt(0);
            if (!objId.getId().equals(ID_PKCS7_SIGNED_DATA)) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("not.a.valid.pkcs.7.object.not.signed.data"));
            }
            ASN1Sequence content = (ASN1Sequence)((DERTaggedObject)signedData.getObjectAt(1)).getObject();
            this.version = ((DERInteger)content.getObjectAt(0)).getValue().intValue();
            this.digestalgos = new HashSet<String>();
            Enumeration e3 = ((ASN1Set)content.getObjectAt(1)).getObjects();
            while (e3.hasMoreElements()) {
                ASN1Sequence s2 = (ASN1Sequence)e3.nextElement();
                DERObjectIdentifier o2 = (DERObjectIdentifier)s2.getObjectAt(0);
                this.digestalgos.add(o2.getId());
            }
            X509CertParser cr = new X509CertParser();
            cr.engineInit(new ByteArrayInputStream(contentsKey));
            this.certs = cr.engineReadAll();
            ASN1Sequence rsaData = (ASN1Sequence)content.getObjectAt(2);
            if (rsaData.size() > 1) {
                DEROctetString rsaDataContent = (DEROctetString)((DERTaggedObject)rsaData.getObjectAt(1)).getObject();
                this.RSAdata = rsaDataContent.getOctets();
            }
            int next = 3;
            while (content.getObjectAt(next) instanceof DERTaggedObject) {
                ++next;
            }
            ASN1Set signerInfos = (ASN1Set)content.getObjectAt(next);
            if (signerInfos.size() != 1) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("this.pkcs.7.object.has.multiple.signerinfos.only.one.is.supported.at.this.time"));
            }
            ASN1Sequence signerInfo = (ASN1Sequence)signerInfos.getObjectAt(0);
            this.signerversion = ((DERInteger)signerInfo.getObjectAt(0)).getValue().intValue();
            ASN1Sequence issuerAndSerialNumber = (ASN1Sequence)signerInfo.getObjectAt(1);
            X509Principal issuer = new X509Principal(issuerAndSerialNumber.getObjectAt(0).getDERObject().getEncoded());
            BigInteger serialNumber = ((DERInteger)issuerAndSerialNumber.getObjectAt(1)).getValue();
            for (Certificate element : this.certs) {
                X509Certificate cert = (X509Certificate)element;
                if (!issuer.equals(cert.getIssuerDN()) || !serialNumber.equals(cert.getSerialNumber())) continue;
                this.signCert = cert;
                break;
            }
            if (this.signCert == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("can.t.find.signing.certificate.with.serial.1", String.valueOf(issuer.getName()) + " / " + serialNumber.toString(16)));
            }
            this.signCertificateChain();
            this.digestAlgorithm = ((DERObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(2)).getObjectAt(0)).getId();
            next = 3;
            if (signerInfo.getObjectAt(next) instanceof ASN1TaggedObject) {
                ASN1TaggedObject tagsig = (ASN1TaggedObject)signerInfo.getObjectAt(next);
                ASN1Set sseq = ASN1Set.getInstance(tagsig, false);
                this.sigAttr = sseq.getEncoded("DER");
                int k2 = 0;
                while (k2 < sseq.size()) {
                    ASN1Sequence seq2 = (ASN1Sequence)sseq.getObjectAt(k2);
                    if (((DERObjectIdentifier)seq2.getObjectAt(0)).getId().equals(ID_MESSAGE_DIGEST)) {
                        ASN1Set set = (ASN1Set)seq2.getObjectAt(1);
                        this.digestAttr = ((DEROctetString)set.getObjectAt(0)).getOctets();
                    } else if (((DERObjectIdentifier)seq2.getObjectAt(0)).getId().equals(ID_ADBE_REVOCATION)) {
                        ASN1Set setout = (ASN1Set)seq2.getObjectAt(1);
                        ASN1Sequence seqout = (ASN1Sequence)setout.getObjectAt(0);
                        int j2 = 0;
                        while (j2 < seqout.size()) {
                            ASN1Sequence seqin;
                            ASN1TaggedObject tg = (ASN1TaggedObject)seqout.getObjectAt(j2);
                            if (tg.getTagNo() == 0) {
                                seqin = (ASN1Sequence)tg.getObject();
                                this.findCRL(seqin);
                            }
                            if (tg.getTagNo() == 1) {
                                seqin = (ASN1Sequence)tg.getObject();
                                this.findOcsp(seqin);
                            }
                            ++j2;
                        }
                    }
                    ++k2;
                }
                if (this.digestAttr == null) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("authenticated.attribute.is.missing.the.digest"));
                }
            }
            int n2 = ++next;
            this.digestEncryptionAlgorithm = ((DERObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(n2)).getObjectAt(0)).getId();
            int n3 = ++next;
            this.digest = ((DEROctetString)signerInfo.getObjectAt(n3)).getOctets();
            if (++next < signerInfo.size() && signerInfo.getObjectAt(next) instanceof DERTaggedObject && (ts = (attble = new AttributeTable(unat = ASN1Set.getInstance(taggedObject = (DERTaggedObject)signerInfo.getObjectAt(next), false))).get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null && ts.getAttrValues().size() > 0) {
                ASN1Set attributeValues = ts.getAttrValues();
                ASN1Sequence tokenSequence = ASN1Sequence.getInstance(attributeValues.getObjectAt(0));
                ContentInfo contentInfo = new ContentInfo(tokenSequence);
                this.timeStampToken = new TimeStampToken(contentInfo);
            }
            if (this.RSAdata != null || this.digestAttr != null) {
                this.messageDigest = provider == null || provider.startsWith("SunPKCS11") ? MessageDigest.getInstance(this.getHashAlgorithm()) : MessageDigest.getInstance(this.getHashAlgorithm(), provider);
            }
            this.sig = provider == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), provider);
            this.sig.initVerify(this.signCert.getPublicKey());
        }
        catch (Exception e4) {
            throw new ExceptionConverter(e4);
        }
    }

    public PdfPKCS7(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider, boolean hasRSAdata) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        Object element;
        this.privKey = privKey;
        this.provider = provider;
        this.digestAlgorithm = allowedDigests.get(hashAlgorithm.toUpperCase());
        if (this.digestAlgorithm == null) {
            throw new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.hash.algorithm.1", hashAlgorithm));
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList<Certificate>();
        this.crls = new ArrayList<CRL>();
        this.digestalgos = new HashSet<String>();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        Object[] objectArray = certChain;
        int n2 = certChain.length;
        int n3 = 0;
        while (n3 < n2) {
            element = objectArray[n3];
            this.certs.add((Certificate)element);
            ++n3;
        }
        if (crlList != null) {
            objectArray = crlList;
            n2 = crlList.length;
            n3 = 0;
            while (n3 < n2) {
                element = objectArray[n3];
                this.crls.add((CRL)element);
                ++n3;
            }
        }
        if (privKey != null) {
            this.digestEncryptionAlgorithm = privKey.getAlgorithm();
            if (this.digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.key.algorithm.1", this.digestEncryptionAlgorithm));
            }
        }
        if (hasRSAdata) {
            this.RSAdata = new byte[0];
            this.messageDigest = provider == null || provider.startsWith("SunPKCS11") ? MessageDigest.getInstance(this.getHashAlgorithm()) : MessageDigest.getInstance(this.getHashAlgorithm(), provider);
        }
        if (privKey != null) {
            this.sig = provider == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), provider);
            this.sig.initSign(privKey);
        }
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        if (this.RSAdata != null || this.digestAttr != null) {
            this.messageDigest.update(buf, off, len);
        } else {
            this.sig.update(buf, off, len);
        }
    }

    public boolean verify() throws SignatureException {
        if (this.verified) {
            return this.verifyResult;
        }
        if (this.sigAttr != null) {
            this.sig.update(this.sigAttr);
            if (this.RSAdata != null) {
                byte[] msd = this.messageDigest.digest();
                this.messageDigest.update(msd);
            }
            this.verifyResult = Arrays.equals(this.messageDigest.digest(), this.digestAttr) && this.sig.verify(this.digest);
        } else {
            if (this.RSAdata != null) {
                this.sig.update(this.messageDigest.digest());
            }
            this.verifyResult = this.sig.verify(this.digest);
        }
        this.verified = true;
        return this.verifyResult;
    }

    public boolean verifyTimestampImprint() throws NoSuchAlgorithmException {
        if (this.timeStampToken == null) {
            return false;
        }
        MessageImprint imprint = this.timeStampToken.getTimeStampInfo().toTSTInfo().getMessageImprint();
        byte[] md = MessageDigest.getInstance("SHA-1").digest(this.digest);
        byte[] imphashed = imprint.getHashedMessage();
        boolean res = Arrays.equals(md, imphashed);
        return res;
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Certificate[] getSignCertificateChain() {
        return this.signCerts.toArray(new X509Certificate[this.signCerts.size()]);
    }

    private void signCertificateChain() {
        ArrayList<Certificate> cc = new ArrayList<Certificate>();
        cc.add(this.signCert);
        ArrayList<Certificate> oc = new ArrayList<Certificate>(this.certs);
        int k2 = 0;
        while (k2 < oc.size()) {
            if (this.signCert.equals(oc.get(k2))) {
                oc.remove(k2);
                --k2;
            }
            ++k2;
        }
        boolean found = true;
        block3: while (found) {
            X509Certificate v2 = (X509Certificate)cc.get(cc.size() - 1);
            found = false;
            int k3 = 0;
            while (k3 < oc.size()) {
                try {
                    if (this.provider == null) {
                        v2.verify(((X509Certificate)oc.get(k3)).getPublicKey());
                    } else {
                        v2.verify(((X509Certificate)oc.get(k3)).getPublicKey(), this.provider);
                    }
                    found = true;
                    cc.add(oc.get(k3));
                    oc.remove(k3);
                    continue block3;
                }
                catch (Exception exception) {
                    ++k3;
                }
            }
        }
        this.signCerts = cc;
    }

    public Collection<CRL> getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public String getDigestAlgorithm() {
        String dea = PdfPKCS7.getAlgorithm(this.digestEncryptionAlgorithm);
        if (dea == null) {
            dea = this.digestEncryptionAlgorithm;
        }
        return String.valueOf(this.getHashAlgorithm()) + "with" + dea;
    }

    public String getHashAlgorithm() {
        return PdfPKCS7.getDigest(this.digestAlgorithm);
    }

    public static KeyStore loadCacertsKeyStore() {
        return PdfPKCS7.loadCacertsKeyStore(null);
    }

    public static KeyStore loadCacertsKeyStore(String provider) {
        File file = new File(System.getProperty("java.home"), "lib");
        file = new File(file, "security");
        file = new File(file, "cacerts");
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            KeyStore k2 = provider == null ? KeyStore.getInstance("JKS") : KeyStore.getInstance("JKS", provider);
            k2.load(fin, null);
            KeyStore keyStore = k2;
            return keyStore;
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (cert.hasUnsupportedCriticalExtension()) {
            return "Has unsupported critical extension";
        }
        try {
            cert.checkValidity(calendar.getTime());
        }
        catch (Exception e2) {
            return e2.getMessage();
        }
        if (crls != null) {
            for (CRL crl : crls) {
                if (!crl.isRevoked(cert)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    public static Object[] verifyCertificates(Certificate[] certs, KeyStore keystore, Collection<CRL> crls, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        int k2 = 0;
        while (k2 < certs.length) {
            X509Certificate cert = (X509Certificate)certs[k2];
            String err = PdfPKCS7.verifyCertificate(cert, crls, calendar);
            if (err != null) {
                return new Object[]{cert, err};
            }
            Enumeration<String> aliases2 = keystore.aliases();
            while (aliases2.hasMoreElements()) {
                X509Certificate certStoreX509;
                String alias2 = aliases2.nextElement();
                if (!keystore.isCertificateEntry(alias2) || PdfPKCS7.verifyCertificate(certStoreX509 = (X509Certificate)keystore.getCertificate(alias2), crls, calendar) != null) continue;
                try {
                    cert.verify(certStoreX509.getPublicKey());
                    return null;
                }
                catch (Exception e2) {
                    try {
                        try {
                        }
                        catch (Exception alias2) {
                            // empty catch block
                        }
                    }
                    catch (Exception aliases2) {
                        // empty catch block
                        break;
                    }
                }
            }
            int j2 = 0;
            while (j2 < certs.length) {
                if (j2 != k2) {
                    X509Certificate certNext = (X509Certificate)certs[j2];
                    try {
                        cert.verify(certNext.getPublicKey());
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++j2;
            }
            if (j2 == certs.length) {
                return new Object[]{cert, "Cannot be verified against the KeyStore or the certificate chain"};
            }
            ++k2;
        }
        Object[] objectArray = new Object[2];
        objectArray[1] = "Invalid state. Possible circular certificate chain";
        return objectArray;
    }

    public static boolean verifyOcspCertificates(BasicOCSPResp ocsp, KeyStore keystore, String provider) {
        if (provider == null) {
            provider = "BC";
        }
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            try {
                X509Certificate certStoreX509;
                String alias = aliases.nextElement();
                if (!keystore.isCertificateEntry(alias) || !ocsp.verify((certStoreX509 = (X509Certificate)keystore.getCertificate(alias)).getPublicKey(), provider)) continue;
                return true;
            }
            catch (Exception exception) {
                try {
                }
                catch (Exception exception2) {
                    // empty catch block
                    break;
                }
            }
        }
        return false;
    }

    public static boolean verifyTimestampCertificates(TimeStampToken ts, KeyStore keystore, String provider) {
        if (provider == null) {
            provider = "BC";
        }
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            try {
                String alias = aliases.nextElement();
                if (!keystore.isCertificateEntry(alias)) continue;
                X509Certificate certStoreX509 = (X509Certificate)keystore.getCertificate(alias);
                ts.validate(certStoreX509, provider);
                return true;
            }
            catch (Exception exception) {
                try {
                }
                catch (Exception exception2) {
                    // empty catch block
                    break;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOCSPURL(X509Certificate certificate) throws CertificateParsingException {
        try {
            DERObject obj = PdfPKCS7.getExtensionValue(certificate, X509Extensions.AuthorityInfoAccess.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence AccessDescriptions = (ASN1Sequence)obj;
            int i2 = 0;
            while (true) {
                if (i2 >= AccessDescriptions.size()) {
                    return null;
                }
                ASN1Sequence AccessDescription2 = (ASN1Sequence)AccessDescriptions.getObjectAt(i2);
                if (AccessDescription2.size() == 2 && AccessDescription2.getObjectAt(0) instanceof DERObjectIdentifier && ((DERObjectIdentifier)AccessDescription2.getObjectAt(0)).getId().equals("1.3.6.1.5.5.7.48.1")) {
                    String AccessLocation = PdfPKCS7.getStringFromGeneralName((DERObject)AccessDescription2.getObjectAt(1));
                    if (AccessLocation != null) return AccessLocation;
                    return "";
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isRevocationValid() {
        if (this.basicResp == null) {
            return false;
        }
        if (this.signCerts.size() < 2) {
            return false;
        }
        try {
            X509Certificate[] cs = (X509Certificate[])this.getSignCertificateChain();
            SingleResp sr = this.basicResp.getResponses()[0];
            CertificateID cid = sr.getCertID();
            X509Certificate sigcer = this.getSigningCertificate();
            X509Certificate isscer = cs[1];
            CertificateID tis = new CertificateID("1.3.14.3.2.26", isscer, sigcer.getSerialNumber());
            return tis.equals(cid);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static DERObject getExtensionValue(X509Certificate cert, String oid) throws IOException {
        byte[] bytes = cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream(new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    private static String getStringFromGeneralName(DERObject names) throws IOException {
        DERTaggedObject taggedObject = (DERTaggedObject)names;
        return new String(ASN1OctetString.getInstance(taggedObject, false).getOctets(), "ISO-8859-1");
    }

    private static DERObject getIssuer(byte[] enc) {
        try {
            ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(enc));
            ASN1Sequence seq = (ASN1Sequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private static DERObject getSubject(byte[] enc) {
        try {
            ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(enc));
            ASN1Sequence seq = (ASN1Sequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 5 : 4);
        }
        catch (IOException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public static X509Name getIssuerFields(X509Certificate cert) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.getIssuer(cert.getTBSCertificate()));
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public static X509Name getSubjectFields(X509Certificate cert) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.getSubject(cert.getTBSCertificate()));
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.digest = this.externalDigest != null ? this.externalDigest : this.sig.sign();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream dout = new ASN1OutputStream(bOut);
            dout.writeObject(new DEROctetString(this.digest));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public void setExternalDigest(byte[] digest, byte[] RSAdata, String digestEncryptionAlgorithm) {
        this.externalDigest = digest;
        this.externalRSAdata = RSAdata;
        if (digestEncryptionAlgorithm != null) {
            if (digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new ExceptionConverter(new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.key.algorithm.1", digestEncryptionAlgorithm)));
            }
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, null, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest, Calendar signingTime) {
        return this.getEncodedPKCS7(secondDigest, signingTime, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest, Calendar signingTime, TSAClient tsaClient, byte[] ocsp) {
        try {
            ASN1EncodableVector unauthAttributes;
            byte[] tsImprint;
            byte[] tsToken;
            if (this.externalDigest != null) {
                this.digest = this.externalDigest;
                if (this.RSAdata != null) {
                    this.RSAdata = this.externalRSAdata;
                }
            } else if (this.externalRSAdata != null && this.RSAdata != null) {
                this.RSAdata = this.externalRSAdata;
                this.sig.update(this.RSAdata);
                this.digest = this.sig.sign();
            } else {
                if (this.RSAdata != null) {
                    this.RSAdata = this.messageDigest.digest();
                    this.sig.update(this.RSAdata);
                }
                this.digest = this.sig.sign();
            }
            ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
            for (String element : this.digestalgos) {
                ASN1EncodableVector algos = new ASN1EncodableVector();
                algos.add(new DERObjectIdentifier(element));
                algos.add(DERNull.INSTANCE);
                digestAlgorithms.add(new DERSequence(algos));
            }
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(new DERObjectIdentifier(ID_PKCS7_DATA));
            if (this.RSAdata != null) {
                v2.add(new DERTaggedObject(0, new DEROctetString(this.RSAdata)));
            }
            DERSequence contentinfo = new DERSequence(v2);
            v2 = new ASN1EncodableVector();
            for (Certificate element : this.certs) {
                ASN1InputStream tempstream = new ASN1InputStream(new ByteArrayInputStream(((X509Certificate)element).getEncoded()));
                v2.add(tempstream.readObject());
            }
            DERSet dercertificates = new DERSet(v2);
            ASN1EncodableVector signerinfo = new ASN1EncodableVector();
            signerinfo.add(new DERInteger(this.signerversion));
            v2 = new ASN1EncodableVector();
            v2.add(PdfPKCS7.getIssuer(this.signCert.getTBSCertificate()));
            v2.add(new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.add(new DERSequence(v2));
            v2 = new ASN1EncodableVector();
            v2.add(new DERObjectIdentifier(this.digestAlgorithm));
            v2.add(new DERNull());
            signerinfo.add(new DERSequence(v2));
            if (secondDigest != null && signingTime != null) {
                signerinfo.add(new DERTaggedObject(false, 0, this.getAuthenticatedAttributeSet(secondDigest, signingTime, ocsp)));
            }
            v2 = new ASN1EncodableVector();
            v2.add(new DERObjectIdentifier(this.digestEncryptionAlgorithm));
            v2.add(new DERNull());
            signerinfo.add(new DERSequence(v2));
            signerinfo.add(new DEROctetString(this.digest));
            if (tsaClient != null && (tsToken = tsaClient.getTimeStampToken(this, tsImprint = MessageDigest.getInstance("SHA-1").digest(this.digest))) != null && (unauthAttributes = this.buildUnauthenticatedAttributes(tsToken)) != null) {
                signerinfo.add(new DERTaggedObject(false, 1, new DERSet(unauthAttributes)));
            }
            ASN1EncodableVector body = new ASN1EncodableVector();
            body.add(new DERInteger(this.version));
            body.add(new DERSet(digestAlgorithms));
            body.add(contentinfo);
            body.add(new DERTaggedObject(false, 0, dercertificates));
            body.add(new DERSet(new DERSequence(signerinfo)));
            ASN1EncodableVector whole = new ASN1EncodableVector();
            whole.add(new DERObjectIdentifier(ID_PKCS7_SIGNED_DATA));
            whole.add(new DERTaggedObject(0, new DERSequence(body)));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream dout = new ASN1OutputStream(bOut);
            dout.writeObject(new DERSequence(whole));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private ASN1EncodableVector buildUnauthenticatedAttributes(byte[] timeStampToken) throws IOException {
        if (timeStampToken == null) {
            return null;
        }
        String ID_TIME_STAMP_TOKEN = "1.2.840.113549.1.9.16.2.14";
        ASN1InputStream tempstream = new ASN1InputStream(new ByteArrayInputStream(timeStampToken));
        ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new DERObjectIdentifier(ID_TIME_STAMP_TOKEN));
        ASN1Sequence seq = (ASN1Sequence)tempstream.readObject();
        v2.add(new DERSet(seq));
        unauthAttributes.add(new DERSequence(v2));
        return unauthAttributes;
    }

    public byte[] getAuthenticatedAttributeBytes(byte[] secondDigest, Calendar signingTime, byte[] ocsp) {
        try {
            return this.getAuthenticatedAttributeSet(secondDigest, signingTime, ocsp).getEncoded("DER");
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private DERSet getAuthenticatedAttributeSet(byte[] secondDigest, Calendar signingTime, byte[] ocsp) {
        try {
            ASN1EncodableVector attribute = new ASN1EncodableVector();
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(new DERObjectIdentifier(ID_CONTENT_TYPE));
            v2.add(new DERSet(new DERObjectIdentifier(ID_PKCS7_DATA)));
            attribute.add(new DERSequence(v2));
            v2 = new ASN1EncodableVector();
            v2.add(new DERObjectIdentifier(ID_SIGNING_TIME));
            v2.add(new DERSet(new DERUTCTime(signingTime.getTime())));
            attribute.add(new DERSequence(v2));
            v2 = new ASN1EncodableVector();
            v2.add(new DERObjectIdentifier(ID_MESSAGE_DIGEST));
            v2.add(new DERSet(new DEROctetString(secondDigest)));
            attribute.add(new DERSequence(v2));
            if (ocsp != null || !this.crls.isEmpty()) {
                v2 = new ASN1EncodableVector();
                v2.add(new DERObjectIdentifier(ID_ADBE_REVOCATION));
                ASN1EncodableVector revocationV = new ASN1EncodableVector();
                if (!this.crls.isEmpty()) {
                    ASN1EncodableVector v22 = new ASN1EncodableVector();
                    for (CRL element : this.crls) {
                        ASN1InputStream t2 = new ASN1InputStream(new ByteArrayInputStream(((X509CRL)element).getEncoded()));
                        v22.add(t2.readObject());
                    }
                    revocationV.add(new DERTaggedObject(true, 0, new DERSequence(v22)));
                }
                if (ocsp != null) {
                    DEROctetString doctet = new DEROctetString(ocsp);
                    ASN1EncodableVector vo1 = new ASN1EncodableVector();
                    ASN1EncodableVector v23 = new ASN1EncodableVector();
                    v23.add(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                    v23.add(doctet);
                    DEREnumerated den = new DEREnumerated(0);
                    ASN1EncodableVector v3 = new ASN1EncodableVector();
                    v3.add(den);
                    v3.add(new DERTaggedObject(true, 0, new DERSequence(v23)));
                    vo1.add(new DERSequence(v3));
                    revocationV.add(new DERTaggedObject(true, 1, new DERSequence(vo1)));
                }
                v2.add(new DERSet(new DERSequence(revocationV)));
                attribute.add(new DERSequence(v2));
            }
            return new DERSet(attribute);
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public static class X509Name {
        public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
        public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
        public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
        public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
        public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
        public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
        public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
        public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
        public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
        public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
        public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
        public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
        public static final DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
        public static final DERObjectIdentifier EmailAddress;
        public static final DERObjectIdentifier E;
        public static final DERObjectIdentifier DC;
        public static final DERObjectIdentifier UID;
        public static HashMap<DERObjectIdentifier, String> DefaultSymbols;
        public HashMap<String, ArrayList<String>> values = new HashMap();

        static {
            E = EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
            DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
            UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
            DefaultSymbols = new HashMap();
            DefaultSymbols.put(C, "C");
            DefaultSymbols.put(O, "O");
            DefaultSymbols.put(T, "T");
            DefaultSymbols.put(OU, "OU");
            DefaultSymbols.put(CN, "CN");
            DefaultSymbols.put(L, "L");
            DefaultSymbols.put(ST, "ST");
            DefaultSymbols.put(SN, "SN");
            DefaultSymbols.put(EmailAddress, "E");
            DefaultSymbols.put(DC, "DC");
            DefaultSymbols.put(UID, "UID");
            DefaultSymbols.put(SURNAME, "SURNAME");
            DefaultSymbols.put(GIVENNAME, "GIVENNAME");
            DefaultSymbols.put(INITIALS, "INITIALS");
            DefaultSymbols.put(GENERATION, "GENERATION");
        }

        public X509Name(ASN1Sequence seq) {
            Enumeration e2 = seq.getObjects();
            while (e2.hasMoreElements()) {
                ASN1Set set = (ASN1Set)e2.nextElement();
                int i2 = 0;
                while (i2 < set.size()) {
                    ASN1Sequence s2 = (ASN1Sequence)set.getObjectAt(i2);
                    String id = DefaultSymbols.get(s2.getObjectAt(0));
                    if (id != null) {
                        ArrayList<String> vs = this.values.get(id);
                        if (vs == null) {
                            vs = new ArrayList();
                            this.values.put(id, vs);
                        }
                        vs.add(((DERString)((Object)s2.getObjectAt(1))).getString());
                    }
                    ++i2;
                }
            }
        }

        public X509Name(String dirName) {
            X509NameTokenizer nTok = new X509NameTokenizer(dirName);
            while (nTok.hasMoreTokens()) {
                String token = nTok.nextToken();
                int index = token.indexOf(61);
                if (index == -1) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("badly.formated.directory.string"));
                }
                String id = token.substring(0, index).toUpperCase();
                String value = token.substring(index + 1);
                ArrayList<String> vs = this.values.get(id);
                if (vs == null) {
                    vs = new ArrayList();
                    this.values.put(id, vs);
                }
                vs.add(value);
            }
        }

        public String getField(String name) {
            ArrayList<String> vs = this.values.get(name);
            return vs == null ? null : vs.get(0);
        }

        public ArrayList<String> getFieldArray(String name) {
            ArrayList<String> vs = this.values.get(name);
            return vs == null ? null : vs;
        }

        public HashMap<String, ArrayList<String>> getFields() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }
    }

    public static class X509NameTokenizer {
        private String oid;
        private int index;
        private StringBuffer buf = new StringBuffer();

        public X509NameTokenizer(String oid) {
            this.oid = oid;
            this.index = -1;
        }

        public boolean hasMoreTokens() {
            return this.index != this.oid.length();
        }

        public String nextToken() {
            if (this.index == this.oid.length()) {
                return null;
            }
            int end = this.index + 1;
            boolean quoted = false;
            boolean escaped = false;
            this.buf.setLength(0);
            while (end != this.oid.length()) {
                char c2 = this.oid.charAt(end);
                if (c2 == '\"') {
                    if (!escaped) {
                        quoted = !quoted;
                    } else {
                        this.buf.append(c2);
                    }
                    escaped = false;
                } else if (escaped || quoted) {
                    this.buf.append(c2);
                    escaped = false;
                } else if (c2 == '\\') {
                    escaped = true;
                } else {
                    if (c2 == ',') break;
                    this.buf.append(c2);
                }
                ++end;
            }
            this.index = end;
            return this.buf.toString().trim();
        }
    }
}

