/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.factories.RomanAlphabetFactory;
import com.lowagie.text.factories.RomanNumberFactory;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfNumberTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PdfPageLabels {
    public static final int DECIMAL_ARABIC_NUMERALS = 0;
    public static final int UPPERCASE_ROMAN_NUMERALS = 1;
    public static final int LOWERCASE_ROMAN_NUMERALS = 2;
    public static final int UPPERCASE_LETTERS = 3;
    public static final int LOWERCASE_LETTERS = 4;
    public static final int EMPTY = 5;
    static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    private HashMap map = new HashMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    public void addPageLabel(int n2, int n3, String string, int n4) {
        if (n2 < 1 || n4 < 1) {
            throw new IllegalArgumentException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (n3 >= 0 && n3 < numberingStyle.length) {
            pdfDictionary.put(PdfName.S, numberingStyle[n3]);
        }
        if (string != null) {
            pdfDictionary.put(PdfName.P, new PdfString(string, "UnicodeBig"));
        }
        if (n4 != 1) {
            pdfDictionary.put(PdfName.ST, new PdfNumber(n4));
        }
        this.map.put(new Integer(n2 - 1), pdfDictionary);
    }

    public void addPageLabel(int n2, int n3, String string) {
        this.addPageLabel(n2, n3, string, 1);
    }

    public void addPageLabel(int n2, int n3) {
        this.addPageLabel(n2, n3, null, 1);
    }

    public void addPageLabel(PdfPageLabelFormat pdfPageLabelFormat) {
        this.addPageLabel(pdfPageLabelFormat.physicalPage, pdfPageLabelFormat.numberStyle, pdfPageLabelFormat.prefix, pdfPageLabelFormat.logicalPage);
    }

    public void removePageLabel(int n2) {
        if (n2 <= 1) {
            return;
        }
        this.map.remove(new Integer(n2 - 1));
    }

    PdfDictionary getDictionary(PdfWriter pdfWriter) {
        try {
            return PdfNumberTree.writeTree(this.map, pdfWriter);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static String[] getPageLabels(PdfReader pdfReader) {
        int n2 = pdfReader.getNumberOfPages();
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.PAGELABELS));
        if (pdfDictionary2 == null) {
            return null;
        }
        String[] stringArray = new String[n2];
        HashMap hashMap = PdfNumberTree.readTree(pdfDictionary2);
        int n3 = 1;
        String string = "";
        int n4 = 68;
        for (int i2 = 0; i2 < n2; ++i2) {
            Integer n5 = new Integer(i2);
            if (hashMap.containsKey(n5)) {
                PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)hashMap.get(n5));
                n3 = pdfDictionary3.contains(PdfName.ST) ? ((PdfNumber)pdfDictionary3.get(PdfName.ST)).intValue() : 1;
                if (pdfDictionary3.contains(PdfName.P)) {
                    string = ((PdfString)pdfDictionary3.get(PdfName.P)).toUnicodeString();
                }
                if (pdfDictionary3.contains(PdfName.S)) {
                    n4 = ((PdfName)pdfDictionary3.get(PdfName.S)).toString().charAt(1);
                }
            }
            switch (n4) {
                default: {
                    stringArray[i2] = string + n3;
                    break;
                }
                case 82: {
                    stringArray[i2] = string + RomanNumberFactory.getUpperCaseString(n3);
                    break;
                }
                case 114: {
                    stringArray[i2] = string + RomanNumberFactory.getLowerCaseString(n3);
                    break;
                }
                case 65: {
                    stringArray[i2] = string + RomanAlphabetFactory.getUpperCaseString(n3);
                    break;
                }
                case 97: {
                    stringArray[i2] = string + RomanAlphabetFactory.getLowerCaseString(n3);
                }
            }
            ++n3;
        }
        return stringArray;
    }

    public static PdfPageLabelFormat[] getPageLabelFormats(PdfReader pdfReader) {
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.PAGELABELS));
        if (pdfDictionary2 == null) {
            return null;
        }
        HashMap hashMap = PdfNumberTree.readTree(pdfDictionary2);
        Object[] objectArray = new Integer[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        PdfPageLabelFormat[] pdfPageLabelFormatArray = new PdfPageLabelFormat[hashMap.size()];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2;
            Object object = objectArray[i2];
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)hashMap.get(object));
            int n3 = pdfDictionary3.contains(PdfName.ST) ? ((PdfNumber)pdfDictionary3.get(PdfName.ST)).intValue() : 1;
            String string = pdfDictionary3.contains(PdfName.P) ? ((PdfString)pdfDictionary3.get(PdfName.P)).toUnicodeString() : "";
            if (pdfDictionary3.contains(PdfName.S)) {
                char c2 = ((PdfName)pdfDictionary3.get(PdfName.S)).toString().charAt(1);
                switch (c2) {
                    case 'R': {
                        n2 = 1;
                        break;
                    }
                    case 'r': {
                        n2 = 2;
                        break;
                    }
                    case 'A': {
                        n2 = 3;
                        break;
                    }
                    case 'a': {
                        n2 = 4;
                        break;
                    }
                    default: {
                        n2 = 0;
                        break;
                    }
                }
            } else {
                n2 = 5;
            }
            pdfPageLabelFormatArray[i2] = new PdfPageLabelFormat((Integer)object + 1, n2, string, n3);
        }
        return pdfPageLabelFormatArray;
    }

    public static class PdfPageLabelFormat {
        public int physicalPage;
        public int numberStyle;
        public String prefix;
        public int logicalPage;

        public PdfPageLabelFormat(int n2, int n3, String string, int n4) {
            this.physicalPage = n2;
            this.numberStyle = n3;
            this.prefix = string;
            this.logicalPage = n4;
        }
    }
}

