/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class PdfReaderInstance {
    static final PdfLiteral IDENTITYMATRIX = new PdfLiteral("[1 0 0 1 0 0]");
    static final PdfNumber ONE = new PdfNumber(1);
    int[] myXref;
    PdfReader reader;
    RandomAccessFileOrArray file;
    HashMap importedPages = new HashMap();
    PdfWriter writer;
    HashMap visited = new HashMap();
    ArrayList nextRound = new ArrayList();

    PdfReaderInstance(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.reader = pdfReader;
        this.writer = pdfWriter;
        this.file = pdfReader.getSafeFile();
        this.myXref = new int[pdfReader.getXrefSize()];
    }

    PdfReader getReader() {
        return this.reader;
    }

    PdfImportedPage getImportedPage(int n2) {
        if (!this.reader.isOpenedWithFullPermissions()) {
            throw new IllegalArgumentException("PdfReader not opened with owner password");
        }
        if (n2 < 1 || n2 > this.reader.getNumberOfPages()) {
            throw new IllegalArgumentException("Invalid page number: " + n2);
        }
        Integer n3 = new Integer(n2);
        PdfImportedPage pdfImportedPage = (PdfImportedPage)this.importedPages.get(n3);
        if (pdfImportedPage == null) {
            pdfImportedPage = new PdfImportedPage(this, this.writer, n2);
            this.importedPages.put(n3, pdfImportedPage);
        }
        return pdfImportedPage;
    }

    int getNewObjectNumber(int n2, int n3) {
        if (this.myXref[n2] == 0) {
            this.myXref[n2] = this.writer.getIndirectReferenceNumber();
            this.nextRound.add(new Integer(n2));
        }
        return this.myXref[n2];
    }

    RandomAccessFileOrArray getReaderFile() {
        return this.file;
    }

    PdfObject getResources(int n2) {
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(this.reader.getPageNRelease(n2).get(PdfName.RESOURCES));
        return pdfObject;
    }

    PdfStream getFormXObject(int n2, int n3) throws IOException {
        PRStream pRStream;
        PdfDictionary pdfDictionary = this.reader.getPageNRelease(n2);
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CONTENTS));
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        byte[] byArray = null;
        if (pdfObject != null) {
            if (pdfObject.isStream()) {
                pdfDictionary2.putAll((PRStream)pdfObject);
            } else {
                byArray = this.reader.getPageContent(n2, this.file);
            }
        } else {
            byArray = new byte[]{};
        }
        pdfDictionary2.put(PdfName.RESOURCES, PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.RESOURCES)));
        pdfDictionary2.put(PdfName.TYPE, PdfName.XOBJECT);
        pdfDictionary2.put(PdfName.SUBTYPE, PdfName.FORM);
        PdfImportedPage pdfImportedPage = (PdfImportedPage)this.importedPages.get(new Integer(n2));
        pdfDictionary2.put(PdfName.BBOX, new PdfRectangle(pdfImportedPage.getBoundingBox()));
        PdfArray pdfArray = pdfImportedPage.getMatrix();
        if (pdfArray == null) {
            pdfDictionary2.put(PdfName.MATRIX, IDENTITYMATRIX);
        } else {
            pdfDictionary2.put(PdfName.MATRIX, pdfArray);
        }
        pdfDictionary2.put(PdfName.FORMTYPE, ONE);
        if (byArray == null) {
            pRStream = new PRStream((PRStream)pdfObject, pdfDictionary2);
        } else {
            pRStream = new PRStream(this.reader, byArray, n3);
            pRStream.putAll(pdfDictionary2);
        }
        return pRStream;
    }

    void writeAllVisited() throws IOException {
        while (!this.nextRound.isEmpty()) {
            ArrayList arrayList = this.nextRound;
            this.nextRound = new ArrayList();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Integer n2 = (Integer)arrayList.get(i2);
                if (this.visited.containsKey(n2)) continue;
                this.visited.put(n2, null);
                int n3 = n2;
                this.writer.addToBody(this.reader.getPdfObjectRelease(n3), this.myXref[n3]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeAllPages() throws IOException {
        try {
            this.file.reOpen();
            Iterator iterator = this.importedPages.values().iterator();
            while (iterator.hasNext()) {
                PdfImportedPage pdfImportedPage = (PdfImportedPage)iterator.next();
                this.writer.addToBody((PdfObject)pdfImportedPage.getFormXObject(this.writer.getCompressionLevel()), pdfImportedPage.getIndirectReference());
            }
            this.writeAllVisited();
        }
        finally {
            try {
                this.reader.close();
                this.file.close();
            }
            catch (Exception exception) {}
        }
    }
}

