/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.Type3Glyph;
import java.io.IOException;
import java.util.HashMap;

public class Type3Font
extends BaseFont {
    private boolean[] usedSlot;
    private IntHashtable widths3 = new IntHashtable();
    private HashMap char2glyph = new HashMap();
    private PdfWriter writer;
    private float llx = Float.NaN;
    private float lly;
    private float urx;
    private float ury;
    private PageResources pageResources = new PageResources();
    private boolean colorized;

    public Type3Font(PdfWriter pdfWriter, char[] cArray, boolean bl) {
        this(pdfWriter, bl);
    }

    public Type3Font(PdfWriter pdfWriter, boolean bl) {
        this.writer = pdfWriter;
        this.colorized = bl;
        this.fontType = 5;
        this.usedSlot = new boolean[256];
    }

    public PdfContentByte defineGlyph(char c2, float f2, float f3, float f4, float f5, float f6) {
        if (c2 == '\u0000' || c2 > '\u00ff') {
            throw new IllegalArgumentException("The char " + c2 + " doesn't belong in this Type3 font");
        }
        this.usedSlot[c2] = true;
        Integer n2 = new Integer(c2);
        Type3Glyph type3Glyph = (Type3Glyph)this.char2glyph.get(n2);
        if (type3Glyph != null) {
            return type3Glyph;
        }
        this.widths3.put(c2, (int)f2);
        if (!this.colorized) {
            if (Float.isNaN(this.llx)) {
                this.llx = f3;
                this.lly = f4;
                this.urx = f5;
                this.ury = f6;
            } else {
                this.llx = Math.min(this.llx, f3);
                this.lly = Math.min(this.lly, f4);
                this.urx = Math.max(this.urx, f5);
                this.ury = Math.max(this.ury, f6);
            }
        }
        type3Glyph = new Type3Glyph(this.writer, this.pageResources, f2, f3, f4, f5, f6, this.colorized);
        this.char2glyph.put(n2, type3Glyph);
        return type3Glyph;
    }

    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    public float getFontDescriptor(int n2, float f2) {
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", ""}};
    }

    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", ""}};
    }

    public int getKerning(int n2, int n3) {
        return 0;
    }

    public String getPostscriptFontName() {
        return "";
    }

    protected int[] getRawCharBBox(int n2, String string) {
        return null;
    }

    int getRawWidth(int n2, String string) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    public boolean setKerning(int n2, int n3, int n4) {
        return false;
    }

    public void setPostscriptFontName(String string) {
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        int n2;
        int n3;
        if (this.writer != pdfWriter) {
            throw new IllegalArgumentException("Type3 font used with the wrong PdfWriter");
        }
        for (n3 = 0; n3 < this.usedSlot.length && !this.usedSlot[n3]; ++n3) {
        }
        if (n3 == this.usedSlot.length) {
            throw new DocumentException("No glyphs defined for Type3 font");
        }
        for (n2 = this.usedSlot.length - 1; n2 >= n3 && !this.usedSlot[n2]; --n2) {
        }
        int[] nArray = new int[n2 - n3 + 1];
        int[] nArray2 = new int[n2 - n3 + 1];
        int n4 = 0;
        int n5 = 0;
        int n6 = n3;
        while (n6 <= n2) {
            if (this.usedSlot[n6]) {
                nArray2[n4++] = n6;
                nArray[n5] = this.widths3.get(n6);
            }
            ++n6;
            ++n5;
        }
        PdfArray pdfArray = new PdfArray();
        PdfDictionary pdfDictionary = new PdfDictionary();
        int n7 = -1;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n8 = nArray2[i2];
            if (n8 > n7) {
                n7 = n8;
                pdfArray.add(new PdfNumber(n7));
            }
            ++n7;
            int n9 = nArray2[i2];
            String string = GlyphList.unicodeToName(n9);
            if (string == null) {
                string = "a" + n9;
            }
            PdfName pdfName = new PdfName(string);
            pdfArray.add(pdfName);
            Type3Glyph type3Glyph = (Type3Glyph)this.char2glyph.get(new Integer(n9));
            PdfStream pdfStream = new PdfStream(type3Glyph.toPdf(null));
            pdfStream.flateCompress(this.compressionLevel);
            PdfIndirectReference pdfIndirectReference2 = pdfWriter.addToBody(pdfStream).getIndirectReference();
            pdfDictionary.put(pdfName, pdfIndirectReference2);
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.FONT);
        pdfDictionary2.put(PdfName.SUBTYPE, PdfName.TYPE3);
        if (this.colorized) {
            pdfDictionary2.put(PdfName.FONTBBOX, new PdfRectangle(0.0f, 0.0f, 0.0f, 0.0f));
        } else {
            pdfDictionary2.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        }
        pdfDictionary2.put(PdfName.FONTMATRIX, new PdfArray(new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f}));
        pdfDictionary2.put(PdfName.CHARPROCS, pdfWriter.addToBody(pdfDictionary).getIndirectReference());
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        pdfDictionary3.put(PdfName.DIFFERENCES, pdfArray);
        pdfDictionary2.put(PdfName.ENCODING, pdfWriter.addToBody(pdfDictionary3).getIndirectReference());
        pdfDictionary2.put(PdfName.FIRSTCHAR, new PdfNumber(n3));
        pdfDictionary2.put(PdfName.LASTCHAR, new PdfNumber(n2));
        pdfDictionary2.put(PdfName.WIDTHS, pdfWriter.addToBody(new PdfArray(nArray)).getIndirectReference());
        if (this.pageResources.hasResources()) {
            pdfDictionary2.put(PdfName.RESOURCES, pdfWriter.addToBody(this.pageResources.getResources()).getIndirectReference());
        }
        pdfWriter.addToBody((PdfObject)pdfDictionary2, pdfIndirectReference);
    }

    public PdfStream getFullFontStream() {
        return null;
    }

    byte[] convertToBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (!this.charExists(c2)) continue;
            byArray[n2++] = (byte)c2;
        }
        if (byArray.length == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    byte[] convertToBytes(int n2) {
        if (this.charExists(n2)) {
            return new byte[]{(byte)n2};
        }
        return new byte[0];
    }

    public int getWidth(int n2) {
        if (!this.widths3.containsKey(n2)) {
            throw new IllegalArgumentException("The char " + n2 + " is not defined in a Type3 font");
        }
        return this.widths3.get(n2);
    }

    public int getWidth(String string) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            n2 += this.getWidth(cArray[i2]);
        }
        return n2;
    }

    public int[] getCharBBox(int n2) {
        return null;
    }

    public boolean charExists(int n2) {
        if (n2 > 0 && n2 < 256) {
            return this.usedSlot[n2];
        }
        return false;
    }

    public boolean setCharAdvance(int n2, int n3) {
        return false;
    }
}

