/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest digest;
    private boolean isOn = true;

    public DigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream);
        this.digest = messageDigest;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        if (this.isOn && n2 != -1) {
            this.digest.update((byte)n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (this.isOn && n4 != -1) {
            this.digest.update(byArray, n2, n4);
        }
        return n4;
    }

    public void on(boolean bl) {
        this.isOn = bl;
    }

    public String toString() {
        return super.toString() + ", " + this.digest.toString() + (this.isOn ? ", is on" : ", is off");
    }
}

