/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Random;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.fortress.Services;
import org.apache.harmony.security.internal.nls.Messages;

public class SecureRandom
extends Random {
    private static final long serialVersionUID = 4940670005562187L;
    private static final transient String SERVICE = "SecureRandom";
    private static final String DEFAULT_ALGORITHM = "IBMSecureRandom";
    private static transient Engine engine = new Engine("SecureRandom");
    private Provider provider;
    private SecureRandomSpi secureRandomSpi;
    private String algorithm;
    private byte[] state;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;
    private static transient SecureRandom internalSecureRandom;

    public SecureRandom() {
        super(0L);
        Provider.Service service = this.findService();
        if (service == null) {
            this.provider = null;
            this.secureRandomSpi = null;
            this.algorithm = "unknown";
        } else {
            try {
                this.provider = service.getProvider();
                this.secureRandomSpi = (SecureRandomSpi)service.newInstance(null);
                this.algorithm = service.getAlgorithm();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    private Provider.Service findService() {
        for (Provider provider : Services.getProvidersList()) {
            Provider.Service service = provider.getService(SERVICE, DEFAULT_ALGORITHM);
            if (service != null) {
                return service;
            }
            service = provider.getService(SERVICE);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, "unknown");
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String string) {
        super(0L);
        this.provider = provider;
        this.algorithm = string;
        this.secureRandomSpi = secureRandomSpi;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, null);
        return new SecureRandom((SecureRandomSpi)serviceResult.spi, serviceResult.provider, string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(Messages.getString("security.03", string2));
        }
        return SecureRandom.getInstance(string, provider);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
        return new SecureRandom((SecureRandomSpi)serviceResult.spi, provider, string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public synchronized void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
    }

    @Override
    public void setSeed(long l2) {
        if (l2 == 0L) {
            return;
        }
        byte[] byArray = new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)};
        this.setSeed(byArray);
    }

    @Override
    public synchronized void nextBytes(byte[] byArray) {
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    @Override
    protected final int next(int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 32) {
            n2 = 32;
        }
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        this.nextBytes(byArray);
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = byArray[i2] & 0xFF | n4 << 8;
        }
        return n4 >>>= n3 * 8 - n2;
    }

    public static byte[] getSeed(int n2) {
        if (internalSecureRandom == null) {
            internalSecureRandom = new SecureRandom();
        }
        return internalSecureRandom.generateSeed(n2);
    }

    public byte[] generateSeed(int n2) {
        return this.secureRandomSpi.engineGenerateSeed(n2);
    }
}

