/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import org.apache.harmony.security.Util;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.fortress.Services;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class Signature
extends SignatureSpi {
    private static final String SERVICE = "Signature";
    private static Engine engine = new Engine("Signature");
    private Provider provider;
    private String algorithm;
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;

    protected Signature(String string) {
        this.algorithm = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        string = Signature.getAlgorithm(string);
        Engine.ServiceResult serviceResult = engine.getInstance(string, null);
        return new SignatureImpl((SignatureSpi)serviceResult.spi, serviceResult.provider, string, serviceResult.service);
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(Messages.getString("security.03", string2));
        }
        return Signature.getSignatureInstance(string, provider);
    }

    public static Signature getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        return Signature.getSignatureInstance(string, provider);
    }

    private static Signature getSignatureInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        string = Signature.getAlgorithm(string);
        Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
        return new SignatureImpl((SignatureSpi)serviceResult.spi, serviceResult.provider, string, serviceResult.service);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
        this.state = 3;
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        if (certificate instanceof X509Certificate) {
            Set<String> set = ((X509Certificate)certificate).getCriticalExtensionOIDs();
            boolean bl = false;
            if (set != null && !set.isEmpty()) {
                Object object = set.iterator();
                while (object.hasNext()) {
                    if (!"2.5.29.15".equals(object.next())) continue;
                    bl = true;
                    break;
                }
                if (bl && (object = (Object)((X509Certificate)certificate).getKeyUsage()) != null && object[0] == false) {
                    throw new InvalidKeyException(Messages.getString("security.26"));
                }
            }
        }
        this.engineInitVerify(certificate.getPublicKey());
        this.state = 3;
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        if (null == privateKey) {
            throw new InvalidKeyException(Messages.getString("security.1A9"));
        }
        this.engineInitSign(privateKey);
        this.state = 2;
    }

    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (null == privateKey) {
            throw new InvalidKeyException(Messages.getString("security.1A9"));
        }
        this.engineInitSign(privateKey, secureRandom);
        this.state = 2;
    }

    public final byte[] sign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        return this.engineSign();
    }

    public final int sign(byte[] byArray, int n2, int n3) throws SignatureException {
        if (byArray == null || n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException(Messages.getString("security.05"));
        }
        if (this.state != 2) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        return this.engineSign(byArray, n2, n3);
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        return this.engineVerify(byArray);
    }

    public final boolean verify(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        if (byArray == null || n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException(Messages.getString("security.05"));
        }
        return this.engineVerify(byArray, n2, n3);
    }

    public final void update(byte by) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        this.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        if (byArray == null || n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException(Messages.getString("security.05"));
        }
        this.engineUpdate(byArray, n2, n3);
    }

    public final void update(ByteBuffer byteBuffer) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException(Messages.getString("security.27"));
        }
        this.engineUpdate(byteBuffer);
    }

    public String toString() {
        return "SIGNATURE " + this.algorithm + " state: " + this.stateToString(this.state);
    }

    private String stateToString(int n2) {
        switch (n2) {
            case 0: {
                return "UNINITIALIZED";
            }
            case 2: {
                return "SIGN";
            }
            case 3: {
                return "VERIFY";
            }
        }
        return "";
    }

    @Deprecated
    public final void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public final void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(algorithmParameterSpec);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    @Deprecated
    public final Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private static String getAlgorithm(String string) {
        if ("1.3.14.3.2.26with1.2.840.10040.4.1".equals(string)) {
            return "SHA1withDSA";
        }
        return string;
    }

    private static class SignatureImpl
    extends Signature {
        private SignatureSpi spiImpl;
        private Provider.Service service;

        public SignatureImpl(SignatureSpi signatureSpi, Provider provider, String string, Provider.Service service) {
            super(string);
            ((Signature)this).provider = provider;
            this.spiImpl = signatureSpi;
            this.service = service;
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            return this.spiImpl.engineSign();
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            this.spiImpl.engineUpdate(by);
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            return this.spiImpl.engineVerify(byArray);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
            this.spiImpl.engineUpdate(byArray, n2, n3);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (!this.service.supportsParameter(privateKey)) {
                int n2 = 1;
                Provider.Service service = null;
                Signature signature = null;
                while ((service = Services.getService("Signature." + Util.toUpperCase(((Signature)this).algorithm) + "." + n2)) != null) {
                    try {
                        signature = SignatureImpl.getInstance(((Signature)this).algorithm + "." + n2);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        break;
                    }
                    if (service.supportsParameter(privateKey)) {
                        signature.engineInitSign(privateKey);
                        this.service = service;
                        this.spiImpl = signature;
                        return;
                    }
                    ++n2;
                }
                throw new InvalidKeyException(Messages.getString("security.1AA", privateKey.getClass().getName()));
            }
            this.spiImpl.engineInitSign(privateKey);
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (!this.service.supportsParameter(publicKey)) {
                int n2 = 1;
                while ((this.service = Services.getService("Signature." + Util.toUpperCase(((Signature)this).algorithm) + "." + n2)) != null) {
                    try {
                        this.spiImpl = SignatureImpl.getInstance(((Signature)this).algorithm + "." + n2);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(((Signature)this).algorithm + "." + n2);
                    }
                    if (this.service.supportsParameter(publicKey)) {
                        this.spiImpl.engineInitVerify(publicKey);
                        return;
                    }
                    ++n2;
                }
                throw new InvalidKeyException(((Signature)this).algorithm + "." + n2);
            }
            this.spiImpl.engineInitVerify(publicKey);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.spiImpl.engineGetParameters();
        }

        @Override
        protected Object engineGetParameter(String string) throws InvalidParameterException {
            return this.spiImpl.engineGetParameter(string);
        }

        @Override
        protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
            this.spiImpl.engineSetParameter(string, object);
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.spiImpl.engineSetParameter(algorithmParameterSpec);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            if (this.spiImpl instanceof Cloneable) {
                SignatureSpi signatureSpi = (SignatureSpi)this.spiImpl.clone();
                return new SignatureImpl(signatureSpi, this.getProvider(), this.getAlgorithm(), this.service);
            }
            throw new CloneNotSupportedException();
        }
    }
}

