/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import org.apache.harmony.security.internal.nls.Messages;

public class PSSParameterSpec
implements AlgorithmParameterSpec {
    public static final PSSParameterSpec DEFAULT = new PSSParameterSpec(20);
    private final String mdName;
    private final String mgfName;
    private final AlgorithmParameterSpec mgfSpec;
    private final int trailerField;
    private final int saltLen;

    public PSSParameterSpec(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(Messages.getString("security.7F"));
        }
        this.saltLen = n2;
        this.mdName = "SHA-1";
        this.mgfName = "MGF1";
        this.mgfSpec = MGF1ParameterSpec.SHA1;
        this.trailerField = 1;
    }

    public PSSParameterSpec(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.80"));
        }
        if (string2 == null) {
            throw new NullPointerException(Messages.getString("security.81"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(Messages.getString("security.7F"));
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(Messages.getString("security.82"));
        }
        this.mdName = string;
        this.mgfName = string2;
        this.mgfSpec = algorithmParameterSpec;
        this.saltLen = n2;
        this.trailerField = n3;
    }

    public int getSaltLength() {
        return this.saltLen;
    }

    public String getDigestAlgorithm() {
        return this.mdName;
    }

    public String getMGFAlgorithm() {
        return this.mgfName;
    }

    public AlgorithmParameterSpec getMGFParameters() {
        return this.mgfSpec;
    }

    public int getTrailerField() {
        return this.trailerField;
    }
}

