/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartRendererFactory;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.renderers.JRSimpleImageMapRenderer;
import org.jfree.chart.JFreeChart;

public class ImageChartRendererFactory
implements ChartRendererFactory {
    public JRRenderable getRenderer(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Rectangle2D rectangle) {
        int dpi = JRProperties.getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
        double scale = (double)dpi / 72.0;
        BufferedImage bi = new BufferedImage((int)(scale * (double)((int)rectangle.getWidth())), (int)(scale * rectangle.getHeight()), 2);
        Graphics2D grx = bi.createGraphics();
        grx.scale(scale, scale);
        List<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
            areaHyperlinks = ChartUtil.getImageAreaHyperlinks(chart, chartHyperlinkProvider, (Graphics2D)bi.getGraphics(), rectangle);
        } else {
            chart.draw(grx, rectangle);
        }
        try {
            return new JRSimpleImageMapRenderer(JRImageLoader.loadImageDataFromAWTImage(bi, (byte)3), areaHyperlinks);
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }
}

