/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptCompileData;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptEvaluator
extends JREvaluator {
    private final JavaScriptCompileData compileData;
    private Context context;
    private ScriptableObject scope;
    private Map<String, Class<?>> loadedTypes = new HashMap();
    private Map<String, Script> compiledExpressions = new HashMap<String, Script>();

    protected static JavaScriptCompileData.Expression createJSExpression(JRExpression expression) {
        StringBuffer defaultExpr = new StringBuffer();
        StringBuffer oldExpr = new StringBuffer();
        StringBuffer estimatedExpr = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        if (chunks == null) {
            defaultExpr.append("null");
            oldExpr.append("null");
            estimatedExpr.append("null");
        } else {
            block6: for (int i2 = 0; i2 < chunks.length; ++i2) {
                JRExpressionChunk chunk = chunks[i2];
                switch (chunk.getType()) {
                    case 1: {
                        defaultExpr.append(chunk.getText());
                        oldExpr.append(chunk.getText());
                        estimatedExpr.append(chunk.getText());
                        continue block6;
                    }
                    case 2: {
                        String paramName = JavaScriptEvaluator.getParameterVar(chunk.getText());
                        defaultExpr.append(paramName);
                        defaultExpr.append(".getValue()");
                        oldExpr.append(paramName);
                        oldExpr.append(".getValue()");
                        estimatedExpr.append(paramName);
                        estimatedExpr.append(".getValue()");
                        continue block6;
                    }
                    case 4: {
                        String varName = JavaScriptEvaluator.getVariableVar(chunk.getText());
                        defaultExpr.append(varName);
                        defaultExpr.append(".getValue()");
                        oldExpr.append(varName);
                        oldExpr.append(".getOldValue()");
                        estimatedExpr.append(varName);
                        estimatedExpr.append(".getEstimatedValue()");
                        continue block6;
                    }
                    case 3: {
                        String fieldName = JavaScriptEvaluator.getFieldVar(chunk.getText());
                        defaultExpr.append(fieldName);
                        defaultExpr.append(".getValue()");
                        oldExpr.append(fieldName);
                        oldExpr.append(".getOldValue()");
                        estimatedExpr.append(fieldName);
                        estimatedExpr.append(".getValue()");
                    }
                }
            }
        }
        return new JavaScriptCompileData.Expression(defaultExpr.toString(), estimatedExpr.toString(), oldExpr.toString());
    }

    protected static String getParameterVar(String name) {
        return "param_" + JRStringUtil.getJavaIdentifier(name);
    }

    protected static String getVariableVar(String name) {
        return "var_" + JRStringUtil.getJavaIdentifier(name);
    }

    protected static String getFieldVar(String name) {
        return "field_" + JRStringUtil.getJavaIdentifier(name);
    }

    public JavaScriptEvaluator(JavaScriptCompileData compileData) {
        this.compileData = compileData;
    }

    @Override
    protected void customizedInit(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) throws JRException {
        String name;
        this.context = ContextFactory.getGlobal().enterContext();
        this.context.getWrapFactory().setJavaPrimitiveWrap(false);
        this.scope = this.context.initStandardObjects();
        for (Map.Entry<String, JRFillParameter> entry : parametersMap.entrySet()) {
            name = entry.getKey();
            JRFillParameter param = entry.getValue();
            JSParameter jsParam = new JSParameter(param, this.scope);
            this.scope.put(JavaScriptEvaluator.getParameterVar(name), (Scriptable)this.scope, (Object)jsParam);
        }
        for (Map.Entry<String, JRCloneable> entry : variablesMap.entrySet()) {
            name = entry.getKey();
            JRFillVariable var = (JRFillVariable)entry.getValue();
            JSVariable jsVar = new JSVariable(var, this.scope);
            this.scope.put(JavaScriptEvaluator.getVariableVar(name), (Scriptable)this.scope, (Object)jsVar);
        }
        if (fieldsMap != null) {
            for (Map.Entry<String, JRCloneable> entry : fieldsMap.entrySet()) {
                name = entry.getKey();
                JRFillField field = (JRFillField)entry.getValue();
                JSField jsField = new JSField(field, this.scope);
                this.scope.put(JavaScriptEvaluator.getFieldVar(name), (Scriptable)this.scope, (Object)jsField);
            }
        }
    }

    @Override
    protected Object evaluate(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getDefaultExpression());
    }

    @Override
    protected Object evaluateEstimated(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getEstimatedExpression());
    }

    @Override
    protected Object evaluateOld(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getOldExpression());
    }

    protected JavaScriptCompileData.Expression getExpression(int id) {
        return this.compileData.getExpression(id);
    }

    protected Object evaluateExpression(String type, String expression) {
        return this.evaluateExpression(expression);
    }

    protected Object evaluateExpression(String expression) {
        Object javaValue;
        Script compiledExpression = this.getCompiledExpression(expression);
        Object value = compiledExpression.exec(this.context, (Scriptable)this.scope);
        if (value == null || value instanceof Number) {
            javaValue = value;
        } else {
            try {
                javaValue = Context.jsToJava((Object)value, Object.class);
            }
            catch (EvaluatorException e2) {
                throw new JRRuntimeException(e2);
            }
        }
        return javaValue;
    }

    protected Script getCompiledExpression(String expression) {
        Script compiledExpression = this.compiledExpressions.get(expression);
        if (compiledExpression == null) {
            compiledExpression = this.context.compileString(expression, "expression", 0, null);
            this.compiledExpressions.put(expression, compiledExpression);
        }
        return compiledExpression;
    }

    protected Class<?> getTypeClass(String type) {
        Class<?> typeClass = this.loadedTypes.get(type);
        if (typeClass == null) {
            try {
                typeClass = JRClassLoader.loadClassForName(type);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException("Unable to load class " + type, e2);
            }
            this.loadedTypes.put(type, typeClass);
        }
        return typeClass;
    }

    public static class JSVariable
    extends JSValue {
        private final JRFillVariable variable;

        public JSVariable(JRFillVariable variable, ScriptableObject scope) {
            super(scope);
            this.variable = variable;
        }

        public Object getValue() {
            return this.toJSValue(this.variable.getValue());
        }

        public Object getOldValue() {
            return this.toJSValue(this.variable.getOldValue());
        }

        public Object getEstimatedValue() {
            return this.toJSValue(this.variable.getEstimatedValue());
        }
    }

    public static class JSField
    extends JSValue {
        private final JRFillField field;

        public JSField(JRFillField field, ScriptableObject scope) {
            super(scope);
            this.field = field;
        }

        public Object getValue() {
            return this.toJSValue(this.field.getValue());
        }

        public Object getOldValue() {
            return this.toJSValue(this.field.getOldValue());
        }
    }

    public static class JSParameter
    extends JSValue {
        private final JRFillParameter parameter;

        public JSParameter(JRFillParameter parameter, ScriptableObject scope) {
            super(scope);
            this.parameter = parameter;
        }

        public Object getValue() {
            return this.toJSValue(this.parameter.getValue());
        }
    }

    public static abstract class JSValue {
        private final ScriptableObject scope;

        protected JSValue(ScriptableObject scope) {
            this.scope = scope;
        }

        protected final Object toJSValue(Object value) {
            return Context.javaToJS((Object)value, (Scriptable)this.scope);
        }
    }
}

