/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldNumberComparator
extends AbstractFieldComparator<Number> {
    public FieldNumberComparator(String filterPattern, Locale locale) {
        this.formatter = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        if (filterPattern != null && filterPattern.trim().length() > 0 && this.formatter instanceof DecimalFormat) {
            ((DecimalFormat)this.formatter).applyPattern(filterPattern);
        }
    }

    @Override
    public void initValues() throws Exception {
        if (this.valueStart != null && this.valueStart.length() > 0) {
            this.compareStart = FormatUtils.getFormattedNumber((NumberFormat)this.formatter, this.valueStart, ((Number)this.compareTo).getClass());
        }
        if (this.valueEnd != null && this.valueEnd.length() > 0) {
            this.compareEnd = FormatUtils.getFormattedNumber((NumberFormat)this.formatter, this.valueEnd, ((Number)this.compareTo).getClass());
        }
    }

    @Override
    public boolean compare(String filterTypeOperator) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        boolean resultPart1 = true;
        boolean resultPart2 = true;
        try {
            this.initValues();
        }
        catch (Exception e2) {
            throw new JRRuntimeException(e2);
        }
        FilterTypeNumericOperatorsEnum numericEnum = FilterTypeNumericOperatorsEnum.getByEnumConstantName(filterTypeOperator);
        BigDecimal dbA = new BigDecimal(((Number)this.compareTo).toString());
        BigDecimal dbStart = this.compareStart != null ? new BigDecimal(((Number)this.compareStart).toString()) : null;
        BigDecimal dbEnd = this.compareEnd != null ? new BigDecimal(((Number)this.compareEnd).toString()) : null;
        switch (numericEnum) {
            case DOES_NOT_EQUAL: {
                result = dbStart != null ? dbA.compareTo(dbStart) != 0 : defaultResult;
                break;
            }
            case EQUALS: {
                result = dbStart != null ? dbA.compareTo(dbStart) == 0 : defaultResult;
                break;
            }
            case GREATER_THAN: {
                result = dbStart != null ? dbA.compareTo(dbStart) > 0 : defaultResult;
                break;
            }
            case GREATER_THAN_EQUAL_TO: {
                result = dbStart != null ? dbA.compareTo(dbStart) >= 0 : defaultResult;
                break;
            }
            case IS_BETWEEN: {
                boolean bl = dbStart != null ? dbA.compareTo(dbStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = dbEnd != null ? dbA.compareTo(dbEnd) <= 0 : defaultResult;
                result = resultPart1 && resultPart2;
                break;
            }
            case IS_NOT_BETWEEN: {
                boolean bl = dbStart != null ? dbA.compareTo(dbStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = dbEnd != null ? dbA.compareTo(dbEnd) <= 0 : defaultResult;
                result = !resultPart1 || !resultPart2;
                break;
            }
            case LESS_THAN: {
                result = dbStart != null ? dbA.compareTo(dbStart) < 0 : defaultResult;
                break;
            }
            case LESS_THAN_EQUAL_TO: {
                result = dbStart != null ? dbA.compareTo(dbStart) <= 0 : defaultResult;
            }
        }
        return result;
    }
}

