/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.util;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JasperDesign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableUtil {
    public static final int TABLE_HEADER = 0;
    public static final int TABLE_FOOTER = 1;
    public static final int COLUMN_HEADER = 2;
    public static final int COLUMN_FOOTER = 3;
    public static final int COLUMN_DETAIL = 4;
    public static final int COLUMN_GROUP_HEADER = 5;
    public static final int COLUMN_GROUP_FOOTER = 6;
    private TableComponent table;
    private Map<Cell, Rectangle> boundsMap = new HashMap<Cell, Rectangle>();
    private JasperDesign jasperDesign;

    public TableUtil(TableComponent table, JasperDesign jasperDesign) {
        this.table = table;
        this.jasperDesign = jasperDesign;
        this.init(table);
    }

    public Map<Cell, Rectangle> getCellBounds() {
        return this.boundsMap;
    }

    public void refresh() {
        this.init(this.table);
    }

    public void init(TableComponent table) {
        this.boundsMap.clear();
        List<BaseColumn> allColumns = TableUtil.getAllColumns(table.getColumns());
        int y = 0;
        int h2 = 0;
        Rectangle r2 = new Rectangle(0, 0, 0, 0);
        for (BaseColumn bc : table.getColumns()) {
            r2 = this.initHeader(r2, bc, 0, null);
            r2.setLocation(r2.x, y);
            if (h2 >= r2.height) continue;
            h2 = r2.height;
        }
        r2 = new Rectangle(0, y += h2, 0, 0);
        h2 = 0;
        for (BaseColumn bc : table.getColumns()) {
            r2 = this.initHeader(r2, bc, 2, null);
            r2.setLocation(r2.x, y);
            if (h2 >= r2.height) continue;
            h2 = r2.height;
        }
        List<?> groupsList = this.getGroupList();
        if (groupsList != null) {
            for (JRGroup jrGroup : groupsList) {
                r2 = new Rectangle(0, y += h2, 0, 0);
                h2 = 0;
                for (BaseColumn bc : table.getColumns()) {
                    r2 = this.initHeader(r2, bc, 5, jrGroup.getName());
                    r2.setLocation(r2.x, y);
                    if (h2 >= r2.height) continue;
                    h2 = r2.height;
                }
            }
        }
        r2 = new Rectangle(0, y += h2, 0, 0);
        h2 = 0;
        for (BaseColumn bc : allColumns) {
            r2 = this.initDetail(r2, bc);
            r2.setLocation(r2.x, y);
            if (h2 >= r2.height) continue;
            h2 = r2.height;
        }
        if (groupsList != null) {
            Iterator<?> it = groupsList.listIterator(groupsList.size());
            while (it.hasPrevious()) {
                JRGroup jrGroup;
                jrGroup = (JRGroup)it.previous();
                r2 = new Rectangle(0, y += h2, 0, 0);
                h2 = 0;
                for (BaseColumn bc : table.getColumns()) {
                    r2 = this.initFooter(r2, bc, 6, jrGroup.getName());
                    r2.setLocation(r2.x, y);
                    if (h2 >= r2.height) continue;
                    h2 = r2.height;
                }
            }
        }
        r2 = new Rectangle(0, y += h2, 0, 0);
        h2 = 0;
        for (BaseColumn bc : table.getColumns()) {
            r2 = this.initFooter(r2, bc, 3, null);
            r2.setLocation(r2.x, y);
            if (h2 >= r2.height) continue;
            h2 = r2.height;
        }
        r2 = new Rectangle(0, y += h2, 0, 0);
        for (BaseColumn bc : table.getColumns()) {
            r2 = this.initFooter(r2, bc, 1, null);
            r2.setLocation(r2.x, y);
        }
    }

    public static List<BaseColumn> getAllColumns(TableComponent table) {
        return TableUtil.getAllColumns(table.getColumns());
    }

    public static List<BaseColumn> getAllColumns(List<BaseColumn> cols) {
        ArrayList<BaseColumn> lst = new ArrayList<BaseColumn>();
        for (BaseColumn bc : cols) {
            if (bc instanceof ColumnGroup) {
                lst.addAll(TableUtil.getAllColumns(((ColumnGroup)bc).getColumns()));
                continue;
            }
            lst.add(bc);
        }
        return lst;
    }

    private Rectangle initDetail(Rectangle p2, BaseColumn bc) {
        int h2 = 0;
        int w2 = 0;
        if (bc != null && bc instanceof Column) {
            Cell c2 = ((Column)bc).getDetailCell();
            w2 = bc.getWidth();
            if (c2 != null) {
                h2 = c2.getHeight();
            }
            this.boundsMap.put(c2, new Rectangle(p2.x, p2.y, w2, h2));
        }
        return new Rectangle(p2.x + w2, p2.y, w2, h2);
    }

    private Rectangle initHeader(Rectangle p2, BaseColumn bc, int type, String grName) {
        int y = p2.y;
        int h2 = 0;
        int w2 = bc.getWidth();
        Cell c2 = TableUtil.getCell(bc, type, grName);
        if (c2 != null) {
            y = p2.y + c2.getHeight();
            h2 = c2.getHeight();
            this.boundsMap.put(c2, new Rectangle(p2.x, p2.y, w2, h2));
        }
        if (bc instanceof ColumnGroup) {
            Rectangle pi = new Rectangle(p2.x, y, w2, h2);
            int hi = 0;
            for (BaseColumn bcg : ((ColumnGroup)bc).getColumns()) {
                pi = this.initHeader(pi, bcg, type, grName);
                pi.setLocation(pi.x, y);
                if (hi >= pi.height) continue;
                hi = pi.height;
            }
            h2 += hi;
        }
        return new Rectangle(p2.x + w2, y, w2, h2);
    }

    private Rectangle initFooter(Rectangle p2, BaseColumn bc, int type, String grName) {
        int y = p2.y;
        int h2 = 0;
        int w2 = bc.getWidth();
        Cell c2 = TableUtil.getCell(bc, type, grName);
        if (bc instanceof ColumnGroup) {
            Rectangle pi = new Rectangle(p2.x, y, w2, h2);
            int hi = 0;
            for (BaseColumn bcg : ((ColumnGroup)bc).getColumns()) {
                pi = this.initFooter(pi, bcg, type, grName);
                pi.setLocation(pi.x, y);
                if (hi >= pi.height) continue;
                hi = pi.height;
            }
            h2 += hi;
        }
        if (c2 != null) {
            y = p2.y + h2;
            h2 = c2.getHeight();
            this.boundsMap.put(c2, new Rectangle(p2.x, y, w2, h2));
        }
        return new Rectangle(p2.x + w2, y, w2, h2);
    }

    public Rectangle getBounds(int width, Cell cell, BaseColumn col) {
        Rectangle b2 = this.boundsMap.get(cell);
        if (b2 != null) {
            return b2;
        }
        int w2 = col != null ? col.getWidth() : 0;
        int h2 = cell != null ? cell.getHeight() : 0;
        return new Rectangle(0, 0, w2, h2);
    }

    public List<?> getGroupList() {
        return TableUtil.getGroupList(this.table, this.jasperDesign);
    }

    public static List<?> getGroupList(TableComponent table, JasperDesign jd) {
        List<JRGroup> groupsList = null;
        JRDatasetRun datasetRun = table.getDatasetRun();
        if (datasetRun != null) {
            String dataSetName = datasetRun.getDatasetName();
            JRDataset ds = jd.getDatasetMap().get(dataSetName);
            groupsList = ds != null ? Arrays.asList(ds.getGroups()) : null;
        }
        return groupsList;
    }

    public static Cell getCell(BaseColumn bc, int type, String grName) {
        Cell cell = null;
        switch (type) {
            case 0: {
                cell = bc.getTableHeader();
                break;
            }
            case 1: {
                cell = bc.getTableFooter();
                break;
            }
            case 2: {
                cell = bc.getColumnHeader();
                break;
            }
            case 3: {
                cell = bc.getColumnFooter();
                break;
            }
            case 4: {
                if (!(bc instanceof Column)) break;
                cell = ((Column)bc).getDetailCell();
                break;
            }
            case 5: {
                cell = bc.getGroupHeader(grName);
                break;
            }
            case 6: {
                cell = bc.getGroupFooter(grName);
            }
        }
        return cell;
    }
}

