/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.jndi;

import java.sql.Connection;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.jndi.JndiDataAdapter;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiDataAdapterService
extends AbstractDataAdapterService {
    private static final Log log = LogFactory.getLog(JndiDataAdapterService.class);
    private Connection connection = null;

    public JndiDataAdapterService(JndiDataAdapter jndiDataAdapter) {
        super(jndiDataAdapter);
    }

    public JndiDataAdapter getJndiDataAdapter() {
        return (JndiDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        JndiDataAdapter jndiDataAdapter = this.getJndiDataAdapter();
        if (jndiDataAdapter != null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource dataSource = (DataSource)ctx.lookup("java:comp/env/" + jndiDataAdapter.getDataSourceName());
                this.connection = dataSource.getConnection();
            }
            catch (Exception ex) {
                throw new JRException(ex);
            }
            parameters.put("REPORT_CONNECTION", this.connection);
        }
    }

    @Override
    public void dispose() {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error("Error while closing the connection.", ex);
                }
            }
        }
    }
}

