/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public abstract class JRAbstractSvgRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;

    public byte getType() {
        return 1;
    }

    public byte getImageType() {
        return 3;
    }

    public Dimension2D getDimension() {
        return null;
    }

    public Color getBackcolor() {
        return null;
    }

    public byte[] getImageData() throws JRException {
        int dpi = JRProperties.getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
        double scale = (double)dpi / 72.0;
        Dimension2D dimension = this.getDimension();
        if (dimension != null) {
            byte imageType = this.getImageType();
            BufferedImage bi = new BufferedImage((int)(scale * dimension.getWidth()), (int)(scale * dimension.getHeight()), imageType == 1 || imageType == 3 ? 2 : 1);
            Graphics2D g2 = this.createGraphics(bi);
            g2.scale(scale, scale);
            Color backcolor = this.getBackcolor();
            if (backcolor != null) {
                g2.setColor(backcolor);
                g2.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
            this.render(g2, new Rectangle((int)dimension.getWidth(), (int)dimension.getHeight()));
            g2.dispose();
            return JRImageLoader.loadImageDataFromAWTImage(bi, this.getImageType());
        }
        return null;
    }

    protected Graphics2D createGraphics(BufferedImage bi) {
        return bi.createGraphics();
    }
}

