/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.repo.RepositoryUtil;

public class JRImageRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;
    private byte[] imageData;
    private String imageLocation;
    private byte imageType = 0;
    private transient SoftReference<Image> awtImageRef;

    protected JRImageRenderer(byte[] imageData) {
        this.imageData = imageData;
        if (imageData != null) {
            this.imageType = JRTypeSniffer.getImageType(imageData);
        }
    }

    protected JRImageRenderer(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public static JRImageRenderer getInstance(byte[] imageData) {
        return new JRImageRenderer(imageData);
    }

    public static JRRenderable getInstance(String imageLocation) throws JRException {
        return JRImageRenderer.getInstance(imageLocation, OnErrorTypeEnum.ERROR, true);
    }

    public static JRRenderable getInstance(String imageLocation, OnErrorTypeEnum onErrorType) throws JRException {
        return JRImageRenderer.getInstance(imageLocation, onErrorType, true);
    }

    public static JRRenderable getInstance(String imageLocation, OnErrorTypeEnum onErrorType, boolean isLazy) throws JRException {
        if (imageLocation == null) {
            return null;
        }
        if (isLazy) {
            return new JRImageRenderer(imageLocation);
        }
        try {
            byte[] data = RepositoryUtil.getBytes(imageLocation);
            return new JRImageRenderer(data);
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRRenderable getInstance(String imageLocation, OnErrorTypeEnum onErrorType, boolean isLazy, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory, FileResolver fileResolver) throws JRException {
        if (imageLocation == null) {
            return null;
        }
        if (isLazy) {
            return new JRImageRenderer(imageLocation);
        }
        try {
            byte[] data = JRLoader.loadBytesFromLocation(imageLocation, classLoader, urlHandlerFactory, fileResolver);
            return new JRImageRenderer(data);
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRRenderable getInstance(Image img, OnErrorTypeEnum onErrorType) throws JRException {
        ColorModel colorModel;
        int type = 2;
        if (img instanceof RenderedImage && (colorModel = ((RenderedImage)((Object)img)).getColorModel()).hasAlpha() && colorModel.getTransparency() != 1) {
            type = 3;
        }
        return JRImageRenderer.getInstance(img, (byte)type, onErrorType);
    }

    public static JRRenderable getInstance(Image image, byte imageType, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromAWTImage(image, imageType));
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRRenderable getInstance(InputStream is, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(is));
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRRenderable getInstance(URL url, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(url));
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRRenderable getInstance(File file, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(file));
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRRenderable getOnErrorRendererForDimension(JRRenderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            renderer.getDimension();
            return renderer;
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRRenderable getOnErrorRendererForImageData(JRRenderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            renderer.getImageData();
            return renderer;
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRImageRenderer getOnErrorRendererForImage(JRImageRenderer renderer, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            renderer.getImage();
            return renderer;
        }
        catch (JRException e2) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e2);
        }
    }

    public static JRImageRenderer getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRException e2) throws JRException {
        JRImageRenderer renderer = null;
        switch (onErrorType) {
            case ICON: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/image-16.png");
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                throw e2;
            }
        }
        return renderer;
    }

    public Image getImage() throws JRException {
        if (this.awtImageRef == null || this.awtImageRef.get() == null) {
            Image awtImage = JRImageLoader.loadImage(this.getImageData());
            this.awtImageRef = new SoftReference<Image>(awtImage);
        }
        return this.awtImageRef.get();
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public byte getType() {
        return 0;
    }

    public byte getImageType() {
        return this.imageType;
    }

    public Dimension2D getDimension() throws JRException {
        Image img = this.getImage();
        return new Dimension(img.getWidth(null), img.getHeight(null));
    }

    public byte[] getImageData() throws JRException {
        if (this.imageData == null) {
            this.imageData = RepositoryUtil.getBytes(this.imageLocation);
            if (this.imageData != null) {
                this.imageType = JRTypeSniffer.getImageType(this.imageData);
            }
        }
        return this.imageData;
    }

    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        Image img = this.getImage();
        grx.drawImage(img, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), null);
    }
}

