/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseDataset
implements JRDataset,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_WHEN_RESOURCE_MISSING_TYPE = "whenResourceMissingType";
    protected final boolean isMain;
    protected String name;
    protected String scriptletClass;
    protected JRScriptlet[] scriptlets;
    protected JRParameter[] parameters;
    protected JRQuery query;
    protected JRField[] fields;
    protected JRSortField[] sortFields;
    protected JRVariable[] variables;
    protected JRGroup[] groups;
    protected String resourceBundle;
    protected WhenResourceMissingTypeEnum whenResourceMissingTypeValue = WhenResourceMissingTypeEnum.NULL;
    protected JRPropertiesMap propertiesMap;
    protected JRExpression filterExpression;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 40103;
    private byte whenResourceMissingType;

    protected JRBaseDataset(boolean isMain) {
        this.isMain = isMain;
        this.propertiesMap = new JRPropertiesMap();
    }

    protected JRBaseDataset(JRDataset dataset, JRBaseObjectFactory factory) {
        JRGroup[] jrGroups;
        JRVariable[] jrVariables;
        JRSortField[] jrSortFields;
        JRField[] jrFields;
        JRParameter[] jrParameters;
        factory.put(dataset, this);
        this.name = dataset.getName();
        this.scriptletClass = dataset.getScriptletClass();
        this.resourceBundle = dataset.getResourceBundle();
        this.whenResourceMissingTypeValue = dataset.getWhenResourceMissingTypeValue();
        this.propertiesMap = dataset.getPropertiesMap().cloneProperties();
        this.query = factory.getQuery(dataset.getQuery());
        this.isMain = dataset.isMainDataset();
        JRScriptlet[] jrScriptlets = dataset.getScriptlets();
        if (jrScriptlets != null && jrScriptlets.length > 0) {
            this.scriptlets = new JRScriptlet[jrScriptlets.length];
            for (int i2 = 0; i2 < this.scriptlets.length; ++i2) {
                this.scriptlets[i2] = factory.getScriptlet(jrScriptlets[i2]);
            }
        }
        if ((jrParameters = dataset.getParameters()) != null && jrParameters.length > 0) {
            this.parameters = new JRParameter[jrParameters.length];
            for (int i3 = 0; i3 < this.parameters.length; ++i3) {
                this.parameters[i3] = factory.getParameter(jrParameters[i3]);
            }
        }
        if ((jrFields = dataset.getFields()) != null && jrFields.length > 0) {
            this.fields = new JRField[jrFields.length];
            for (int i4 = 0; i4 < this.fields.length; ++i4) {
                this.fields[i4] = factory.getField(jrFields[i4]);
            }
        }
        if ((jrSortFields = dataset.getSortFields()) != null && jrSortFields.length > 0) {
            this.sortFields = new JRSortField[jrSortFields.length];
            for (int i5 = 0; i5 < this.sortFields.length; ++i5) {
                this.sortFields[i5] = factory.getSortField(jrSortFields[i5]);
            }
        }
        if ((jrVariables = dataset.getVariables()) != null && jrVariables.length > 0) {
            this.variables = new JRVariable[jrVariables.length];
            for (int i6 = 0; i6 < this.variables.length; ++i6) {
                this.variables[i6] = factory.getVariable(jrVariables[i6]);
            }
        }
        if ((jrGroups = dataset.getGroups()) != null && jrGroups.length > 0) {
            this.groups = new JRGroup[jrGroups.length];
            for (int i7 = 0; i7 < this.groups.length; ++i7) {
                this.groups[i7] = factory.getGroup(jrGroups[i7]);
            }
        }
        this.filterExpression = factory.getExpression(dataset.getFilterExpression());
    }

    public String getName() {
        return this.name;
    }

    public String getScriptletClass() {
        return this.scriptletClass;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRScriptlet[] getScriptlets() {
        return this.scriptlets;
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRSortField[] getSortFields() {
        return this.sortFields;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public boolean isMainDataset() {
        return this.isMain;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
        return this.whenResourceMissingTypeValue;
    }

    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingTypeValue) {
        WhenResourceMissingTypeEnum old = this.whenResourceMissingTypeValue;
        this.whenResourceMissingTypeValue = whenResourceMissingTypeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_RESOURCE_MISSING_TYPE, old, this.whenResourceMissingTypeValue);
    }

    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.propertiesMap;
    }

    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public JRExpression getFilterExpression() {
        return this.filterExpression;
    }

    public Object clone() {
        JRBaseDataset clone = null;
        try {
            clone = (JRBaseDataset)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        clone.query = JRCloneUtils.nullSafeClone(this.query);
        clone.filterExpression = JRCloneUtils.nullSafeClone(this.filterExpression);
        if (this.propertiesMap != null) {
            clone.propertiesMap = (JRPropertiesMap)this.propertiesMap.clone();
        }
        clone.parameters = (JRParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.parameters);
        clone.fields = (JRField[])JRCloneUtils.cloneArray((JRCloneable[])this.fields);
        clone.sortFields = (JRSortField[])JRCloneUtils.cloneArray((JRCloneable[])this.sortFields);
        clone.variables = (JRVariable[])JRCloneUtils.cloneArray((JRCloneable[])this.variables);
        clone.groups = (JRGroup[])JRCloneUtils.cloneArray((JRCloneable[])this.groups);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseDataset jRBaseDataset = this;
        synchronized (jRBaseDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.whenResourceMissingTypeValue = WhenResourceMissingTypeEnum.getByValue(this.whenResourceMissingType);
        }
    }
}

