/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRBaseElementGroup
implements JRElementGroup,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected List<JRChild> children = new ArrayList<JRChild>();
    protected JRElementGroup elementGroup;

    protected JRBaseElementGroup() {
    }

    protected JRBaseElementGroup(JRElementGroup elementGrp, JRBaseObjectFactory factory) {
        factory.put(elementGrp, this);
        List<JRChild> list = elementGrp.getChildren();
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                JRChild child = list.get(i2);
                child = (JRChild)factory.getVisitResult(child);
                this.children.add(child);
            }
        }
        this.elementGroup = (JRElementGroup)factory.getVisitResult(elementGrp.getElementGroup());
    }

    @Override
    public List<JRChild> getChildren() {
        return this.children;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public static JRElement[] getElements(List<JRChild> children) {
        JRElement[] elements = null;
        if (children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            JRChild child = null;
            JRElement[] childElementArray = null;
            for (int i2 = 0; i2 < children.size(); ++i2) {
                child = children.get(i2);
                if (child instanceof JRElement) {
                    allElements.add((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRElementGroup) || (childElementArray = ((JRElementGroup)child).getElements()) == null) continue;
                allElements.addAll(Arrays.asList(childElementArray));
            }
            elements = new JRElement[allElements.size()];
            allElements.toArray(elements);
        }
        return elements;
    }

    @Override
    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    public static JRElement getElementByKey(JRElement[] elements, String key) {
        JRElement element = null;
        if (key != null && elements != null) {
            for (int i2 = 0; element == null && i2 < elements.length; ++i2) {
                JRElement elem = elements[i2];
                if (key.equals(elem.getKey())) {
                    element = elem;
                    continue;
                }
                if (elem instanceof JRFrame) {
                    element = ((JRFrame)elem).getElementByKey(key);
                    continue;
                }
                if (!(elem instanceof JRCrosstab)) continue;
                element = ((JRCrosstab)elem).getElementByKey(key);
            }
        }
        return element;
    }

    @Override
    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitElementGroup(this);
    }

    @Override
    public Object clone() {
        JRBaseElementGroup clone = null;
        try {
            clone = (JRBaseElementGroup)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        if (this.children != null) {
            clone.children = new ArrayList<JRChild>(this.children.size());
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                clone.children.add((JRChild)this.children.get(i2).clone(clone));
            }
        }
        return clone;
    }

    @Override
    public Object clone(JRElementGroup parentGroup) {
        JRBaseElementGroup clone = (JRBaseElementGroup)this.clone();
        clone.elementGroup = parentGroup;
        return clone;
    }
}

