/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.VirtualizableElementList;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizationObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRVirtualPrintPage
implements JRPrintPage,
Serializable {
    protected static final Log log = LogFactory.getLog(JRVirtualPrintPage.class);
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_VIRTUAL_PAGE_ELEMENT_SIZE = "net.sf.jasperreports.virtual.page.element.size";
    private VirtualizableElementList elements;

    public JRVirtualPrintPage(JasperPrint printObject, JRVirtualizer virtualizer, JRVirtualizationContext virtualizationContext) {
        this(printObject, virtualizationContext);
    }

    public JRVirtualPrintPage(JasperPrint printObject, JRVirtualizationContext virtualizationContext) {
        this.elements = new VirtualizableElementList(virtualizationContext);
        if (log.isDebugEnabled()) {
            log.debug("created list " + this.elements + " for page " + this);
        }
    }

    @Override
    public List<JRPrintElement> getElements() {
        return this.elements;
    }

    @Override
    public void setElements(List<JRPrintElement> elements) {
        this.elements.set(elements);
    }

    @Override
    public void addElement(JRPrintElement element) {
        this.elements.add(element);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (object instanceof VirtualizableElementList) {
            this.elements = (VirtualizableElementList)object;
        } else {
            String oldUid = (String)object;
            if (log.isDebugEnabled()) {
                log.debug("Original page uid " + oldUid);
            }
            JRVirtualizationContext virtualizationContext = (JRVirtualizationContext)in.readObject();
            int length = in.readInt();
            byte[] buffer = new byte[length];
            in.readFully(buffer);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, buffer.length);
            VirtualizationObjectInputStream elementsStream = new VirtualizationObjectInputStream(inputStream, virtualizationContext);
            List elementsList = (List)elementsStream.readObject();
            this.elements = new VirtualizableElementList(virtualizationContext);
            this.elements.addAll(elementsList);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.elements);
    }

    public void dispose() {
        this.elements.dispose();
    }

    public static class JRIdHolderTemplateElement
    extends JRTemplateElement {
        private static final long serialVersionUID = 10200L;

        public JRIdHolderTemplateElement(String id) {
            super(id);
        }

        public int getHashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean isIdentical(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    public static class JRIdHolderRenderer
    implements JRRenderable {
        private static final long serialVersionUID = 10200L;
        protected final String id;

        public JRIdHolderRenderer(JRRenderable renderer) {
            this.id = renderer.getId();
        }

        public String getId() {
            return this.id;
        }

        public byte getType() {
            return 0;
        }

        public byte getImageType() {
            return 0;
        }

        public Dimension2D getDimension() throws JRException {
            return null;
        }

        public byte[] getImageData() throws JRException {
            return null;
        }

        public void render(Graphics2D grx, Rectangle2D rectanle) throws JRException {
        }
    }
}

