/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ImageConverter
extends ElementConverter {
    private static final Log log = LogFactory.getLog(ImageConverter.class);
    private static final ImageConverter INSTANCE = new ImageConverter();

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRImage image = (JRImage)element;
        this.copyGraphicElement(reportConverter, image, printImage);
        printImage.copyBox(image.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(image.getAnchorNameExpression()));
        printImage.setBookmarkLevel(image.getBookmarkLevel());
        printImage.setHorizontalAlignment(image.getOwnHorizontalAlignmentValue());
        printImage.setLazy(image.isLazy());
        printImage.setLinkType(image.getLinkType());
        printImage.setOnErrorType(OnErrorTypeEnum.ICON);
        printImage.setVerticalAlignment(image.getOwnVerticalAlignmentValue());
        printImage.setRenderer(this.getRenderer(image, printImage));
        printImage.setScaleImage(image.getOwnScaleImageValue());
        return printImage;
    }

    private JRRenderable getRenderer(JRImage imageElement, JRPrintImage printImage) {
        block6: {
            String location = JRExpressionUtil.getSimpleExpressionText(imageElement.getExpression());
            if (location != null) {
                try {
                    return JRImageRenderer.getInstance(location);
                }
                catch (JRException e2) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Creating location renderer for converted image failed.", e2);
                }
            }
        }
        try {
            printImage.setScaleImage(ScaleImageEnum.CLIP);
            return JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/image-16.png", imageElement.getOnErrorTypeValue());
        }
        catch (JRException e3) {
            if (log.isDebugEnabled()) {
                log.debug("Creating icon renderer for converted image failed.", e3);
            }
            return null;
        }
    }
}

