/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.ElementKeyExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilterFactory;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.util.JRProperties;

public class ElementKeyExporterFilterFactory
implements ExporterFilterFactory {
    public static final String PROPERTY_EXCLUDED_KEY_PREFIX = "exclude.key.";

    public ExporterFilter getFilter(JRExporterContext exporterContext) throws JRException {
        ElementKeyExporterFilter filter;
        String excludeKeyPrefix = exporterContext.getExportPropertiesPrefix() + PROPERTY_EXCLUDED_KEY_PREFIX;
        List<JRProperties.PropertySuffix> props = JRProperties.getProperties(exporterContext.getExportedReport(), excludeKeyPrefix);
        if (props.isEmpty()) {
            filter = null;
        } else {
            HashSet<String> excludedKeys = new HashSet<String>();
            for (JRProperties.PropertySuffix prop : props) {
                String key = prop.getValue();
                if (key == null || key.length() == 0) {
                    key = prop.getSuffix();
                }
                excludedKeys.add(key);
            }
            filter = new ElementKeyExporterFilter(excludedKeys);
        }
        return filter;
    }
}

