/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRAbstractCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvMetadataExporterParameter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRCsvMetadataExporter
extends JRAbstractCsvExporter {
    protected boolean writeHeader;
    protected List<String> columnNames;
    boolean isFirstRow = true;

    @Override
    protected void exportPage(JRPrintPage page) throws IOException {
        List<JRPrintElement> elements = page.getElements();
        HashMap<String, String> currentRow = new HashMap<String, String>();
        HashMap<String, String> repeatedValues = new HashMap<String, String>();
        boolean hasDefinedColumns = this.columnNames != null;
        String currentTextValue = null;
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            JRStyledText styledText;
            JRPrintText textElement;
            JRPrintElement element = elements.get(i2);
            if (!(element instanceof JRPrintText) || (textElement = (JRPrintText)element).getPropertiesMap().getPropertyNames().length <= 0) continue;
            String currentColumnName = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.csv.column.name");
            String currentColumnData = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.csv.data");
            boolean repeatValue = JRProperties.getBooleanProperty(textElement, "net.sf.jasperreports.export.csv.repeat.value", false);
            currentTextValue = currentColumnData != null ? currentColumnData : ((styledText = this.getStyledText((JRPrintText)element)) != null ? styledText.getText() : "");
            if (!hasDefinedColumns) {
                if (this.columnNames == null) {
                    this.columnNames = new ArrayList<String>();
                }
                if (currentColumnName != null && currentColumnName.length() > 0 && !this.columnNames.contains(currentColumnName)) {
                    this.columnNames.add(currentColumnName);
                }
            }
            if (this.columnNames.size() <= 0) continue;
            if (this.columnNames.contains(currentColumnName) && !currentRow.containsKey(currentColumnName) && this.isColumnReadOnTime(currentRow, currentColumnName)) {
                currentRow.put(currentColumnName, currentTextValue);
            } else if (this.columnNames.contains(currentColumnName) && !currentRow.containsKey(currentColumnName) && !this.isColumnReadOnTime(currentRow, currentColumnName) || this.columnNames.contains(currentColumnName) && currentRow.containsKey(currentColumnName)) {
                if (this.isFirstRow && this.writeHeader) {
                    this.writeReportHeader();
                }
                if (this.isFirstRow) {
                    this.isFirstRow = false;
                }
                this.writeCurrentRow(currentRow, repeatedValues);
                currentRow = new HashMap();
                currentRow.put(currentColumnName, currentTextValue);
            }
            if (!repeatValue || currentColumnName == null || currentColumnName.length() <= 0 || currentTextValue.length() <= 0) continue;
            repeatedValues.put(currentColumnName, currentTextValue);
        }
        if (this.columnNames != null && this.columnNames.size() > 0) {
            this.writeCurrentRow(currentRow, repeatedValues);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    @Override
    protected void setParameters() {
        super.setParameters();
        this.writeHeader = this.getBooleanParameter(JRCsvMetadataExporterParameter.WRITE_HEADER, "net.sf.jasperreports.export.csv.write.header", false);
        this.setColumnNames();
    }

    protected void setColumnNames() {
        String[] columnNamesArray = this.getStringArrayParameter(JRCsvMetadataExporterParameter.COLUMN_NAMES, "net.sf.jasperreports.export.csv.column.names");
        if (columnNamesArray != null && columnNamesArray.length > 0) {
            this.columnNames = new ArrayList<String>();
            for (int i2 = 0; i2 < columnNamesArray.length; ++i2) {
                if (columnNamesArray[i2] == null) {
                    this.columnNames.add(null);
                    continue;
                }
                String[] currentColumnNamesArray = columnNamesArray[i2].split(",");
                for (int j2 = 0; j2 < currentColumnNamesArray.length; ++j2) {
                    this.columnNames.add(currentColumnNamesArray[j2].trim());
                }
            }
        }
    }

    protected void writeReportHeader() throws IOException {
        StringBuffer rowBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.columnNames.size(); ++i2) {
            rowBuffer.append(this.columnNames.get(i2));
            if (i2 < this.columnNames.size() - 1) {
                rowBuffer.append(this.delimiter);
                continue;
            }
            rowBuffer.append(this.recordDelimiter);
        }
        if (rowBuffer.length() > 0) {
            this.writer.write(rowBuffer.toString());
        }
    }

    protected void writeCurrentRow(Map<String, String> currentRow, Map<String, String> repeatedValues) throws IOException {
        StringBuffer rowBuffer = new StringBuffer();
        boolean isEmptyRow = true;
        for (int i2 = 0; i2 < this.columnNames.size(); ++i2) {
            String currentTextValue = currentRow.get(this.columnNames.get(i2));
            if (currentTextValue != null && currentTextValue.length() > 0) {
                isEmptyRow = false;
                rowBuffer.append(this.prepareText(currentTextValue));
            } else {
                String repeatedValue = repeatedValues.get(this.columnNames.get(i2));
                if (repeatedValue != null && repeatedValue.length() > 0) {
                    rowBuffer.append(this.prepareText(repeatedValue));
                }
            }
            if (i2 < this.columnNames.size() - 1) {
                rowBuffer.append(this.delimiter);
                continue;
            }
            rowBuffer.append(this.recordDelimiter);
        }
        if (!isEmptyRow) {
            this.writer.write(rowBuffer.toString());
        }
    }

    private boolean isColumnReadOnTime(Map<String, String> currentRow, String currentColumnName) {
        int indexOfLastFilledColumn = -1;
        Set<String> currentlyFilledColumns = currentRow.keySet();
        for (String column : currentlyFilledColumns) {
            indexOfLastFilledColumn = Math.max(indexOfLastFilledColumn, this.columnNames.indexOf(column));
        }
        return indexOfLastFilledColumn < this.columnNames.indexOf(currentColumnName);
    }
}

