/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementXmlHandler;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRXmlExporterContext;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.XmlValueHandlerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tools.codec.Base64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRXmlExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(JRXmlExporter.class);
    private static final String XML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xml.";
    public static final String XML_EXPORTER_KEY = "net.sf.jasperreports.xml";
    private static final String PROPERTY_START_PAGE_INDEX = "net.sf.jasperreports.export.xml.start.page.index";
    private static final String PROPERTY_END_PAGE_INDEX = "net.sf.jasperreports.export.xml.end.page.index";
    private static final String PROPERTY_PAGE_COUNT = "net.sf.jasperreports.export.xml.page.count";
    protected static final String DEFAULT_XML_ENCODING = "UTF-8";
    protected static final String DEFAULT_OBJECT_TYPE = "java.lang.String";
    protected static final String XML_FILES_SUFFIX = "_files";
    protected static final String IMAGE_PREFIX = "img_";
    public static final XmlNamespace JASPERPRINT_NAMESPACE = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/print", null, "http://jasperreports.sourceforge.net/xsd/jasperprint.xsd");
    protected JRXmlWriteHelper xmlWriter;
    protected String encoding;
    protected JRExportProgressMonitor progressMonitor;
    protected Map<JRRenderable, String> rendererToImagePathMap;
    protected Map<String, byte[]> imageNameToImageDataMap;
    protected Map<String, JRStyle> stylesMap = new HashMap<String, JRStyle>();
    protected boolean isEmbeddingImages = true;
    protected File destFile;
    protected File imagesDir;
    private static int imageId;
    protected JRXmlExporterContext exporterContext = new ExporterContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block17: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(this.getExporterPropertiesPrefix());
                }
                this.setPageRange();
                String dtdLocation = (String)this.parameters.get(JRXmlExporterParameter.DTD_LOCATION);
                if (dtdLocation != null) {
                    log.warn("The JRXmlExporterParameter.DTD_LOCATION export parameter has no effect and should no longer be used.");
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = DEFAULT_XML_ENCODING;
                }
                this.setHyperlinkProducerFactory();
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    StringBuffer buffer = this.exportReportToBuffer();
                    sb.append(buffer.toString());
                    break block17;
                }
                Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (outWriter != null) {
                    try {
                        this.exportReportToStream(outWriter);
                        break block17;
                    }
                    catch (IOException e2) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e2);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToStream(new OutputStreamWriter(os, this.encoding));
                        break block17;
                    }
                    catch (Exception e3) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e3);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + XML_FILES_SUFFIX);
                Boolean isEmbeddingImagesParameter = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (isEmbeddingImagesParameter == null) {
                    isEmbeddingImagesParameter = Boolean.TRUE;
                }
                this.isEmbeddingImages = isEmbeddingImagesParameter;
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    @Override
    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    protected void exportReportToFile() throws JRException {
        Set<String> imageNames;
        this.rendererToImagePathMap = new HashMap<JRRenderable, String>();
        this.imageNameToImageDataMap = new HashMap<String, byte[]>();
        Writer writer = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
            this.exportReportToStream(writer);
        }
        catch (IOException e2) {
            throw new JRException("Error writing to file : " + this.destFile, e2);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e3) {}
            }
        }
        if (!this.isEmbeddingImages && (imageNames = this.imageNameToImageDataMap.keySet()) != null && imageNames.size() > 0) {
            if (!this.imagesDir.exists()) {
                this.imagesDir.mkdir();
            }
            for (String imageName : imageNames) {
                byte[] imageData = this.imageNameToImageDataMap.get(imageName);
                File imageFile = new File(this.imagesDir, imageName);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(imageFile);
                    ((OutputStream)fos).write(imageData, 0, imageData.length);
                }
                catch (IOException e4) {
                    throw new JRException("Error writing to image file : " + imageFile, e4);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        ((OutputStream)fos).close();
                    }
                    catch (IOException e5) {}
                }
            }
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        try {
            this.exportReportToStream(buffer);
        }
        catch (IOException e2) {
            throw new JRException("Error while exporting report to buffer", e2);
        }
        return buffer.getBuffer();
    }

    protected XmlNamespace getNamespace() {
        return JASPERPRINT_NAMESPACE;
    }

    protected void exportReportToStream(Writer writer) throws JRException, IOException {
        List<JRPrintPage> pages;
        JRStyle[] styles;
        this.xmlWriter = new JRXmlWriteHelper(writer);
        this.xmlWriter.writeProlog(this.encoding);
        this.xmlWriter.startElement("jasperPrint", this.getNamespace());
        this.xmlWriter.addEncodedAttribute("name", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("pageWidth", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", this.jasperPrint.getPageHeight());
        this.xmlWriter.addAttribute("topMargin", this.jasperPrint.getTopMargin());
        this.xmlWriter.addAttribute("leftMargin", this.jasperPrint.getLeftMargin());
        this.xmlWriter.addAttribute("bottomMargin", this.jasperPrint.getBottomMargin());
        this.xmlWriter.addAttribute("rightMargin", this.jasperPrint.getRightMargin());
        this.xmlWriter.addAttribute("orientation", this.jasperPrint.getOrientationValue(), OrientationEnum.PORTRAIT);
        this.xmlWriter.addAttribute("formatFactoryClass", this.jasperPrint.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", this.jasperPrint.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", this.jasperPrint.getTimeZoneId());
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_START_PAGE_INDEX);
        this.xmlWriter.addEncodedAttribute("value", String.valueOf(this.startPageIndex));
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_END_PAGE_INDEX);
        this.xmlWriter.addEncodedAttribute("value", String.valueOf(this.endPageIndex));
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_PAGE_COUNT);
        this.xmlWriter.addEncodedAttribute("value", this.jasperPrint.getPages() == null ? null : String.valueOf(this.jasperPrint.getPages().size()));
        this.xmlWriter.closeElement();
        this.exportProperties(this.jasperPrint);
        JROrigin[] origins = this.jasperPrint.getOrigins();
        if (origins != null && origins.length > 0) {
            for (int i2 = 0; i2 < origins.length; ++i2) {
                this.exportOrigin(origins[i2]);
            }
        }
        if ((styles = this.jasperPrint.getStyles()) != null && styles.length > 0) {
            for (int i3 = 0; i3 < styles.length; ++i3) {
                this.stylesMap.put(styles[i3].getName(), styles[i3]);
                this.exportStyle(styles[i3]);
            }
        }
        if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i4 = this.startPageIndex; i4 <= this.endPageIndex; ++i4) {
                if (Thread.interrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = pages.get(i4);
                this.exportPage(page);
            }
        }
        this.xmlWriter.closeElement();
        writer.flush();
    }

    protected void exportProperties(JRPropertiesHolder propertiesHolder) throws IOException {
        JRPropertiesMap propertiesMap;
        String[] propertyNames;
        if (propertiesHolder.hasProperties() && (propertyNames = (propertiesMap = propertiesHolder.getPropertiesMap()).getPropertyNames()) != null && propertyNames.length > 0) {
            for (int i2 = 0; i2 < propertyNames.length; ++i2) {
                this.xmlWriter.startElement("property");
                this.xmlWriter.addEncodedAttribute("name", propertyNames[i2]);
                String value = propertiesMap.getProperty(propertyNames[i2]);
                if (value != null) {
                    this.xmlWriter.addEncodedAttribute("value", value);
                }
                this.xmlWriter.closeElement();
            }
        }
    }

    protected void exportStyle(JRStyle style) throws IOException {
        this.xmlWriter.startElement("style");
        this.xmlWriter.addEncodedAttribute("name", style.getName());
        this.xmlWriter.addAttribute("isDefault", style.isDefault(), false);
        if (style.getStyle() != null) {
            JRStyle baseStyle = this.stylesMap.get(style.getStyle().getName());
            if (baseStyle != null) {
                this.xmlWriter.addEncodedAttribute("style", style.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + style.getStyle().getName());
            }
        }
        this.xmlWriter.addAttribute("mode", style.getOwnModeValue());
        this.xmlWriter.addAttribute("forecolor", style.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", style.getOwnBackcolor());
        this.xmlWriter.addAttribute("fill", style.getOwnFillValue());
        this.xmlWriter.addAttribute("radius", style.getOwnRadius());
        this.xmlWriter.addAttribute("scaleImage", style.getOwnScaleImageValue());
        this.xmlWriter.addAttribute("hAlign", style.getOwnHorizontalAlignmentValue());
        this.xmlWriter.addAttribute("vAlign", style.getOwnVerticalAlignmentValue());
        this.xmlWriter.addAttribute("rotation", style.getOwnRotationValue());
        this.xmlWriter.addAttribute("markup", style.getOwnMarkup());
        this.xmlWriter.addEncodedAttribute("fontName", style.getOwnFontName());
        this.xmlWriter.addAttribute("fontSize", style.getOwnFontSize());
        this.xmlWriter.addAttribute("isBold", style.isOwnBold());
        this.xmlWriter.addAttribute("isItalic", style.isOwnItalic());
        this.xmlWriter.addAttribute("isUnderline", style.isOwnUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", style.isOwnStrikeThrough());
        this.xmlWriter.addEncodedAttribute("pdfFontName", style.getOwnPdfFontName());
        this.xmlWriter.addEncodedAttribute("pdfEncoding", style.getOwnPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", style.isOwnPdfEmbedded());
        this.exportPen(style.getLinePen());
        this.exportBox(style.getLineBox());
        this.exportParagraph(style.getParagraph());
        this.xmlWriter.closeElement();
    }

    protected void exportOrigin(JROrigin origin) throws IOException {
        this.xmlWriter.startElement("origin");
        this.xmlWriter.addEncodedAttribute("report", origin.getReportName());
        this.xmlWriter.addEncodedAttribute("group", origin.getGroupName());
        this.xmlWriter.addAttribute("band", origin.getBandTypeValue());
        this.xmlWriter.closeElement();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.xmlWriter.startElement("page");
        this.exportElements(page.getElements());
        this.xmlWriter.closeElement();
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator<JRPrintElement> it = elements.iterator();
            while (it.hasNext()) {
                this.exportElement(it.next());
            }
        }
    }

    public void exportElement(JRPrintElement element) throws IOException, JRException {
        if (this.filter == null || this.filter.isToExport(element)) {
            if (element instanceof JRPrintLine) {
                this.exportLine((JRPrintLine)element);
            } else if (element instanceof JRPrintRectangle) {
                this.exportRectangle((JRPrintRectangle)element);
            } else if (element instanceof JRPrintEllipse) {
                this.exportEllipse((JRPrintEllipse)element);
            } else if (element instanceof JRPrintImage) {
                this.exportImage((JRPrintImage)element);
            } else if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
            } else if (element instanceof JRPrintFrame) {
                this.exportFrame((JRPrintFrame)element);
            } else if (element instanceof JRGenericPrintElement) {
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.xmlWriter.startElement("line");
        this.xmlWriter.addAttribute("direction", line.getDirectionValue(), LineDirectionEnum.TOP_DOWN);
        this.exportReportElement(line);
        this.exportGraphicElement(line);
        this.xmlWriter.closeElement();
    }

    protected void exportReportElement(JRPrintElement element) throws IOException {
        int elementId;
        this.xmlWriter.startElement("reportElement");
        this.xmlWriter.addEncodedAttribute("key", element.getKey());
        JRStyle style = element.getStyle();
        if (style != null) {
            this.xmlWriter.addEncodedAttribute("style", style.getName());
        }
        this.xmlWriter.addAttribute("mode", element.getOwnModeValue());
        this.xmlWriter.addAttribute("x", element.getX() + this.getOffsetX());
        this.xmlWriter.addAttribute("y", element.getY() + this.getOffsetY());
        this.xmlWriter.addAttribute("width", element.getWidth());
        this.xmlWriter.addAttribute("height", element.getHeight());
        this.xmlWriter.addAttribute("forecolor", element.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", element.getOwnBackcolor());
        JROrigin origin = element.getOrigin();
        if (origin != null) {
            this.xmlWriter.addAttribute("origin", this.jasperPrint.getOriginsMap().get(origin));
        }
        if ((elementId = element.getSourceElementId()) != 0) {
            this.xmlWriter.addAttribute("srcId", elementId);
        }
        this.exportProperties(element);
        this.xmlWriter.closeElement();
    }

    protected void exportGraphicElement(JRPrintGraphicElement element) throws IOException {
        this.xmlWriter.startElement("graphicElement");
        this.xmlWriter.addAttribute("fill", element.getOwnFillValue());
        this.exportPen(element.getLinePen());
        this.xmlWriter.closeElement(true);
    }

    protected void exportPen(JRPen pen) throws IOException {
        this.exportPen("pen", pen);
    }

    protected void exportPen(String element, JRPen pen) throws IOException {
        this.xmlWriter.startElement(element);
        this.xmlWriter.addAttribute("lineWidth", pen.getOwnLineWidth());
        this.xmlWriter.addAttribute("lineStyle", pen.getOwnLineStyleValue());
        this.xmlWriter.addAttribute("lineColor", pen.getOwnLineColor());
        this.xmlWriter.closeElement(true);
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.xmlWriter.startElement("rectangle");
        this.xmlWriter.addAttribute("radius", rectangle.getOwnRadius());
        this.exportReportElement(rectangle);
        this.exportGraphicElement(rectangle);
        this.xmlWriter.closeElement();
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.xmlWriter.startElement("ellipse");
        this.exportReportElement(ellipse);
        this.exportGraphicElement(ellipse);
        this.xmlWriter.closeElement();
    }

    public void exportImage(JRPrintImage image) throws JRException, IOException {
        this.xmlWriter.startElement("image");
        this.xmlWriter.addAttribute("scaleImage", image.getOwnScaleImageValue());
        this.xmlWriter.addAttribute("hAlign", image.getOwnHorizontalAlignmentValue());
        this.xmlWriter.addAttribute("vAlign", image.getOwnVerticalAlignmentValue());
        this.xmlWriter.addAttribute("isLazy", image.isLazy(), false);
        this.xmlWriter.addAttribute("onErrorType", image.getOnErrorTypeValue(), OnErrorTypeEnum.ERROR);
        if (this.hyperlinkProducerFactory == null) {
            this.xmlWriter.addEncodedAttribute("hyperlinkType", image.getLinkType(), HyperlinkTypeEnum.NONE.getName());
            this.xmlWriter.addEncodedAttribute("hyperlinkReference", image.getHyperlinkReference());
            this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", image.getHyperlinkAnchor());
            this.xmlWriter.addAttribute("hyperlinkPage", image.getHyperlinkPage());
        } else {
            String reference = this.hyperlinkProducerFactory.produceHyperlink(image);
            if (reference != null) {
                this.xmlWriter.addAttribute("hyperlinkType", HyperlinkTypeEnum.REFERENCE);
                this.xmlWriter.addEncodedAttribute("hyperlinkReference", reference);
            }
        }
        this.xmlWriter.addAttribute("hyperlinkTarget", image.getLinkTarget(), HyperlinkTargetEnum.SELF.getName());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", image.getHyperlinkTooltip());
        this.xmlWriter.addEncodedAttribute("anchorName", image.getAnchorName());
        this.xmlWriter.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.exportReportElement(image);
        this.exportBox(image.getLineBox());
        this.exportGraphicElement(image);
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            this.xmlWriter.startElement("imageSource");
            this.xmlWriter.addAttribute("isEmbedded", this.isEmbeddingImages && !image.isLazy(), false);
            String imageSource = "";
            if (renderer.getType() == 1) {
                renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
            }
            if (image.isLazy()) {
                imageSource = ((JRImageRenderer)renderer).getImageLocation();
            } else if (this.isEmbeddingImages) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder(bais, baos);
                    encoder.process();
                    imageSource = new String(baos.toByteArray(), DEFAULT_XML_ENCODING);
                }
                catch (IOException e2) {
                    throw new JRException("Error embedding image into XML.", e2);
                }
            } else if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer)) {
                imageSource = this.rendererToImagePathMap.get(renderer);
            } else {
                imageSource = IMAGE_PREFIX + JRXmlExporter.getNextImageId();
                this.imageNameToImageDataMap.put(imageSource, renderer.getImageData());
                imageSource = new File(this.imagesDir, imageSource).getPath();
                this.rendererToImagePathMap.put(renderer, imageSource);
            }
            this.xmlWriter.writeCDATA(imageSource);
            this.xmlWriter.closeElement();
        }
        if (this.hyperlinkProducerFactory == null) {
            this.exportHyperlinkParameters(image);
        }
        this.xmlWriter.closeElement();
    }

    public void exportText(JRPrintText text) throws IOException {
        this.xmlWriter.startElement("text");
        this.xmlWriter.addAttribute("textAlignment", text.getOwnHorizontalAlignmentValue());
        this.xmlWriter.addAttribute("verticalAlignment", text.getOwnVerticalAlignmentValue());
        this.xmlWriter.addAttribute("textHeight", text.getTextHeight());
        this.xmlWriter.addAttribute("rotation", text.getOwnRotationValue());
        this.xmlWriter.addAttribute("runDirection", text.getRunDirectionValue(), RunDirectionEnum.LTR);
        this.xmlWriter.addAttribute("markup", text.getOwnMarkup());
        this.xmlWriter.addAttribute("lineSpacingFactor", text.getLineSpacingFactor(), 0.0f);
        this.xmlWriter.addAttribute("leadingOffset", text.getLeadingOffset(), 0.0f);
        if (this.hyperlinkProducerFactory == null) {
            this.xmlWriter.addEncodedAttribute("hyperlinkType", text.getLinkType());
            this.xmlWriter.addEncodedAttribute("hyperlinkReference", text.getHyperlinkReference());
            this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", text.getHyperlinkAnchor());
            this.xmlWriter.addAttribute("hyperlinkPage", text.getHyperlinkPage());
        } else {
            String reference = this.hyperlinkProducerFactory.produceHyperlink(text);
            if (reference != null) {
                this.xmlWriter.addAttribute("hyperlinkType", HyperlinkTypeEnum.REFERENCE);
                this.xmlWriter.addEncodedAttribute("hyperlinkReference", reference);
            }
        }
        this.xmlWriter.addAttribute("hyperlinkTarget", text.getLinkTarget());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", text.getHyperlinkTooltip());
        this.xmlWriter.addEncodedAttribute("anchorName", text.getAnchorName());
        this.xmlWriter.addAttribute("bookmarkLevel", text.getBookmarkLevel(), 0);
        this.xmlWriter.addAttribute("valueClass", text.getValueClassName());
        this.xmlWriter.addEncodedAttribute("pattern", text.getPattern());
        this.xmlWriter.addAttribute("formatFactoryClass", text.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", text.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", text.getTimeZoneId());
        this.exportReportElement(text);
        this.exportBox(text.getLineBox());
        this.exportFont(text);
        this.exportParagraph(text.getParagraph());
        if (text.getOriginalText() != null) {
            this.xmlWriter.writeCDATAElement("textContent", text.getOriginalText(), "truncateIndex", text.getTextTruncateIndex());
        }
        this.xmlWriter.writeCDATAElement("textTruncateSuffix", text.getTextTruncateSuffix());
        short[] lineBreakOffsets = text.getLineBreakOffsets();
        if (lineBreakOffsets != null) {
            StringBuffer offsetsString = this.formatTextLineBreakOffsets(lineBreakOffsets);
            this.xmlWriter.writeCDATAElement("lineBreakOffsets", offsetsString.toString());
        }
        if (this.hyperlinkProducerFactory == null) {
            this.exportHyperlinkParameters(text);
        }
        this.xmlWriter.closeElement();
    }

    protected StringBuffer formatTextLineBreakOffsets(short[] lineBreakOffsets) {
        StringBuffer offsetsString = new StringBuffer();
        for (int i2 = 0; i2 < lineBreakOffsets.length; ++i2) {
            if (i2 > 0) {
                offsetsString.append(",");
            }
            offsetsString.append(lineBreakOffsets[i2]);
        }
        return offsetsString;
    }

    private void exportBox(JRLineBox box) throws IOException {
        if (box != null) {
            this.xmlWriter.startElement("box");
            this.xmlWriter.addAttribute("padding", box.getOwnPadding());
            this.xmlWriter.addAttribute("topPadding", box.getOwnTopPadding());
            this.xmlWriter.addAttribute("leftPadding", box.getOwnLeftPadding());
            this.xmlWriter.addAttribute("bottomPadding", box.getOwnBottomPadding());
            this.xmlWriter.addAttribute("rightPadding", box.getOwnRightPadding());
            this.exportPen("pen", box.getPen());
            this.exportPen("topPen", box.getTopPen());
            this.exportPen("leftPen", box.getLeftPen());
            this.exportPen("bottomPen", box.getBottomPen());
            this.exportPen("rightPen", box.getRightPen());
            this.xmlWriter.closeElement(true);
        }
    }

    private void exportParagraph(JRParagraph paragraph) throws IOException {
        if (paragraph != null) {
            this.xmlWriter.startElement("paragraph");
            this.xmlWriter.addAttribute("lineSpacing", paragraph.getOwnLineSpacing());
            this.xmlWriter.addAttribute("lineSpacingSize", paragraph.getOwnLineSpacingSize());
            this.xmlWriter.addAttribute("firstLineIndent", paragraph.getOwnFirstLineIndent());
            this.xmlWriter.addAttribute("leftIndent", paragraph.getOwnLeftIndent());
            this.xmlWriter.addAttribute("rightIndent", paragraph.getOwnRightIndent());
            this.xmlWriter.addAttribute("spacingBefore", paragraph.getOwnSpacingBefore());
            this.xmlWriter.addAttribute("spacingAfter", paragraph.getOwnSpacingAfter());
            this.xmlWriter.addAttribute("tabStopWidth", paragraph.getOwnTabStopWidth());
            TabStop[] tabStops = paragraph.getTabStops();
            if (tabStops != null && tabStops.length > 0) {
                for (int i2 = 0; i2 < tabStops.length; ++i2) {
                    this.exportTabStop(tabStops[i2]);
                }
            }
            this.xmlWriter.closeElement(true);
        }
    }

    public void exportTabStop(TabStop tabStop) throws IOException {
        if (tabStop != null) {
            this.xmlWriter.startElement("tabStop");
            this.xmlWriter.addAttribute("position", tabStop.getPosition());
            this.xmlWriter.addAttribute("alignment", tabStop.getAlignment());
            this.xmlWriter.closeElement(true);
        }
    }

    protected void exportFont(JRFont font) throws IOException {
        if (font != null) {
            this.xmlWriter.startElement("font");
            this.xmlWriter.addEncodedAttribute("fontName", font.getOwnFontName());
            this.xmlWriter.addAttribute("size", font.getOwnFontSize());
            this.xmlWriter.addAttribute("isBold", font.isOwnBold());
            this.xmlWriter.addAttribute("isItalic", font.isOwnItalic());
            this.xmlWriter.addAttribute("isUnderline", font.isOwnUnderline());
            this.xmlWriter.addAttribute("isStrikeThrough", font.isOwnStrikeThrough());
            this.xmlWriter.addEncodedAttribute("pdfFontName", font.getOwnPdfFontName());
            this.xmlWriter.addEncodedAttribute("pdfEncoding", font.getOwnPdfEncoding());
            this.xmlWriter.addAttribute("isPdfEmbedded", font.isOwnPdfEmbedded());
            this.xmlWriter.closeElement(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        this.xmlWriter.startElement("frame");
        this.setFrameElementsOffset(frame, true);
        try {
            this.exportReportElement(frame);
            this.exportBox(frame.getLineBox());
            this.exportElements(frame.getElements());
            this.xmlWriter.closeElement();
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private static synchronized int getNextImageId() {
        return imageId++;
    }

    protected void exportHyperlinkParameters(JRPrintHyperlink hyperlink) throws IOException {
        JRPrintHyperlinkParameters hyperlinkParameters = hyperlink.getHyperlinkParameters();
        if (hyperlinkParameters != null) {
            for (JRPrintHyperlinkParameter parameter : hyperlinkParameters.getParameters()) {
                this.exportHyperlinkParameter(parameter);
            }
        }
    }

    protected void exportHyperlinkParameter(JRPrintHyperlinkParameter parameter) throws IOException {
        this.xmlWriter.startElement("hyperlinkParameter");
        this.xmlWriter.addEncodedAttribute("name", parameter.getName());
        this.xmlWriter.addAttribute("class", parameter.getValueClass(), DEFAULT_OBJECT_TYPE);
        if (parameter.getValue() != null) {
            String data = JRValueStringUtils.serialize(parameter.getValueClass(), parameter.getValue());
            this.xmlWriter.writeCDATAElement("hyperlinkParameterValue", data);
        }
        this.xmlWriter.closeElement();
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        GenericElementXmlHandler handler = (GenericElementXmlHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), this.getExporterKey());
        if (handler != null) {
            handler.exportElement(this.exporterContext, element);
        } else {
            this.xmlWriter.startElement("genericElement");
            this.exportReportElement(element);
            JRGenericElementType genericType = element.getGenericType();
            this.xmlWriter.startElement("genericElementType");
            this.xmlWriter.addEncodedAttribute("namespace", genericType.getNamespace());
            this.xmlWriter.addEncodedAttribute("name", genericType.getName());
            this.xmlWriter.closeElement();
            Set<String> names = element.getParameterNames();
            for (String name : names) {
                Object value = element.getParameterValue(name);
                this.xmlWriter.startElement("genericElementParameter");
                this.xmlWriter.addAttribute("name", name);
                if (value != null) {
                    String valueClass = value.getClass().getName();
                    boolean builtinSerialization = JRValueStringUtils.hasSerializer(valueClass);
                    if (!builtinSerialization) {
                        boolean bl = builtinSerialization = !XmlValueHandlerUtils.instance().writeToXml(value, this);
                    }
                    if (builtinSerialization) {
                        String data = JRValueStringUtils.serialize(valueClass, value);
                        this.xmlWriter.startElement("genericElementParameterValue");
                        this.xmlWriter.addAttribute("class", valueClass);
                        this.xmlWriter.writeCDATA(data);
                        this.xmlWriter.closeElement();
                    }
                }
                this.xmlWriter.closeElement();
            }
            this.xmlWriter.closeElement();
        }
    }

    protected String getExporterPropertiesPrefix() {
        return XML_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    protected String getExporterKey() {
        return XML_EXPORTER_KEY;
    }

    public JRXmlWriteHelper getXmlWriteHelper() {
        return this.xmlWriter;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXmlExporterContext {
        protected ExporterContext() {
        }

        public String getExportPropertiesPrefix() {
            return JRXmlExporter.this.getExporterPropertiesPrefix();
        }
    }
}

