/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.data.ListOfArrayDataSource;
import net.sf.jasperreports.engine.fill.DataSourceComparator;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.SortFieldInfo;
import net.sf.jasperreports.engine.fill.SortFillDatasetRun;
import net.sf.jasperreports.engine.fill.SortInfo;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class DatasetSortUtil {
    public static JRSortField[] getAllSortFields(JRFillDataset dataset) {
        List dynamicSortFields;
        ArrayList<JRSortField> allSortFields = new ArrayList<JRSortField>();
        JRSortField[] staticSortFields = dataset.getSortFields();
        if (staticSortFields != null) {
            allSortFields.addAll(Arrays.asList(staticSortFields));
        }
        if ((dynamicSortFields = (List)dataset.getParameterValue("SORT_FIELDS", true)) != null) {
            allSortFields.addAll(dynamicSortFields);
        }
        return allSortFields.toArray(new JRSortField[allSortFields.size()]);
    }

    public static boolean needSorting(JRFillDataset dataset) {
        JRSortField[] staticSortFields = dataset.getSortFields();
        List dynamicSortFields = (List)dataset.getParameterValue("SORT_FIELDS", true);
        return staticSortFields != null && staticSortFields.length > 0 || dynamicSortFields != null && dynamicSortFields.size() > 0;
    }

    public static JRDataSource getSortedDataSource(JRBaseFiller filler, JRFillDataset dataset, Locale locale) throws JRException {
        SortInfo sortInfo = DatasetSortUtil.createSortInfo(dataset);
        SortFillDatasetRun sortDatasetRun = new SortFillDatasetRun(filler, dataset, sortInfo);
        List<Object[]> records = sortDatasetRun.sort();
        Collections.sort(records, new DataSourceComparator(sortInfo.sortFieldInfo, locale));
        return new ListOfArrayDataSource(records, sortInfo.fieldNames.toArray(new String[sortInfo.fieldNames.size()]));
    }

    private static SortInfo createSortInfo(JRFillDataset dataset) throws JRException {
        JRSortField[] sortFields;
        SortInfo sortInfo = new SortInfo();
        HashMap<String, JRField> fieldsMap = new HashMap<String, JRField>();
        HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>();
        JRField[] fields = dataset.getFields();
        if (fields != null) {
            for (int i2 = 0; i2 < fields.length; ++i2) {
                JRField field = fields[i2];
                fieldsMap.put(field.getName(), field);
                fieldIndexMap.put(field.getName(), i2);
                sortInfo.fieldNames.add(field.getName());
            }
        }
        HashMap<String, JRVariable> variablesMap = new HashMap<String, JRVariable>();
        JRVariable[] variables = dataset.getVariables();
        if (variables != null) {
            for (int i3 = 0; i3 < variables.length; ++i3) {
                variablesMap.put(variables[i3].getName(), variables[i3]);
            }
        }
        if ((sortFields = DatasetSortUtil.getAllSortFields(dataset)) != null) {
            sortInfo.sortFieldInfo = new SortFieldInfo[sortFields.length];
            for (int i4 = 0; i4 < sortFields.length; ++i4) {
                Integer index;
                JRSortField sortField = sortFields[i4];
                String sortFieldName = sortField.getName();
                SortFieldInfo info = new SortFieldInfo();
                info.name = sortFieldName;
                info.isVariable = sortField.getType() == SortFieldTypeEnum.VARIABLE;
                int n2 = info.order = SortOrderEnum.ASCENDING == sortField.getOrderValue() ? 1 : -1;
                if (info.isVariable) {
                    JRVariable variable = (JRVariable)variablesMap.get(sortFieldName);
                    if (variable == null) {
                        throw new JRRuntimeException("Sort variable \"" + sortFieldName + "\" not found in dataset.");
                    }
                    index = new Integer(sortInfo.fieldNames.size());
                    info.collatorFlag = String.class.getName().equals(variable.getValueClassName());
                    sortInfo.fieldNames.add(variable.getName());
                } else {
                    JRField field = (JRField)fieldsMap.get(sortFieldName);
                    if (field == null) {
                        throw new JRRuntimeException("Sort field \"" + sortFieldName + "\" not found in dataset.");
                    }
                    index = (Integer)fieldIndexMap.get(sortField.getName());
                    info.collatorFlag = String.class.getName().equals(field.getValueClassName());
                }
                info.index = index;
                sortInfo.sortFieldInfo[i4] = info;
            }
        }
        return sortInfo;
    }
}

