/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillGraphicElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private JRGroup evaluationGroup;
    private JRRenderable renderer;
    private boolean hasOverflowed;
    private Integer imageHeight;
    private Integer imageWidth;
    private Integer imageX;
    private String anchorName;
    private String hyperlinkReference;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected final JRLineBox lineBox;

    protected JRFillImage(JRBaseFiller filler, JRImage image, JRFillObjectFactory factory) {
        super(filler, image, factory);
        this.lineBox = image.getLineBox().clone(this);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
    }

    protected JRFillImage(JRFillImage image, JRFillCloneFactory factory) {
        super(image, factory);
        this.lineBox = image.getLineBox().clone(this);
        this.evaluationGroup = image.evaluationGroup;
    }

    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    public ScaleImageEnum getScaleImageValue() {
        return JRStyleResolver.getScaleImageValue(this);
    }

    public ScaleImageEnum getOwnScaleImageValue() {
        return ((JRImage)this.parent).getOwnScaleImageValue();
    }

    public void setScaleImage(ScaleImageEnum scaleImage) {
        throw new UnsupportedOperationException();
    }

    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return ((JRImage)this.parent).getOwnHorizontalAlignmentValue();
    }

    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return ((JRImage)this.parent).getOwnVerticalAlignmentValue();
    }

    public void setVerticalAlignment(VerticalAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    public boolean isUsingCache() {
        return ((JRImage)this.parent).isUsingCache();
    }

    public Boolean isOwnUsingCache() {
        return ((JRImage)this.parent).isOwnUsingCache();
    }

    public Boolean getUsingCache() {
        return ((JRImage)this.parent).getUsingCache();
    }

    public void setUsingCache(boolean isUsingCache) {
    }

    public void setUsingCache(Boolean isUsingCache) {
    }

    public boolean isLazy() {
        return ((JRImage)this.parent).isLazy();
    }

    public void setLazy(boolean isLazy) {
    }

    public OnErrorTypeEnum getOnErrorTypeValue() {
        return ((JRImage)this.parent).getOnErrorTypeValue();
    }

    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        throw new UnsupportedOperationException();
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return ((JRImage)this.parent).getEvaluationTimeValue();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return ((JRImage)this.parent).getHyperlinkTypeValue();
    }

    public byte getHyperlinkTarget() {
        return ((JRImage)this.parent).getHyperlinkTarget();
    }

    public String getLinkTarget() {
        return ((JRImage)this.parent).getLinkTarget();
    }

    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        return (JRTemplateImage)this.getElementTemplate();
    }

    protected JRTemplateElement createElementTemplate() {
        JRTemplateImage template = new JRTemplateImage(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
        if (this.getScaleImageValue() == ScaleImageEnum.REAL_HEIGHT || this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
            template.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        }
        return template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.hasOverflowed = false;
            this.evaluateImage(evaluation);
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        JRExpression expression = this.getExpression();
        JRRenderable newRenderer = null;
        Object source = this.evaluateExpression(expression, evaluation);
        if (source != null) {
            Boolean isUsingCache = this.getUsingCache();
            if (isUsingCache == null) {
                isUsingCache = source instanceof String;
            }
            if (isUsingCache.booleanValue() && this.filler.fillContext.hasLoadedImage(source)) {
                newRenderer = this.filler.fillContext.getLoadedImage(source).getRenderer();
            } else {
                Object img;
                if (source instanceof Image) {
                    img = (Image)source;
                    newRenderer = JRImageRenderer.getInstance((Image)img, this.getOnErrorTypeValue());
                } else if (source instanceof InputStream) {
                    InputStream is = (InputStream)source;
                    newRenderer = JRImageRenderer.getInstance(is, this.getOnErrorTypeValue());
                } else if (source instanceof URL) {
                    URL url = (URL)source;
                    newRenderer = JRImageRenderer.getInstance(url, this.getOnErrorTypeValue());
                } else if (source instanceof File) {
                    File file = (File)source;
                    newRenderer = JRImageRenderer.getInstance(file, this.getOnErrorTypeValue());
                } else if (source instanceof String) {
                    String location = (String)source;
                    newRenderer = JRImageRenderer.getInstance(location, this.getOnErrorTypeValue(), this.isLazy());
                } else {
                    newRenderer = source instanceof JRRenderable ? (JRRenderable)source : JRImageRenderer.getOnErrorRenderer(this.getOnErrorTypeValue(), new JRException("Unknown image source class " + source.getClass().getName()));
                }
                if (isUsingCache.booleanValue()) {
                    img = new JRTemplatePrintImage(this.getJRTemplateImage(), this.elementId);
                    img.setRenderer(newRenderer);
                    this.filler.fillContext.registerLoadedImage(source, (JRPrintImage)img);
                }
            }
        }
        this.setValueRepeating(this.renderer == newRenderer);
        this.renderer = newRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
    }

    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.isEvaluateNow()) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
                isToPrint = false;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableHeight < this.getRelativeY() + this.getHeight()) {
                    isToPrint = false;
                    willOverflow = true;
                } else if (!(this.isLazy() || this.getScaleImageValue() != ScaleImageEnum.REAL_HEIGHT && this.getScaleImageValue() != ScaleImageEnum.REAL_SIZE)) {
                    int padding = this.getLineBox().getBottomPadding() + this.getLineBox().getTopPadding();
                    boolean reprinted = isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues());
                    boolean imageOverflowAllowed = this.filler.isBandOverFlowAllowed() && !reprinted && !this.hasOverflowed;
                    boolean fits = this.fitImage(availableHeight - this.getRelativeY() - padding, imageOverflowAllowed, this.getHorizontalAlignmentValue());
                    if (fits) {
                        if (this.imageHeight != null) {
                            this.setStretchHeight(this.imageHeight + padding);
                        }
                    } else {
                        this.hasOverflowed = true;
                        isToPrint = false;
                        willOverflow = true;
                        this.setStretchHeight(availableHeight - this.getRelativeY() - padding);
                    }
                }
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected void reset() {
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        super.reset();
    }

    protected boolean fitImage(int availableHeight, boolean overflowAllowed, HorizontalAlignEnum hAlign) throws JRException {
        boolean fitted;
        Dimension2D imageSize;
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        Dimension2D dimension2D = imageSize = this.renderer == null ? null : this.renderer.getDimension();
        if (imageSize == null) {
            return true;
        }
        int realHeight = (int)imageSize.getHeight();
        int realWidth = (int)imageSize.getWidth();
        int reducedHeight = realHeight;
        int reducedWidth = realWidth;
        if (realWidth > this.getWidth()) {
            double wRatio = (double)this.getWidth() / (double)realWidth;
            reducedHeight = (int)(wRatio * (double)realHeight);
            reducedWidth = this.getWidth();
        }
        if (reducedHeight <= availableHeight) {
            this.imageHeight = reducedHeight;
            if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
                this.imageWidth = reducedWidth;
            }
            fitted = true;
        } else if (overflowAllowed) {
            fitted = false;
        } else {
            this.imageHeight = availableHeight;
            if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
                double hRatio = (double)availableHeight / (double)realHeight;
                this.imageWidth = (int)(hRatio * (double)realWidth);
            }
            fitted = true;
        }
        if (this.imageWidth != null && this.imageWidth.intValue() != this.getWidth()) {
            switch (hAlign) {
                case RIGHT: {
                    this.imageX = this.getX() + this.getWidth() - this.imageWidth;
                    break;
                }
                case CENTER: {
                    this.imageX = this.getX() + (this.getWidth() - this.imageWidth) / 2;
                    break;
                }
            }
        }
        return fitted;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage printImage;
        JRRecordedValuesPrintImage recordedValuesImage;
        EvaluationTimeEnum evaluationTime = this.getEvaluationTimeValue();
        if (this.isEvaluateAuto()) {
            recordedValuesImage = new JRRecordedValuesPrintImage(this.getJRTemplateImage(), this.elementId);
            printImage = recordedValuesImage;
        } else {
            printImage = new JRTemplatePrintImage(this.getJRTemplateImage(), this.elementId);
            recordedValuesImage = null;
        }
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        if (this.isEvaluateNow()) {
            this.copy(printImage);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(recordedValuesImage);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printImage, evaluationTime, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        if (this.imageX != null) {
            printImage.setX(this.imageX);
        }
        if (this.imageWidth != null) {
            printImage.setWidth(this.imageWidth);
        }
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
        this.transferProperties(printImage);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateImage(evaluation);
        JRPrintImage printImage = (JRPrintImage)element;
        if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
            int padding = printImage.getLineBox().getBottomPadding() + printImage.getLineBox().getTopPadding();
            this.fitImage(this.getHeight() - padding, false, printImage.getHorizontalAlignmentValue());
        }
        this.copy(printImage);
    }

    public int getBookmarkLevel() {
        return ((JRImage)this.parent).getBookmarkLevel();
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillImage(this, factory);
    }

    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRImage)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRImage)this.parent).getLinkType();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRImage)this.parent).getHyperlinkTooltipExpression();
    }
}

