/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.VirtualizationListener;
import net.sf.jasperreports.engine.util.DeepPrintElementVisitor;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.UniformPrintElementVisitor;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRVirtualizationContext
implements Serializable,
VirtualizationListener<VirtualElementsData> {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(JRVirtualizationContext.class);
    private static final ReferenceMap contexts = new ReferenceMap(2, 2);
    private transient JRVirtualizer virtualizer;
    private Map<String, JRRenderable> cachedRenderers;
    private Map<String, JRTemplateElement> cachedTemplates;
    private boolean readOnly;
    private int pageElementSize;
    private transient List<VirtualizationListener<VirtualElementsData>> listeners;
    private volatile transient PrintElementVisitor<Void> cacheTemplateVisitor;

    public JRVirtualizationContext() {
        this.cachedRenderers = new HashMap<String, JRRenderable>();
        this.cachedTemplates = new HashMap<String, JRTemplateElement>();
        this.pageElementSize = JRProperties.getIntegerProperty("net.sf.jasperreports.virtual.page.element.size", 0);
    }

    protected JRVirtualizationContext(JRVirtualizationContext parentContext) {
        this.virtualizer = parentContext.virtualizer;
        this.cachedRenderers = parentContext.cachedRenderers;
        this.cachedTemplates = parentContext.cachedTemplates;
        this.pageElementSize = parentContext.pageElementSize;
    }

    public void addListener(VirtualizationListener<VirtualElementsData> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<VirtualizationListener<VirtualElementsData>>(1);
        }
        this.listeners.add(listener);
    }

    public void removeListener(VirtualizationListener<VirtualElementsData> listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void beforeExternalization(JRVirtualizable<VirtualElementsData> object) {
        if (this.listeners != null) {
            for (VirtualizationListener<VirtualElementsData> listener : this.listeners) {
                listener.beforeExternalization(object);
            }
        }
    }

    public void afterExternalization(JRVirtualizable<VirtualElementsData> object) {
    }

    @Override
    public void afterInternalization(JRVirtualizable<VirtualElementsData> object) {
        if (this.listeners != null) {
            for (VirtualizationListener<VirtualElementsData> listener : this.listeners) {
                listener.afterInternalization(object);
            }
        }
    }

    public void cacheRenderer(JRPrintImage image) {
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            this.cachedRenderers.put(renderer.getId(), renderer);
        }
    }

    public JRRenderable getCachedRenderer(String id) {
        return this.cachedRenderers.get(id);
    }

    public boolean hasCachedRenderer(String id) {
        return this.cachedRenderers.containsKey(id);
    }

    public boolean hasCachedTemplate(String id) {
        return this.cachedTemplates.containsKey(id);
    }

    public void cacheTemplate(JRTemplateElement template) {
        JRTemplateElement old = this.cachedTemplates.put(template.getId(), template);
        if (old == null && log.isDebugEnabled()) {
            log.debug("Cached template " + template + " having id " + template.getId());
        }
    }

    public JRTemplateElement getCachedTemplate(String templateId) {
        return this.cachedTemplates.get(templateId);
    }

    public void cacheTemplate(JRPrintElement element) {
        if (this.cacheTemplateVisitor == null) {
            this.cacheTemplateVisitor = new CacheTemplateVisitor();
        }
        element.accept(this.cacheTemplateVisitor, null);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(JRVirtualizationContext context, JasperPrint print) {
        ReferenceMap referenceMap = contexts;
        synchronized (referenceMap) {
            contexts.put(print, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRVirtualizationContext getRegistered(JasperPrint print) {
        ReferenceMap referenceMap = contexts;
        synchronized (referenceMap) {
            return (JRVirtualizationContext)contexts.get(print);
        }
    }

    public int getPageElementSize() {
        return this.pageElementSize;
    }

    public void setPageElementSize(int pageElementSize) {
        this.pageElementSize = pageElementSize;
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    protected void setVirtualizer(JRVirtualizer virtualizer) {
        this.virtualizer = virtualizer;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.cachedRenderers = (Map)fields.get("cachedRenderers", null);
        this.cachedTemplates = (Map)fields.get("cachedTemplates", null);
        this.readOnly = fields.get("readOnly", false);
        this.pageElementSize = fields.get("pageElementSize", JRProperties.getIntegerProperty("net.sf.jasperreports.virtual.page.element.size", 0));
        this.setThreadVirtualizer();
    }

    private void setThreadVirtualizer() {
        JRVirtualizer threadVirtualizer = JRVirtualizationHelper.getThreadVirtualizer();
        if (threadVirtualizer != null) {
            this.virtualizer = threadVirtualizer;
        }
    }

    protected void traverseDeepElements(PrintElementVisitor<Void> visitor, Collection<? extends JRPrintElement> elements) {
        DeepPrintElementVisitor<Void> deepVisitor = new DeepPrintElementVisitor<Void>(visitor);
        for (JRPrintElement jRPrintElement : elements) {
            jRPrintElement.accept(deepVisitor, null);
        }
    }

    public Object replaceSerializedObject(Object obj) {
        JRRenderable renderer;
        Object replace = obj;
        if (obj instanceof JRTemplateElement) {
            JRTemplateElement template = (JRTemplateElement)obj;
            String templateId = template.getId();
            if (this.hasCachedTemplate(templateId)) {
                replace = new JRVirtualPrintPage.JRIdHolderTemplateElement(templateId);
            } else if (log.isDebugEnabled()) {
                log.debug("Template " + template + " having id " + template.getId() + " not found in virtualization context cache");
            }
        } else if (obj instanceof JRRenderable && this.hasCachedRenderer((renderer = (JRRenderable)obj).getId())) {
            replace = new JRVirtualPrintPage.JRIdHolderRenderer(renderer);
        }
        return replace;
    }

    public Object resolveSerializedObject(Object obj) {
        Object resolve = obj;
        if (obj instanceof JRVirtualPrintPage.JRIdHolderTemplateElement) {
            JRVirtualPrintPage.JRIdHolderTemplateElement template = (JRVirtualPrintPage.JRIdHolderTemplateElement)obj;
            JRTemplateElement cachedTemplate = this.getCachedTemplate(template.getId());
            if (cachedTemplate == null) {
                throw new JRRuntimeException("Template " + template.getId() + " not found in virtualization context.");
            }
            resolve = cachedTemplate;
        } else if (obj instanceof JRVirtualPrintPage.JRIdHolderRenderer) {
            JRVirtualPrintPage.JRIdHolderRenderer renderer = (JRVirtualPrintPage.JRIdHolderRenderer)obj;
            JRRenderable cachedRenderer = this.getCachedRenderer(renderer.getId());
            if (cachedRenderer == null) {
                throw new JRRuntimeException("Renderer " + renderer.getId() + " not found in virtualization context.");
            }
            resolve = cachedRenderer;
        }
        return resolve;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheTemplateVisitor
    extends UniformPrintElementVisitor<Void> {
        public CacheTemplateVisitor() {
            super(true);
        }

        @Override
        protected void visitElement(JRPrintElement element, Void arg) {
            JRTemplatePrintElement templateElement;
            JRTemplateElement template;
            if (element instanceof JRTemplatePrintElement && (template = (templateElement = (JRTemplatePrintElement)element).getTemplate()) != null) {
                JRVirtualizationContext.this.cacheTemplate(template);
            }
        }
    }
}

