/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRCsvQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRCsvQueryExecuter.class);
    private JRCsvDataSource datasource;

    protected JRCsvQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(dataset, parametersMap);
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        String csvCharset = this.getStringParameterOrProperty("net.sf.jasperreports.csv.encoding");
        try {
            Reader csvReader = (Reader)this.getParameterValue("CSV_READER");
            if (csvReader != null) {
                this.datasource = new JRCsvDataSource(csvReader);
            } else {
                InputStream csvInputStream = (InputStream)this.getParameterValue("CSV_INPUT_STREAM");
                if (csvInputStream != null) {
                    this.datasource = csvCharset != null ? new JRCsvDataSource(csvInputStream, csvCharset) : new JRCsvDataSource(csvInputStream);
                } else {
                    File csvFile = (File)this.getParameterValue("CSV_FILE");
                    if (csvFile != null) {
                        this.datasource = csvCharset != null ? new JRCsvDataSource(csvFile, csvCharset) : new JRCsvDataSource(csvFile);
                    } else {
                        URL csvUrl = (URL)this.getParameterValue("CSV_URL");
                        if (csvUrl != null) {
                            this.datasource = csvCharset != null ? new JRCsvDataSource(csvUrl, csvCharset) : new JRCsvDataSource(csvUrl);
                        } else {
                            String csvSource = this.getStringParameterOrProperty("net.sf.jasperreports.csv.source");
                            if (csvSource != null) {
                                this.datasource = csvCharset != null ? new JRCsvDataSource(csvSource, csvCharset) : new JRCsvDataSource(csvSource);
                            } else if (log.isWarnEnabled()) {
                                log.warn("No CSV source was provided.");
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new JRException(e2);
        }
        if (this.datasource != null) {
            String recordDelimiter;
            List<Object> columnNamesList = null;
            String columnNames = this.getStringParameterOrProperty("net.sf.jasperreports.csv.column.names");
            if (columnNames != null) {
                columnNamesList = new ArrayList<String>();
                columnNamesList.add(columnNames);
            } else {
                String[] columnNamesArray = (String[])this.getParameterValue("CSV_COLUMN_NAMES_ARRAY", true);
                if (columnNamesArray != null) {
                    columnNamesList = Arrays.asList(columnNamesArray);
                } else {
                    List<JRProperties.PropertySuffix> properties = JRProperties.getAllProperties(this.dataset, "net.sf.jasperreports.csv.column.names");
                    if (properties != null && !properties.isEmpty()) {
                        columnNamesList = new ArrayList();
                        for (int i2 = 0; i2 < properties.size(); ++i2) {
                            String property = properties.get(i2).getValue();
                            columnNamesList.add(property);
                        }
                    } else {
                        JRField[] fields = this.dataset.getFields();
                        if (fields != null && fields.length > 0) {
                            columnNamesList = new ArrayList();
                            for (int i3 = 0; i3 < fields.length; ++i3) {
                                columnNamesList.add(fields[i3].getName());
                            }
                        }
                    }
                }
            }
            if (columnNamesList != null && columnNamesList.size() > 0) {
                ArrayList<String> splitColumnNamesList = new ArrayList<String>();
                for (int i4 = 0; i4 < columnNamesList.size(); ++i4) {
                    String names = (String)columnNamesList.get(i4);
                    for (String token : names.split(",")) {
                        splitColumnNamesList.add(token.trim());
                    }
                }
                this.datasource.setColumnNames(splitColumnNamesList.toArray(new String[splitColumnNamesList.size()]));
            } else if (log.isWarnEnabled()) {
                log.warn("No column names were specified.");
            }
            DateFormat dateFormat = (DateFormat)this.getParameterValue("CSV_DATE_FORMAT", true);
            if (dateFormat != null) {
                this.datasource.setDateFormat(dateFormat);
            } else {
                String dateFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.csv.date.pattern");
                if (dateFormatPattern != null) {
                    this.datasource.setDatePattern(dateFormatPattern);
                }
            }
            NumberFormat numberFormat = (NumberFormat)this.getParameterValue("CSV_NUMBER_FORMAT", true);
            if (numberFormat != null) {
                this.datasource.setNumberFormat(numberFormat);
            } else {
                String numberFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.csv.number.pattern");
                if (numberFormatPattern != null) {
                    this.datasource.setNumberPattern(numberFormatPattern);
                }
            }
            String fieldDelimiter = this.getStringParameterOrProperty("net.sf.jasperreports.csv.field.delimiter");
            if (fieldDelimiter != null && fieldDelimiter.length() > 0) {
                this.datasource.setFieldDelimiter(fieldDelimiter.charAt(0));
            }
            if ((recordDelimiter = this.getStringParameterOrProperty("net.sf.jasperreports.csv.record.delimiter")) != null) {
                this.datasource.setRecordDelimiter(recordDelimiter);
            }
            this.datasource.setUseFirstRowAsHeader(this.getBooleanParameterOrProperty("CSV_USE_FIRST_ROW_AS_HEADER", false));
            Locale csvLocale = (Locale)this.getParameterValue("REPORT_LOCALE", true);
            if (csvLocale != null) {
                this.datasource.setLocale(csvLocale);
            } else {
                String csvLocaleCode = this.getStringParameterOrProperty("net.sf.jasperreports.csv.locale.code");
                if (csvLocaleCode != null) {
                    this.datasource.setLocale(csvLocaleCode);
                }
            }
            TimeZone csvTimezone = (TimeZone)this.getParameterValue("REPORT_TIME_ZONE", true);
            if (csvTimezone != null) {
                this.datasource.setTimeZone(csvTimezone);
            } else {
                String csvTimezoneId = this.getStringParameterOrProperty("net.sf.jasperreports.csv.timezone.id");
                if (csvTimezoneId != null) {
                    this.datasource.setTimeZone(csvTimezoneId);
                }
            }
        }
        return this.datasource;
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }
}

