/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRCloneUtils {
    public static <T extends JRCloneable> T nullSafeClone(T original) {
        return (T)(original == null ? null : (JRCloneable)original.clone());
    }

    public static <T extends JRCloneable> List<T> cloneList(List<T> items) {
        ArrayList<JRCloneable> clone;
        if (items == null) {
            clone = null;
        } else {
            clone = new ArrayList<JRCloneable>(items.size());
            for (JRCloneable item : items) {
                clone.add(JRCloneUtils.nullSafeClone(item));
            }
        }
        return clone;
    }

    public static <T extends JRCloneable> T[] cloneArray(T[] items) {
        JRCloneable[] clone;
        if (items == null) {
            clone = null;
        } else {
            clone = (JRCloneable[])items.clone();
            ArrayList<T> list = new ArrayList<T>(items.length);
            for (T item : items) {
                list.add(JRCloneUtils.nullSafeClone(item));
            }
            clone = list.toArray(clone);
        }
        return clone;
    }

    private JRCloneUtils() {
    }
}

