/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.util.JRDelegationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRElementsVisitor
extends JRDelegationVisitor {
    public static void visitReport(JRReport report, JRVisitor visitor) {
        JRElementsVisitor reportVisitor = new JRElementsVisitor(visitor);
        reportVisitor.visitReport(report);
    }

    public JRElementsVisitor(JRVisitor visitor) {
        super(visitor);
    }

    public void visitReport(JRReport report) {
        this.visitBand(report.getBackground());
        this.visitBand(report.getTitle());
        this.visitBand(report.getPageHeader());
        this.visitBand(report.getColumnHeader());
        this.visitSection(report.getDetailSection());
        this.visitBand(report.getColumnFooter());
        this.visitBand(report.getPageFooter());
        this.visitBand(report.getLastPageFooter());
        this.visitBand(report.getSummary());
        this.visitBand(report.getNoData());
        JRGroup[] groups = report.getGroups();
        if (groups != null) {
            for (int i2 = 0; i2 < groups.length; ++i2) {
                JRGroup group = groups[i2];
                this.visitSection(group.getGroupHeaderSection());
                this.visitSection(group.getGroupFooterSection());
            }
        }
    }

    protected void visitSection(JRSection section) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null) {
            for (int i2 = 0; i2 < bands.length; ++i2) {
                this.visitBand(bands[i2]);
            }
        }
    }

    protected void visitBand(JRBand band) {
        if (band != null) {
            band.visit(this);
        }
    }

    protected void visitElements(List<JRChild> elements) {
        if (elements != null) {
            for (JRChild child : elements) {
                child.visit(this);
            }
        }
    }

    @Override
    public void visitElementGroup(JRElementGroup elementGroup) {
        super.visitElementGroup(elementGroup);
        this.visitElements(elementGroup.getChildren());
    }

    @Override
    public void visitFrame(JRFrame frame) {
        super.visitFrame(frame);
        this.visitElements(frame.getChildren());
    }

    @Override
    public void visitCrosstab(JRCrosstab crosstab) {
        block6: {
            block5: {
                super.visitCrosstab(crosstab);
                this.visitCrosstabCell(crosstab.getWhenNoDataCell());
                this.visitCrosstabCell(crosstab.getHeaderCell());
                JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
                for (int i2 = 0; i2 < rowGroups.length; ++i2) {
                    JRCrosstabRowGroup rowGroup = rowGroups[i2];
                    this.visitCrosstabCell(rowGroup.getHeader());
                    this.visitCrosstabCell(rowGroup.getTotalHeader());
                }
                JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
                for (int i3 = 0; i3 < columnGroups.length; ++i3) {
                    JRCrosstabColumnGroup columnGroup = columnGroups[i3];
                    this.visitCrosstabCell(columnGroup.getHeader());
                    this.visitCrosstabCell(columnGroup.getTotalHeader());
                }
                if (!(crosstab instanceof JRDesignCrosstab)) break block5;
                List<JRCrosstabCell> cells = ((JRDesignCrosstab)crosstab).getCellsList();
                for (JRCrosstabCell cell : cells) {
                    this.visitCrosstabCell(cell.getContents());
                }
                break block6;
            }
            JRCrosstabCell[][] cells = crosstab.getCells();
            if (cells == null) break block6;
            HashSet<JRCellContents> cellContents = new HashSet<JRCellContents>();
            for (int i4 = 0; i4 < cells.length; ++i4) {
                for (int j2 = 0; j2 < cells[i4].length; ++j2) {
                    JRCrosstabCell cell = cells[i4][j2];
                    if (cell == null || cell.getContents() == null || !cellContents.add(cell.getContents())) continue;
                    this.visitCrosstabCell(cell.getContents());
                }
            }
        }
    }

    protected void visitCrosstabCell(JRCellContents cell) {
        if (cell != null) {
            this.visitElements(cell.getChildren());
        }
    }
}

